/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.antlr.v4.runtime.tree.ParseTree;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.irp.AggregateLister;
import org.harctoolbox.irp.BitDirection;
import org.harctoolbox.irp.IrpInvalidArgumentException;
import org.harctoolbox.irp.IrpObject;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NumberWithDecimals;
import org.harctoolbox.irp.ParserDriver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class GeneralSpec
extends IrpObject
implements AggregateLister {
    private static final int WEIGHT = 0;
    public static final BitDirection DEFAULT_BITDIRECTION = BitDirection.lsb;
    public static final double DEFAULT_FREQUENCY = 38000.0;
    public static final double DEFAULT_UNIT = 1.0;
    private Double frequency = null;
    private Double dutyCycle = null;
    private BitDirection bitDirection = DEFAULT_BITDIRECTION;
    private double unit = 1.0;

    public GeneralSpec(BitDirection bitDirection, Double unit, Double frequency, Double dutyCycle) {
        super(null);
        this.bitDirection = bitDirection;
        this.unit = unit != null ? unit : 1.0;
        this.frequency = frequency;
        this.dutyCycle = dutyCycle;
    }

    public GeneralSpec(BitDirection bitDirection, Double unit, Double frequency) {
        this(bitDirection, unit, frequency, null);
    }

    public GeneralSpec(GeneralSpec src) {
        super(src.getParseTree());
        this.bitDirection = src.bitDirection;
        this.unit = src.unit;
        this.frequency = src.frequency;
        this.dutyCycle = src.dutyCycle;
    }

    public GeneralSpec() {
        this(DEFAULT_BITDIRECTION, 1.0, null, null);
    }

    public GeneralSpec(String str) throws IrpInvalidArgumentException {
        this(new ParserDriver(str));
    }

    private GeneralSpec(ParserDriver parserDriver) throws IrpInvalidArgumentException {
        this(parserDriver.getParser().generalspec());
    }

    public GeneralSpec(IrpParser.ProtocolContext ctx) throws IrpInvalidArgumentException {
        this(ctx.generalspec());
    }

    public GeneralSpec(IrpParser.GeneralspecContext ctx) throws IrpInvalidArgumentException {
        this(ctx.generalspec_list());
    }

    public GeneralSpec(IrpParser.Generalspec_listContext ctx) throws IrpInvalidArgumentException {
        super(ctx);
        Double unitInPeriods = null;
        for (IrpParser.Generalspec_itemContext node : ctx.generalspec_item()) {
            ParseTree item = node.getChild(0);
            if (item instanceof IrpParser.Frequency_itemContext) {
                double kHz = NumberWithDecimals.parse(((IrpParser.Frequency_itemContext)item).number_with_decimals());
                this.frequency = IrCoreUtils.khz2Hz(kHz);
                continue;
            }
            if (item instanceof IrpParser.Unit_itemContext) {
                IrpParser.Unit_itemContext unitItem = (IrpParser.Unit_itemContext)item;
                if (unitItem.getChildCount() == 1 || unitItem.getChild(1).getText().equals("u")) {
                    unitInPeriods = null;
                    this.unit = NumberWithDecimals.parse(unitItem.number_with_decimals());
                    continue;
                }
                unitInPeriods = NumberWithDecimals.parse(unitItem.number_with_decimals());
                continue;
            }
            if (item instanceof IrpParser.Dutycycle_itemContext) {
                this.dutyCycle = IrCoreUtils.percent2real(NumberWithDecimals.parse(((IrpParser.Dutycycle_itemContext)item).number_with_decimals()));
                continue;
            }
            if (!(item instanceof IrpParser.Order_itemContext)) continue;
            this.bitDirection = item.getText().equals("lsb") ? BitDirection.lsb : BitDirection.msb;
        }
        if (unitInPeriods != null) {
            if (IrCoreUtils.approximatelyEquals(this.frequency, 0.0)) {
                throw new IrpInvalidArgumentException("Units in p and frequency == 0 do not go together.");
            }
            this.unit = IrCoreUtils.seconds2microseconds(unitInPeriods / (this.frequency != null ? this.frequency : 38000.0));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GeneralSpec)) {
            return false;
        }
        GeneralSpec other = (GeneralSpec)obj;
        return IrCoreUtils.approximatelyEquals(this.frequency, other.getFrequency()) && IrCoreUtils.approximatelyEquals(this.dutyCycle, other.getDutyCycle()) && IrCoreUtils.approximatelyEquals(this.unit, other.getUnit()) && this.bitDirection == other.getBitDirection();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + IrCoreUtils.hashForDouble(this.frequency);
        hash = 67 * hash + IrCoreUtils.hashForDouble(this.dutyCycle);
        hash = 67 * hash + Objects.hashCode((Object)this.bitDirection);
        hash = 67 * hash + IrCoreUtils.hashForDouble(this.unit);
        return hash;
    }

    public BitDirection getBitDirection() {
        return this.bitDirection;
    }

    public Double getFrequency() {
        return this.frequency;
    }

    public double getFrequencyWitDefault() {
        return this.frequency != null ? this.frequency : 38000.0;
    }

    public double getUnit() {
        return this.unit;
    }

    public Double getDutyCycle() {
        return this.dutyCycle;
    }

    @Override
    public String toIrpString(int radix) {
        return this.toIrpString(false);
    }

    public String toIrpString(boolean usePeriods) {
        StringJoiner joiner = new StringJoiner(",", "{", "}");
        if (this.getFrequency() != null) {
            joiner.add(String.format(Locale.US, "%2.1f", IrCoreUtils.hz2khz(this.getFrequency())) + "k");
        }
        joiner.add(usePeriods && this.getFrequency() != null ? Math.round(IrCoreUtils.us2Periods(this.unit, this.getFrequency())) + "p" : Long.toString(Math.round(this.getUnit())));
        joiner.add(this.getBitDirection().toString());
        if (this.getDutyCycle() != null) {
            joiner.add(Math.round(IrCoreUtils.real2percent(this.getDutyCycle())) + "%");
        }
        return joiner.toString();
    }

    @Override
    public Element toElement(Document document) {
        Element element = super.toElement(document);
        element.setAttribute("frequency", Long.toString(Math.round(this.getFrequencyWitDefault())));
        element.setAttribute("bitDirection", this.getBitDirection().toString());
        element.setAttribute("unit", Long.toString(Math.round(this.getUnit())));
        if (this.getDutyCycle() != null) {
            element.setAttribute("dutyCycle", Long.toString(100L * Math.round(this.getDutyCycle())));
        }
        return element;
    }

    @Override
    public int weight() {
        return 0;
    }

    @Override
    public Map<String, Object> propertiesMap(GeneralSpec generalSpec, NameEngine nameEngine) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("frequency", Math.round(this.frequency));
        if (this.dutyCycle != null) {
            map.put("dutyCycle", this.dutyCycle);
        }
        return map;
    }
}

