/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.Map;
import org.harctoolbox.irp.BitField;
import org.harctoolbox.irp.BitwiseParameter;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.Number;
import org.harctoolbox.irp.ParserDriver;
import org.harctoolbox.irp.PrimaryItem;
import org.harctoolbox.irp.RecognizeData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class InfiniteBitField
extends BitField {
    public static long toLong(long data, long chop, boolean complement) {
        long x = data >> (int)chop;
        if (complement) {
            x ^= 0xFFFFFFFFFFFFFFFFL;
        }
        return x;
    }

    public InfiniteBitField(String str) {
        this(new ParserDriver(str));
    }

    public InfiniteBitField(ParserDriver parserDriver) {
        this((IrpParser.Infinite_bitfieldContext)parserDriver.getParser().bitfield());
    }

    public InfiniteBitField(IrpParser.Infinite_bitfieldContext ctx) {
        this(ctx, PrimaryItem.newPrimaryItem(ctx.primary_item(0)), PrimaryItem.newPrimaryItem(ctx.primary_item(1)), !(ctx.getChild(0) instanceof IrpParser.Primary_itemContext));
    }

    private InfiniteBitField(PrimaryItem data, PrimaryItem chop, boolean complement) {
        this(null, data, chop, complement);
    }

    private InfiniteBitField(IrpParser.Infinite_bitfieldContext ctx, PrimaryItem data, PrimaryItem chop, boolean complement) {
        super(ctx, data, chop, complement);
    }

    @Override
    public InfiniteBitField substituteConstantVariables(Map<String, Long> constantVariables) {
        return new InfiniteBitField(this.getData().substituteConstantVariables(constantVariables), this.getChop().substituteConstantVariables(constantVariables), this.isComplement());
    }

    @Override
    public long toLong(NameEngine nameEngine) throws NameUnassignedException {
        return InfiniteBitField.toLong(this.getData().toLong(nameEngine), this.getChop().toLong(nameEngine), this.isComplement());
    }

    @Override
    public BitwiseParameter toBitwiseParameter(RecognizeData recognizeData) {
        BitwiseParameter payload = this.getData().toBitwiseParameter(recognizeData);
        if (payload == null) {
            return new BitwiseParameter();
        }
        long ch = this.getChop().toBitwiseParameter(recognizeData).longValueExact();
        long value = InfiniteBitField.toLong(payload.getValue(), ch, this.isComplement());
        return new BitwiseParameter(value, payload.getBitmask() >> (int)ch);
    }

    @Override
    public long getWidth(NameEngine nameEngine) {
        return 63L;
    }

    @Override
    protected BitwiseParameter getWidth(RecognizeData nameResolver) throws NameUnassignedException {
        return new BitwiseParameter(63L);
    }

    @Override
    public String toString(NameEngine nameEngine) {
        String dataString;
        String chopString;
        try {
            chopString = Long.toString(this.getChop().toLong(nameEngine));
        }
        catch (NameUnassignedException ex) {
            chopString = this.getChop().toIrpString(10);
        }
        try {
            dataString = Long.toString(this.getData().toLong(nameEngine));
        }
        catch (NameUnassignedException ex) {
            dataString = this.getData().toIrpString(10);
        }
        return (this.isComplement() ? "~" : "") + dataString + "::" + chopString;
    }

    @Override
    public String toIrpString(int radix) {
        return (this.isComplement() ? "~" : "") + this.getData().toIrpString(radix) + "::" + this.getChop().toIrpString(10);
    }

    @Override
    public Element toElement(Document document) {
        Element element = super.toElement(document);
        element.setAttribute("complement", Boolean.toString(this.isComplement()));
        Element dataElement = document.createElement("Data");
        dataElement.appendChild(this.getData().toElement(document));
        element.appendChild(dataElement);
        if (!(this.getChop() instanceof Number) || ((Number)this.getChop()).toLong() != 0L) {
            Element chopElement = document.createElement("Chop");
            chopElement.appendChild(this.getChop().toElement(document));
            element.appendChild(chopElement);
        }
        return element;
    }

    @Override
    public Map<String, Object> propertiesMap(boolean eval, GeneralSpec generalSpec, NameEngine nameEngine) {
        Map<String, Object> map = super.propertiesMap(eval, generalSpec, nameEngine);
        map.put("kind", "InfiniteBitFieldExpression");
        return map;
    }

    @Override
    public Integer numberOfBits() {
        return 0;
    }

    @Override
    public BitwiseParameter invert(BitwiseParameter rhs, RecognizeData recognizeData) throws NameUnassignedException {
        long ch = this.getChop().toLong(recognizeData.getNameEngine());
        long payload = rhs.getValue();
        if (this.isComplement()) {
            payload ^= 0xFFFFFFFFFFFFFFFFL;
        }
        long bitmask = rhs.getBitmask() << (int)ch;
        return new BitwiseParameter(payload <<= (int)ch, bitmask);
    }
}

