/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.irp.AggregateLister;
import org.harctoolbox.irp.BareIrStream;
import org.harctoolbox.irp.BitSpec;
import org.harctoolbox.irp.DurationType;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrStreamItem;
import org.harctoolbox.irp.IrpObject;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.ParameterSpecs;
import org.harctoolbox.irp.ParserDriver;
import org.harctoolbox.irp.RecognizeData;
import org.harctoolbox.irp.RenderData;
import org.harctoolbox.irp.RepeatMarker;
import org.harctoolbox.irp.SignalRecognitionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class IrStream
extends IrpObject
implements IrStreamItem,
AggregateLister {
    private final RepeatMarker repeatMarker;
    private final BareIrStream bareIrStream;

    public IrStream(String str) {
        this(new ParserDriver(str));
    }

    public IrStream(ParserDriver parserDriver) {
        this(parserDriver.getParser().irstream());
    }

    public IrStream(IrpParser.IrstreamContext ctx) {
        super(ctx);
        this.bareIrStream = new BareIrStream(ctx.bare_irstream());
        IrpParser.Repeat_markerContext ctxRepeatMarker = ctx.repeat_marker();
        this.repeatMarker = ctxRepeatMarker != null ? new RepeatMarker(ctxRepeatMarker) : new RepeatMarker();
    }

    public IrStream(List<IrStreamItem> irStreamItems, RepeatMarker repeatMarker) {
        this(new BareIrStream(irStreamItems), repeatMarker);
    }

    public IrStream(BareIrStream bareIrStream, RepeatMarker repeatMarker) {
        super(null);
        this.bareIrStream = bareIrStream;
        this.repeatMarker = repeatMarker;
    }

    public IrStream(BareIrStream bareIrStream) {
        this(bareIrStream, new RepeatMarker());
    }

    public IrStream(List<IrStreamItem> irStreamItems) {
        this(irStreamItems, new RepeatMarker());
    }

    public IrStream() {
        this(new ArrayList<IrStreamItem>(0));
    }

    @Override
    public IrStream substituteConstantVariables(Map<String, Long> constantVariables) {
        return new IrStream((BareIrStream)this.bareIrStream.substituteConstantVariables((Map)constantVariables), this.repeatMarker);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IrStream)) {
            return false;
        }
        IrStream other = (IrStream)obj;
        return this.bareIrStream.equals(other.bareIrStream) && this.repeatMarker.equals(other.repeatMarker);
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + Objects.hashCode(this.repeatMarker);
        hash = 59 * hash + Objects.hashCode(this.bareIrStream);
        return hash;
    }

    public RepeatMarker getRepeatMarker() {
        return this.repeatMarker;
    }

    @Override
    public String toIrpString(int radix) {
        return this.toIrpString(radix, "");
    }

    public String toIrpString(int radix, String separator) {
        return "(" + this.bareIrStream.toIrpString(radix) + ")" + separator + this.repeatMarker.toIrpString(radix);
    }

    public boolean hasRepeatSequence() {
        return this.isRepeatSequence() || this.numberOfInfiniteRepeats() > 0;
    }

    public boolean isRepeatSequence() {
        return this.repeatMarker.isInfinite();
    }

    @Override
    public Element toElement(Document document) {
        Element element = this.bareIrStream.toElement(document, "IrStream");
        if (this.repeatMarker.getMin() != 1) {
            element.setAttribute("repeatMin", Integer.toString(this.repeatMarker.getMin()));
        }
        if (this.repeatMarker.getMax() != 1) {
            element.setAttribute("repeatMax", this.repeatMarker.isInfinite() ? "infinite" : Integer.toString(this.repeatMarker.getMax()));
        }
        element.setAttribute("isRepeat", Boolean.toString(this.isRepeatSequence()));
        if (!this.repeatMarker.isTrivial()) {
            element.appendChild(this.repeatMarker.toElement(document));
        }
        return element;
    }

    @Override
    public Integer numberOfBareDurations() {
        return this.bareIrStream.numberOfBareDurations();
    }

    @Override
    public Integer numberOfBits() {
        return this.bareIrStream.numberOfBits();
    }

    @Override
    public Integer numberOfBitSpecs() {
        return this.bareIrStream.numberOfBitSpecs();
    }

    @Override
    public int numberOfInfiniteRepeats() {
        int noir = this.bareIrStream.numberOfInfiniteRepeats();
        return this.repeatMarker.isInfinite() ? noir + 1 : this.repeatMarker.getMin() * noir;
    }

    @Override
    public void decode(RecognizeData recognizeData, List<BitSpec> bitSpecs, boolean isLast) throws SignalRecognitionException {
        this.bareIrStream.decode(recognizeData, bitSpecs, isLast);
    }

    @Override
    public void createParameterSpecs(ParameterSpecs parameterSpecs) throws InvalidNameException {
        this.bareIrStream.createParameterSpecs(parameterSpecs);
    }

    @Override
    public void updateStateWhenEntering(IrSignal.Pass pass, PassExtractorState state) {
        if (this.isRepeatSequence() && state.getState() == IrSignal.Pass.intro) {
            if (this.hasVariationNonRecursive()) {
                state.setState(pass);
            } else if (pass == IrSignal.Pass.repeat || this.repeatMarker.getMin() == 0) {
                state.setState(IrSignal.Pass.repeat);
            }
        }
    }

    @Override
    public void updateStateWhenExiting(IrSignal.Pass pass, PassExtractorState state) {
        if (this.isRepeatSequence()) {
            state.setState(IrSignal.Pass.ending);
        }
    }

    @Override
    public BareIrStream extractPass(IrSignal.Pass pass, PassExtractorState state) {
        ArrayList<IrStreamItem> list = new ArrayList<IrStreamItem>(20);
        int repetitions = pass == IrSignal.Pass.repeat && this.repeatMarker.isInfinite() ? 1 : (pass == IrSignal.Pass.ending && this.hasVariation(IrSignal.Pass.ending) ? 1 : this.repeatMarker.getMin());
        this.updateStateWhenEntering(pass, state);
        if (repetitions > 0) {
            BareIrStream extractedStream = this.bareIrStream.extractPass(pass, state);
            for (int i = 0; i < repetitions; ++i) {
                list.addAll(extractedStream.getIrStreamItems());
            }
        }
        this.updateStateWhenExiting(pass, state);
        return new BareIrStream(list);
    }

    public BareIrStream extractPass(IrSignal.Pass pass) {
        return this.extractPass(pass, new PassExtractorState(IrSignal.Pass.intro));
    }

    @Override
    public void render(RenderData traverseData, List<BitSpec> bitSpecs) throws NameUnassignedException {
        this.bareIrStream.render(traverseData, bitSpecs);
    }

    @Override
    public Integer numberOfDurations() {
        return this.bareIrStream.numberOfDurations() != null ? Integer.valueOf(this.repeatMarker.getMin() * this.bareIrStream.numberOfDurations()) : null;
    }

    public Integer numberOfDurations(int bitSpecLength) {
        Integer nod = this.bareIrStream.numberOfDurations(bitSpecLength);
        return nod != null ? Integer.valueOf(this.repeatMarker.getMin() * this.bareIrStream.numberOfDurations(bitSpecLength)) : null;
    }

    public boolean hasVariation(IrSignal.Pass pass) {
        return this.bareIrStream.hasVariation(pass);
    }

    public boolean hasVariationNonRecursive() {
        return this.bareIrStream.hasVariationNonRecursive();
    }

    boolean isRPlus() {
        return this.repeatMarker.isRPlus() && !this.hasVariation(null);
    }

    @Override
    public int weight() {
        return this.bareIrStream.weight() + this.repeatMarker.weight();
    }

    @Override
    public Map<String, Object> propertiesMap(GeneralSpec generalSpec, NameEngine nameEngine) {
        int repetitions = this.repeatMarker.getMin();
        if (repetitions == 0) {
            return new HashMap<String, Object>(0);
        }
        HashMap<String, Object> m = new HashMap<String, Object>(2);
        Map<String, Object> body = this.bareIrStream.propertiesMap(generalSpec, nameEngine);
        List items = (List)body.get("items");
        m.put("kind", body.get("kind"));
        ArrayList repeatedList = new ArrayList(repetitions * items.size());
        m.put("items", repeatedList);
        for (int r = 0; r < repetitions; ++r) {
            repeatedList.addAll(items);
        }
        return m;
    }

    @Override
    public boolean isEmpty(NameEngine nameEngine) {
        return this.bareIrStream.isEmpty(nameEngine);
    }

    @Override
    public boolean interleavingOk(DurationType last, boolean gapFlashBitSpecs) {
        return this.bareIrStream.interleavingOk(last, gapFlashBitSpecs);
    }

    @Override
    public boolean interleavingOk(DurationType toCheck, DurationType last, boolean gapFlashBitSpecs) {
        return this.bareIrStream.interleavingOk(toCheck, last, gapFlashBitSpecs);
    }

    @Override
    public DurationType endingDurationType(DurationType last, boolean gapFlashBitSpecs) {
        return this.bareIrStream.endingDurationType(last, gapFlashBitSpecs);
    }

    @Override
    public DurationType startingDuratingType(DurationType last, boolean gapFlashBitSpecs) {
        return this.bareIrStream.startingDuratingType(last, gapFlashBitSpecs);
    }

    @Override
    public void evaluate(RenderData renderData, List<BitSpec> bitSpecStack) throws NameUnassignedException {
        if (this.repeatMarker.isInfinite() || this.repeatMarker.getMax() != this.repeatMarker.getMin()) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < this.repeatMarker.getMin(); ++i) {
            this.bareIrStream.evaluate(renderData, bitSpecStack);
        }
    }

    @Override
    public boolean hasExtent() {
        return this.bareIrStream.hasExtent();
    }

    @Override
    public Set<String> assignmentVariables() {
        return this.bareIrStream.assignmentVariables();
    }

    @Override
    public Double microSeconds(GeneralSpec generalSpec, NameEngine nameEngine) {
        return (double)this.repeatMarker.getMin() * this.bareIrStream.microSeconds(generalSpec, nameEngine);
    }

    boolean startsWithFlash() {
        return this.bareIrStream.startsWithFlash();
    }

    @Override
    public boolean nonConstantBitFieldLength() {
        return this.bareIrStream.nonConstantBitFieldLength();
    }

    @Override
    public Integer guessParameterLength(String name) {
        return this.bareIrStream.guessParameterLength(name);
    }

    @Override
    public TreeSet<Double> allDurationsInMicros(GeneralSpec generalSpec, NameEngine nameEngine) {
        return this.bareIrStream.allDurationsInMicros(generalSpec, nameEngine);
    }

    @Override
    public boolean constant(NameEngine nameEngine) {
        return this.bareIrStream.constant(nameEngine);
    }

    public static class PassExtractorState {
        private IrSignal.Pass state;

        PassExtractorState(IrSignal.Pass state) {
            this.state = state;
        }

        IrSignal.Pass getState() {
            return this.state;
        }

        void setState(IrSignal.Pass state) {
            this.state = state;
        }

        public String toString() {
            return this.state.toString();
        }
    }
}

