/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.validation.Schema;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.OddSequenceLengthException;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrpException;
import org.harctoolbox.irp.IrpInvalidArgumentException;
import org.harctoolbox.irp.IrpParseException;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.NamedProtocol;
import org.harctoolbox.irp.Protocol;
import org.harctoolbox.irp.UnknownProtocolException;
import org.harctoolbox.irp.UnsupportedRepeatException;
import org.harctoolbox.xml.DumbHtmlRenderer;
import org.harctoolbox.xml.XmlUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public final class IrpDatabase
implements Iterable<NamedProtocol>,
Serializable {
    private static final Logger logger = Logger.getLogger(IrpDatabase.class.getName());
    public static final String DEFAULT_CONFIG_FILE = "/IrpProtocols.xml";
    public static final String IRP_PROTOCOL_NS = "http://www.harctoolbox.org/irp-protocols";
    public static final String IRP_SCHEMA_FILE = "/irp-protocols.xsd";
    public static final String IRP_PROTOCOL_SCHEMA_LOCATION = "http://www.harctoolbox.org/schemas/irp-protocols.xsd";
    public static final String IRP_NAMESPACE_PREFIX = "irp";
    private static final int MAX_RECURSION_DEPTH = 5;
    public static final String UNNAMED = "unnamed_protocol";
    public static final String PROTOCOL_NAME = "protocol";
    public static final String PROTOCOLS_NAME = "protocols";
    public static final String NAME_NAME = "name";
    public static final String IRP_NAME = "irp";
    public static final String IRP_ELEMENT_NAME = "Irp";
    public static final String USABLE_NAME = "usable";
    public static final String VERSION_NAME = "version";
    public static final String PROG_VERSION_NAME = "program-version";
    public static final String DOCUMENTATION_NAME = "documentation";
    public static final String DOCUMENTATION_ELEMENT_NAME = "Documentation";
    public static final String PARAMETER_NAME = "parameter";
    public static final String DECODABLE_NAME = "decodable";
    public static final String FREQUENCY_TOLERANCE_NAME = "frequency-tolerance";
    public static final String FREQUENCY_LOWER_NAME = "frequency-lower";
    public static final String FREQUENCY_UPPER_NAME = "frequency-upper";
    public static final String RELATIVE_TOLERANCE_NAME = "relative-tolerance";
    public static final String ABSOLUTE_TOLERANCE_NAME = "absolute-tolerance";
    public static final String MINIMUM_LEADOUT_NAME = "minimum-leadout";
    public static final String PREFER_OVER_NAME = "prefer-over";
    public static final String ALT_NAME_NAME = "alt_name";
    public static final String REJECT_REPEATLESS_NAME = "reject-repeatless";
    public static final String TYPE_NAME = "type";
    public static final String XML_NAME = "xml";
    public static final String FALSE_NAME = "false";
    public static final String HTML_NAME = "Html";
    public static final String VALUE_NAME = "Value";
    public static final String PARAMETERS_NAME = "Parameters";
    public static final String PARAMETER_ELEMENT_NAME = "Parameter";
    public static final String NAMED_PROTOCOLS_NAME = "named-protocols";
    public static final String DECODE_ONLY_NAME = "decode-only";
    public static final String PROTOCOL_NAME_NAME = "protocolName";
    public static final String PROTOCOL_CNAME_NAME = "cProtocolName";
    public static final String META_DATA_NAME = "metaData";
    public static final String YES_NAME = "yes";
    public static final String NO_NAME = "no";
    private static boolean validating = false;
    private static Schema schema = null;
    private final StringBuilder version = new StringBuilder(64);
    private Map<String, UnparsedProtocol> protocols = new LinkedHashMap<String, UnparsedProtocol>(8);
    private Map<String, String> aliases = new LinkedHashMap<String, String>(8);
    private final List<String> comments = new ArrayList<String>(4);
    private final Map<String, String> globalAttributes = new HashMap<String, String>(4);
    private final Map<String, Protocol> recycledProtocols = new HashMap<String, Protocol>(16);

    public static boolean isValidating() {
        return validating;
    }

    public static synchronized void setValidating(boolean newValidating) throws SAXException {
        if (newValidating && !XmlUtils.canValidate()) {
            logger.log(Level.WARNING, "Validating not possible, ignoring.");
            validating = false;
            schema = null;
            return;
        }
        validating = newValidating;
        if (validating) {
            if (schema == null) {
                schema = XmlUtils.readSchema(IrpDatabase.class.getResourceAsStream(IRP_SCHEMA_FILE));
            }
        } else {
            schema = null;
        }
    }

    public static Schema getSchema() {
        return schema;
    }

    static boolean isKnownKeyword(String key) {
        return key.equals(PROTOCOL_NAME) || key.equals(NAME_NAME) || key.equals("irp") || key.equals(USABLE_NAME) || key.equals(DOCUMENTATION_NAME) || key.equals(PARAMETER_NAME) || key.equals(DECODABLE_NAME) || key.equals(FREQUENCY_TOLERANCE_NAME) || key.equals(FREQUENCY_LOWER_NAME) || key.equals(FREQUENCY_UPPER_NAME) || key.equals(RELATIVE_TOLERANCE_NAME) || key.equals(ABSOLUTE_TOLERANCE_NAME) || key.equals(MINIMUM_LEADOUT_NAME) || key.equals(PREFER_OVER_NAME) || key.equals(ALT_NAME_NAME);
    }

    public static boolean isKnown(String protocolsPath, String protocol) throws IOException, IrpParseException, SAXException {
        return new IrpDatabase(protocolsPath).isKnown(protocol);
    }

    public static String getIrp(String configFilename, String protocolName) throws IrpParseException, UnknownProtocolException, IOException, SAXException {
        IrpDatabase irpMaster = new IrpDatabase(configFilename);
        return irpMaster.getIrp(protocolName);
    }

    public static IrpDatabase parseIrp(String protocolName, String irp, String documentation) throws IrpParseException {
        return IrpDatabase.parseIrp(protocolName, irp, XmlUtils.stringToDocumentFragment(documentation));
    }

    public static IrpDatabase parseIrp(String protocolName, String irp, DocumentFragment documentation) throws IrpParseException {
        HashMap<String, UnparsedProtocol> protocols = new HashMap<String, UnparsedProtocol>(1);
        UnparsedProtocol protocol = new UnparsedProtocol(protocolName, irp, documentation);
        protocols.put(protocolName, protocol);
        return new IrpDatabase(protocols);
    }

    public static IrpDatabase parseIrp(Map<String, String> map) throws IrpParseException {
        return new IrpDatabase(IrpDatabase.toUnparsedProtocols(map));
    }

    private static Document openXmlStream(InputStream inputStream) throws IOException, SAXException {
        return XmlUtils.openXmlStream(inputStream, IrpDatabase.getSchema(), true, true);
    }

    private static Document openXmlReader(Reader reader) throws IOException, SAXException {
        return XmlUtils.openXmlReader(reader, IrpDatabase.getSchema(), true, true);
    }

    private static Document openXmlFile(File file) throws IOException, SAXException {
        return XmlUtils.openXmlFile(file, IrpDatabase.getSchema(), true, true);
    }

    private static Map<String, UnparsedProtocol> toUnparsedProtocols(Map<String, String> protocols) {
        HashMap<String, UnparsedProtocol> map = new HashMap<String, UnparsedProtocol>(protocols.size());
        protocols.entrySet().forEach(kvp -> {
            String name = ((String)kvp.getKey()).toLowerCase(Locale.US);
            map.put(name, new UnparsedProtocol(name, (String)kvp.getValue(), null));
        });
        return map;
    }

    private static InputStream mkStream(String file) throws IOException {
        return file == null || file.isEmpty() ? IrpDatabase.class.getResourceAsStream(DEFAULT_CONFIG_FILE) : IrCoreUtils.getInputStream(file);
    }

    public static IrpDatabase newDefaultIrpDatabase() {
        try {
            return new IrpDatabase((String)null);
        }
        catch (IOException | IrpParseException | SAXException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    private static String getDocumentation(DocumentFragment frag) {
        return DumbHtmlRenderer.render(frag);
    }

    public IrpDatabase(Reader reader) throws IOException, IrpParseException, SAXException {
        this(IrpDatabase.openXmlReader(reader));
    }

    public IrpDatabase(InputStream inputStream) throws IOException, IrpParseException, SAXException {
        this(IrpDatabase.openXmlStream(inputStream));
    }

    public IrpDatabase(File file) throws IOException, IrpParseException, SAXException {
        this(IrpDatabase.openXmlFile(file));
    }

    public IrpDatabase(String file) throws IOException, IrpParseException, SAXException {
        this(IrpDatabase.mkStream(file));
    }

    public IrpDatabase(Iterable<File> files) throws IrpParseException, IOException, SAXException {
        this();
        for (File file : files) {
            this.patch(file);
        }
        this.expand();
        this.rebuildAliases();
    }

    public IrpDatabase() {
    }

    private IrpDatabase(Map<String, UnparsedProtocol> protocols) throws IrpParseException {
        this();
        this.protocols = protocols;
        this.expand();
        this.rebuildAliases();
    }

    public IrpDatabase(Document doc) throws IrpParseException {
        this();
        this.patch(doc);
        this.expand();
        this.rebuildAliases();
    }

    public IrpDatabase(Element protocolsElement) throws IrpParseException {
        this();
        this.version.append(protocolsElement.getAttribute(VERSION_NAME));
        this.patchProtocols(protocolsElement);
        this.expand();
        this.rebuildAliases();
    }

    public void patch(IrpDatabase irpDatabase) {
        this.appendToVersion(irpDatabase.getVersion());
        irpDatabase.protocols.values().forEach(protocol -> this.patchProtocol((UnparsedProtocol)protocol));
    }

    public void patch(Reader reader) throws IOException, SAXException, IrpParseException {
        this.patch(IrpDatabase.openXmlReader(reader));
    }

    public void patch(File file) throws IOException, SAXException, IrpParseException {
        this.patch(IrpDatabase.openXmlFile(file));
    }

    public void patch(String file) throws IOException, SAXException, IrpParseException {
        this.patch(new File(file));
    }

    public void patch(Document document) throws IrpParseException {
        Element root = document.getDocumentElement();
        NamedNodeMap attributes = root.getAttributes();
        block17: for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            switch (attr.getName()) {
                case "xmlns:xsi": 
                case "xmlns:html": 
                case "xmlns:xml": 
                case "xmlns:xi": 
                case "xmlns:irp": 
                case "xmlns": 
                case "xsi:schemaLocation": 
                case "version": {
                    continue block17;
                }
                default: {
                    this.globalAttributes.put(attr.getName(), attr.getValue());
                }
            }
        }
        this.appendToVersion(root.getAttribute(VERSION_NAME));
        NodeList nodes = document.getChildNodes();
        block18: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    Element el = (Element)node;
                    String name = el.getLocalName();
                    if (!name.equals(PROTOCOLS_NAME)) continue block18;
                    this.patchProtocols(el);
                    continue block18;
                }
                case 8: {
                    this.comments.add(node.getTextContent());
                    continue block18;
                }
            }
        }
        this.expand();
        this.rebuildAliases();
    }

    private void patchProtocols(Element protocols) {
        NodeList nodes = protocols.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    Element e = (Element)node;
                    if (!e.getLocalName().equals(PROTOCOL_NAME)) continue block4;
                    this.patchProtocol(e);
                    continue block4;
                }
                case 8: {
                    logger.log(Level.WARNING, "Comment between protocols \"<!--{0}-->\" ignored", node.getTextContent());
                    continue block4;
                }
            }
        }
    }

    private void patchProtocol(Element current) {
        this.patchProtocol(new UnparsedProtocol(current));
    }

    private void patchProtocol(UnparsedProtocol proto) {
        String name = proto.getName();
        if (name == null) {
            return;
        }
        String nameLower = name.toLowerCase(Locale.US);
        UnparsedProtocol existing = this.protocols.get(nameLower);
        if (existing != null) {
            if (proto.isEmpty()) {
                this.protocols.remove(nameLower);
            } else {
                existing.patch(proto);
            }
        } else {
            this.protocols.put(nameLower, proto);
        }
        this.buildAliases(proto);
    }

    public void addProtocol(String protocolName, String irp) throws IrpParseException {
        this.addProtocol(protocolName, irp, null);
    }

    public void addProtocol(String protocolName, String irp, DocumentFragment doc) throws IrpParseException {
        this.patchProtocol(new UnparsedProtocol(protocolName, irp, doc));
        this.expand(protocolName);
    }

    private Document mkDocument(boolean includeComments) {
        Document doc = XmlUtils.newDocument(true);
        ProcessingInstruction pi = doc.createProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"IrpProtocols2html.xsl\"");
        doc.appendChild(pi);
        if (includeComments) {
            this.comments.forEach(comment -> doc.appendChild(doc.createComment((String)comment)));
        }
        return doc;
    }

    private Element mkRoot(Document doc) {
        Element root = doc.createElementNS(IRP_PROTOCOL_NS, "irp:protocols");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xmlns:xi", "http://www.w3.org/2001/XInclude");
        root.setAttribute("xmlns:xml", "http://www.w3.org/XML/1998/namespace");
        root.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        root.setAttribute("xsi:schemaLocation", "http://www.harctoolbox.org/irp-protocols http://www.harctoolbox.org/schemas/irp-protocols.xsd");
        if (this.version.length() > 0) {
            root.setAttribute(VERSION_NAME, this.version.toString());
        }
        this.globalAttributes.entrySet().forEach(kvp -> root.setAttribute((String)kvp.getKey(), (String)kvp.getValue()));
        return root;
    }

    public Document toDocument() {
        return this.toDocument(this.protocols.keySet());
    }

    public Document toDocument(Iterable<String> protocolsNames) {
        return this.toDocument(protocolsNames, true);
    }

    public Document toDocument(Iterable<String> protocolsNames, boolean includeComments) {
        Document document = this.mkDocument(includeComments);
        Element root = this.toElement(document, protocolsNames);
        document.appendChild(root);
        return document;
    }

    public Document toDocument(Iterable<String> protocolNames, Double absoluteTolerance, Double relativeTolerance, Double frequencyTolerance, Double minimumLeadout) {
        Document document = this.mkDocument(false);
        Element root = this.toElement(document, protocolNames, absoluteTolerance, relativeTolerance, frequencyTolerance, minimumLeadout);
        document.appendChild(root);
        return document;
    }

    public Element toElement(Document doc) {
        return this.toElement(doc, this.protocols.keySet());
    }

    public Element toElement(Document doc, Iterable<String> protocolNames) {
        Element root = this.mkRoot(doc);
        for (String protocolName : protocolNames) {
            root.appendChild(doc.createTextNode("\n"));
            root.appendChild(this.protocols.get(protocolName.toLowerCase(Locale.US)).toElement(doc));
        }
        return root;
    }

    public Element toElement(Document document, Iterable<String> protocolNames, Double absoluteTolerance, Double relativeTolerance, Double frequencyTolerance, Double minimumLeadout) {
        Element root = document.createElement("NamedProtocols");
        root.setAttribute(PROG_VERSION_NAME, "IrpTransmogrifier version 1.2.14");
        root.setAttribute(VERSION_NAME, this.getConfigFileVersion());
        root.setAttribute(ABSOLUTE_TOLERANCE_NAME, Double.toString(IrCoreUtils.getAbsoluteTolerance(absoluteTolerance)));
        root.setAttribute(RELATIVE_TOLERANCE_NAME, Double.toString(IrCoreUtils.getRelativeTolerance(relativeTolerance)));
        root.setAttribute(FREQUENCY_TOLERANCE_NAME, Double.toString(IrCoreUtils.getFrequencyTolerance(frequencyTolerance)));
        root.setAttribute(MINIMUM_LEADOUT_NAME, Double.toString(IrCoreUtils.getMinimumLeadout(minimumLeadout)));
        protocolNames.forEach(pname -> {
            try {
                logger.log(Level.FINE, "Processing {0} ...", pname);
                NamedProtocol protocol = this.getNamedProtocol((String)pname);
                Element element = protocol.toElement(document);
                root.appendChild(element);
            }
            catch (ArithmeticException | InvalidNameException | IrpInvalidArgumentException | NameUnassignedException | UnsupportedRepeatException ex) {
                logger.log(Level.WARNING, "{0}; protocol ignored", ex.getMessage());
            }
            catch (UnknownProtocolException ex) {
                throw new ThisCannotHappenException(ex);
            }
        });
        return root;
    }

    public String getConfigFileVersion() {
        return this.version.toString();
    }

    public boolean isAlias(String protocol) {
        return this.aliases.containsKey(protocol.toLowerCase(Locale.US));
    }

    public String expandAlias(String protocol) {
        String expanded = this.aliases.get(protocol.toLowerCase(Locale.US));
        return expanded != null ? expanded : protocol;
    }

    public boolean isKnown(String protocol) {
        return protocol != null && this.protocols.containsKey(protocol.toLowerCase(Locale.US));
    }

    public boolean isKnownExpandAlias(String protocol) {
        return this.isKnown(this.expandAlias(protocol));
    }

    public String getIrp(String name) throws UnknownProtocolException {
        UnparsedProtocol prot = this.getUnparsedProtocol(name);
        return prot.getIrp();
    }

    public String getIrpExpandAlias(String name) throws UnknownProtocolException {
        return this.getIrp(this.expandAlias(name));
    }

    private UnparsedProtocol getUnparsedProtocol(String protocolName) throws UnknownProtocolException {
        UnparsedProtocol unparsedProtocol = this.protocols.get(protocolName.toLowerCase(Locale.US));
        if (unparsedProtocol == null) {
            throw new UnknownProtocolException(protocolName);
        }
        return unparsedProtocol;
    }

    public Set<String> getKeys() {
        return this.protocols.keySet();
    }

    public List<String> getNames() {
        ArrayList<String> answer = new ArrayList<String>(this.protocols.size());
        this.protocols.values().forEach(prot -> answer.add(prot.getName()));
        return answer;
    }

    public Set<String> getAliases() {
        return this.aliases.keySet();
    }

    public String getName(String name) throws UnknownProtocolException {
        UnparsedProtocol prot = this.getUnparsedProtocol(name);
        return prot.getName();
    }

    public String getNameExpandAlias(String name) throws UnknownProtocolException {
        return this.getName(this.expandAlias(name));
    }

    public int size() {
        return this.protocols.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public List<String> getMatchingNamesRegexp(String regexp) {
        Pattern pattern = Pattern.compile(regexp.toLowerCase(Locale.US));
        ArrayList<String> result = new ArrayList<String>(10);
        this.protocols.keySet().stream().filter(candidate -> pattern.matcher((CharSequence)candidate).matches()).forEach(candidate -> result.add((String)candidate));
        this.aliases.keySet().stream().filter(candidate -> pattern.matcher((CharSequence)candidate).matches()).forEach(candidate -> result.add((String)candidate));
        return result;
    }

    public List<String> getMatchingNamesExact(String string) {
        ArrayList<String> result = new ArrayList<String>(10);
        this.protocols.keySet().stream().filter(candidate -> candidate.equalsIgnoreCase(string)).forEachOrdered(candidate -> result.add((String)candidate));
        this.aliases.keySet().stream().filter(candidate -> candidate.equalsIgnoreCase(string)).forEachOrdered(candidate -> result.add((String)candidate));
        return result;
    }

    public List<String> getMatchingNames(Iterable<String> iterable, boolean regexp, boolean urlDecode) {
        ArrayList<String> result = new ArrayList<String>(10);
        for (String str : iterable) {
            try {
                String s = urlDecode ? URLDecoder.decode(str, "UTF-8") : str;
                result.addAll(regexp ? this.getMatchingNamesRegexp(s) : this.getMatchingNamesExact(s));
            }
            catch (UnsupportedEncodingException ex) {
                throw new ThisCannotHappenException();
            }
        }
        return result;
    }

    public String getDocumentation(String protocolName) throws UnknownProtocolException {
        DocumentFragment fragment = this.getHtmlDocumentation(protocolName);
        return fragment == null ? null : IrpDatabase.getDocumentation(fragment);
    }

    public DocumentFragment getHtmlDocumentation(String protocolName) throws UnknownProtocolException {
        UnparsedProtocol prot = this.getUnparsedProtocol(protocolName);
        return prot.getHtmlDocumentation();
    }

    public void setDocumentation(String protocolName, String string) throws UnknownProtocolException {
        this.setDocumentation(protocolName, XmlUtils.stringToDocumentFragment(string));
    }

    public void setDocumentation(String protocolName, DocumentFragment fragment) throws UnknownProtocolException {
        UnparsedProtocol prot = this.getUnparsedProtocol(protocolName);
        ArrayList<DocumentFragment> list = new ArrayList<DocumentFragment>(1);
        list.add(fragment);
        prot.setXmlProperties(DOCUMENTATION_NAME, list);
    }

    public String getDocumentationExpandAlias(String protocolName) throws UnknownProtocolException {
        return this.getDocumentation(this.expandAlias(protocolName));
    }

    public String getFirstProperty(String protocolName, String key) throws UnknownProtocolException {
        UnparsedProtocol prot = this.getUnparsedProtocol(protocolName);
        return prot.getFirstProperty(key);
    }

    public List<String> getProperties(String protocolName, String key) throws UnknownProtocolException {
        UnparsedProtocol prot = this.getUnparsedProtocol(protocolName);
        return prot.getProperties(key);
    }

    public void addProperty(String protocolName, String key, String value) throws UnknownProtocolException {
        UnparsedProtocol prot = this.getUnparsedProtocol(protocolName);
        prot.addProperty(key, value);
    }

    public void setProperties(String protocolName, String key, List<String> properties) throws UnknownProtocolException {
        UnparsedProtocol prot = this.getUnparsedProtocol(protocolName);
        prot.setProperties(key, properties);
    }

    public void removeProperties(String protocolName, String key) throws UnknownProtocolException {
        UnparsedProtocol prot = this.getUnparsedProtocol(protocolName);
        prot.removeProperties(key);
    }

    public List<DocumentFragment> getXmlProperties(String protocolName, String key) throws UnknownProtocolException {
        UnparsedProtocol prot = this.getUnparsedProtocol(protocolName);
        return prot.getXmlProperties(key);
    }

    public void setXmlProperties(String protocolName, String key, List<DocumentFragment> properties) throws UnknownProtocolException {
        UnparsedProtocol prot = this.getUnparsedProtocol(protocolName);
        prot.setXmlProperties(key, properties);
    }

    public void removeXmlProperties(String protocolName, String key) throws UnknownProtocolException {
        UnparsedProtocol prot = this.getUnparsedProtocol(protocolName);
        prot.removeProperties(key);
    }

    public NamedProtocol getNamedProtocol(String protocolName) throws UnknownProtocolException, InvalidNameException, UnsupportedRepeatException, IrpInvalidArgumentException, NameUnassignedException {
        UnparsedProtocol prot = this.getUnparsedProtocol(protocolName);
        return prot.toNamedProtocol();
    }

    public NamedProtocol getNamedProtocolExpandAlias(String protocolName) throws UnknownProtocolException, InvalidNameException, UnsupportedRepeatException, IrpInvalidArgumentException, NameUnassignedException {
        return this.getNamedProtocol(this.expandAlias(protocolName));
    }

    public List<NamedProtocol> getNamedProtocol(Collection<String> protocolNames) {
        ArrayList<NamedProtocol> list = new ArrayList<NamedProtocol>(protocolNames.size());
        protocolNames.stream().forEach(pName -> {
            try {
                list.add(this.getNamedProtocol((String)pName));
            }
            catch (InvalidNameException | IrpInvalidArgumentException | NameUnassignedException | UnknownProtocolException | UnsupportedRepeatException ex) {
                logger.log(Level.WARNING, null, ex);
            }
        });
        return list;
    }

    private void expand() throws IrpParseException {
        for (String protocol : this.protocols.keySet()) {
            this.expand(protocol);
        }
    }

    private void expand(String name) throws IrpParseException {
        this.expand(0, name);
    }

    private void expand(int depth, String name) throws IrpParseException {
        String p_name;
        UnparsedProtocol ancestor;
        UnparsedProtocol p = this.protocols.get(name.toLowerCase(Locale.US));
        String irp = p.getIrp();
        if (irp == null) {
            return;
        }
        if (!irp.contains("{")) {
            throw new IrpParseException(p.getIrp(), "`{' not found.");
        }
        if (!irp.startsWith("{") && (ancestor = this.protocols.get((p_name = p.getIrp().substring(0, p.getIrp().indexOf(123)).trim()).toLowerCase(Locale.US))) != null) {
            String replacement = ancestor.getIrp().lastIndexOf(91) == -1 ? ancestor.getIrp() : ancestor.getIrp().substring(0, ancestor.getIrp().lastIndexOf(91));
            logger.log(Level.FINEST, "Protocol {0}: `{1}'' replaced by `{2}''.", new Object[]{name, p_name, replacement});
            p.setUniqueProperty("irp", p.getIrp().replaceAll(p_name, replacement));
            this.protocols.put(name, p);
            if (depth < 5) {
                this.expand(depth + 1, name);
            } else {
                logger.log(Level.SEVERE, "Recursion depth in expanding {0} exceeded.", name);
            }
        }
    }

    public void remove(Iterable<String> blackList) throws UnknownProtocolException {
        if (blackList == null) {
            return;
        }
        for (String protocol : blackList) {
            this.remove(protocol);
        }
    }

    public void remove(String protocolName) throws UnknownProtocolException {
        if (!this.isKnown(protocolName)) {
            throw new UnknownProtocolException(protocolName);
        }
        this.protocols.remove(protocolName.toLowerCase(Locale.US));
        this.removeAliases(protocolName);
    }

    private void removeAliases(String protocolName) {
        ArrayList result = new ArrayList(4);
        this.aliases.entrySet().stream().filter(kvp -> ((String)kvp.getValue()).equals(protocolName)).forEachOrdered(kvp -> result.add((String)kvp.getKey()));
        result.forEach(s -> this.aliases.remove(s));
    }

    public List<String> evaluateProtocols(List<String> protocols, boolean sort, boolean regexp, boolean urlDecode) {
        ArrayList<String> list;
        List<String> list2 = list = protocols == null || protocols.isEmpty() ? new ArrayList<String>(this.getKeys()) : this.getMatchingNames(protocols, regexp, urlDecode);
        if (sort) {
            Collections.sort(list);
        }
        return list;
    }

    public Protocol getNonRecycledProtocol(String protocolName) throws UnknownProtocolException, UnsupportedRepeatException, NameUnassignedException, InvalidNameException, IrpInvalidArgumentException {
        if (!this.isKnown(protocolName)) {
            throw new UnknownProtocolException(protocolName);
        }
        return new Protocol(this.getIrp(protocolName));
    }

    public Protocol getProtocol(String protocolName) throws UnknownProtocolException, UnsupportedRepeatException, NameUnassignedException, InvalidNameException, IrpInvalidArgumentException {
        if (protocolName == null || protocolName.isEmpty()) {
            return null;
        }
        Protocol protocol = this.recycledProtocols.get(protocolName.toLowerCase(Locale.US));
        if (protocol == null) {
            protocol = this.getNonRecycledProtocol(protocolName);
            this.recycledProtocols.put(protocolName.toLowerCase(Locale.US), protocol);
        }
        return protocol;
    }

    public Protocol getProtocolExpandAlias(String protocolName) throws UnknownProtocolException, UnsupportedRepeatException, NameUnassignedException, InvalidNameException, IrpInvalidArgumentException {
        return this.getProtocol(this.expandAlias(protocolName));
    }

    public String getNormalFormIrp(String protocolName, int radix) throws UnknownProtocolException, InvalidNameException, UnsupportedRepeatException, NameUnassignedException, IrpInvalidArgumentException {
        Protocol protocol = this.getProtocol(protocolName);
        return protocol.normalFormIrpString(radix);
    }

    public String checkSorted() {
        String last = " ";
        for (String protocol : this.protocols.keySet()) {
            if (protocol.compareTo(last) < 0) {
                return protocol;
            }
            last = protocol;
        }
        return null;
    }

    public IrSignal render(String protocolName, Map<String, Long> params) throws IrpException {
        Protocol protocol = this.getProtocolExpandAlias(protocolName);
        try {
            return protocol.toIrSignal(params);
        }
        catch (OddSequenceLengthException ex) {
            throw new IrpException("IrSequence does not end with a gap,");
        }
    }

    @Override
    public Iterator<NamedProtocol> iterator() {
        return new NamedProtocolIterator(this.protocols);
    }

    private void appendToVersion(String version) {
        if (version.isEmpty()) {
            return;
        }
        if (this.version.toString().endsWith("+" + version)) {
            return;
        }
        if (this.version.length() > 0) {
            this.version.append("+");
        }
        this.version.append(version);
    }

    private void buildAliases(UnparsedProtocol proto) {
        List altNameList = proto.getProperties(ALT_NAME_NAME);
        if (altNameList == null || altNameList.isEmpty()) {
            return;
        }
        String realName = proto.getName();
        altNameList.stream().map(altName -> {
            String old = this.aliases.get(altName.toLowerCase(Locale.US));
            if (old != null && !old.equals(realName)) {
                logger.log(Level.WARNING, "alt_name \"{0}\" defined more than once, to different targets. Keeping the last.", altName);
            }
            return altName;
        }).forEachOrdered(altName -> this.aliases.put(altName.toLowerCase(Locale.US), realName));
    }

    private void rebuildAliases() {
        this.aliases.clear();
        this.protocols.values().forEach(protocol -> this.buildAliases((UnparsedProtocol)protocol));
    }

    public String getVersion() {
        return this.version.toString();
    }

    private static class UnparsedProtocol
    implements Serializable {
        private static final int APRIORI_SIZE = 4;
        private Map<String, List<String>> map = new LinkedHashMap<String, List<String>>(4);
        private Map<String, List<DocumentFragment>> xmlMap = new HashMap<String, List<DocumentFragment>>(4);
        private List<String> comments = new ArrayList<String>(1);

        private static DocumentFragment nodeToDocumentFragment(Node node, boolean preserve) {
            return UnparsedProtocol.nodeListToDocumentFragment(node.getChildNodes(), preserve);
        }

        private static DocumentFragment nodeListToDocumentFragment(NodeList childNodes, boolean preserveSpace) {
            Document doc = XmlUtils.newDocument(true);
            DocumentFragment fragment = doc.createDocumentFragment();
            block4: for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                if (preserveSpace) {
                    fragment.appendChild(doc.importNode(node, true));
                    continue;
                }
                switch (node.getNodeType()) {
                    case 3: {
                        if (!preserveSpace && node.getTextContent().matches("\\s+")) continue block4;
                        fragment.appendChild(doc.createTextNode(node.getTextContent()));
                        continue block4;
                    }
                    case 8: {
                        continue block4;
                    }
                    default: {
                        Node importedNode = doc.importNode(node, false);
                        fragment.appendChild(importedNode);
                        importedNode.appendChild(doc.importNode(UnparsedProtocol.nodeToDocumentFragment(node, preserveSpace), true));
                    }
                }
            }
            return fragment;
        }

        private static <T> void patchMap(Map<String, List<T>> existingMap, Map<String, List<T>> patchMap) {
            patchMap.entrySet().forEach(kvp -> {
                String name = (String)kvp.getKey();
                if (!name.equals(IrpDatabase.NAME_NAME)) {
                    List newList = (List)kvp.getValue();
                    if (newList == null) {
                        existingMap.remove(name);
                    } else if (existingMap.containsKey(name)) {
                        List oldList = (List)existingMap.get(name);
                        if (name.equals(IrpDatabase.DOCUMENTATION_NAME) || name.equals("irp")) {
                            oldList.clear();
                        }
                        newList.forEach(t -> {
                            if (t == null) {
                                oldList.clear();
                            } else if (!oldList.contains(t)) {
                                oldList.add(t);
                            }
                        });
                    } else {
                        existingMap.put(name, newList);
                    }
                }
            });
        }

        private static <T> List<T> getOrEmptyList(Map<String, List<T>> map, String key) {
            List list = map.get(key);
            return list != null ? list : Collections.EMPTY_LIST;
        }

        UnparsedProtocol() {
        }

        UnparsedProtocol(String irp) {
            this(IrpDatabase.UNNAMED, irp, null);
        }

        UnparsedProtocol(String name, String irp, DocumentFragment documentation) {
            this();
            this.addProperty(IrpDatabase.NAME_NAME, name);
            this.addProperty("irp", irp);
            if (documentation != null) {
                this.addXmlProperty(IrpDatabase.DOCUMENTATION_NAME, documentation);
            }
        }

        UnparsedProtocol(Map<String, String> map) {
            this();
            map.entrySet().forEach(kvp -> this.addProperty((String)kvp.getKey(), (String)kvp.getValue()));
        }

        UnparsedProtocol(Element element) {
            this();
            this.parseElement(element);
        }

        UnparsedProtocol(String key, String irp) {
            this(key, irp, null);
        }

        private void patch(UnparsedProtocol patchProtocol) {
            UnparsedProtocol.patchMap(this.map, patchProtocol.map);
            UnparsedProtocol.patchMap(this.xmlMap, patchProtocol.xmlMap);
        }

        private void addXmlProperty(String key, Node node, boolean preserve) {
            DocumentFragment fragment = UnparsedProtocol.nodeToDocumentFragment(node, preserve);
            fragment.setUserData("xml:space", XmlUtils.hasSpacePreserve(node), null);
            this.addXmlProperty(key, fragment);
        }

        private void addXmlProperty(String key, DocumentFragment fragment) {
            List<DocumentFragment> list = this.xmlMap.get(key);
            if (list == null) {
                list = new ArrayList<DocumentFragment>(1);
                this.xmlMap.put(key, list);
            }
            list.add(fragment.hasChildNodes() ? fragment : null);
        }

        private void addProperty(String key, String val) {
            String value = val.trim();
            List<String> list = this.map.get(key);
            if (list == null) {
                list = new ArrayList<String>(1);
                this.map.put(key, list);
            }
            list.add(value.isEmpty() ? null : value);
        }

        private void setUniqueProperty(String key, String value) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(value);
            this.map.put(key, list);
        }

        private String getFirstProperty(String key) {
            List<String> list = this.map.get(key);
            return list == null ? null : list.get(0);
        }

        private void parseElement(Element element) {
            String usable = element.getAttribute(IrpDatabase.USABLE_NAME);
            if (usable.equalsIgnoreCase(IrpDatabase.FALSE_NAME)) {
                return;
            }
            String name = element.getAttribute(IrpDatabase.NAME_NAME);
            this.addProperty(IrpDatabase.NAME_NAME, name);
            NodeList nodeList = element.getChildNodes();
            block4: for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                switch (node.getNodeType()) {
                    case 1: {
                        this.parseProtocolChild((Element)node);
                        continue block4;
                    }
                    case 8: {
                        this.comments.add(node.getTextContent());
                        continue block4;
                    }
                }
            }
        }

        private void parseProtocolChild(Element e) {
            switch (e.getLocalName()) {
                case "irp": {
                    this.addProperty("irp", e.getTextContent());
                    break;
                }
                case "documentation": {
                    this.addXmlProperty(IrpDatabase.DOCUMENTATION_NAME, e, XmlUtils.hasSpacePreserve(e));
                    break;
                }
                case "parameter": {
                    boolean isXml = e.getAttribute(IrpDatabase.TYPE_NAME).toLowerCase(Locale.US).equals(IrpDatabase.XML_NAME);
                    if (isXml) {
                        this.addXmlProperty(e.getAttribute(IrpDatabase.NAME_NAME), e, false);
                        break;
                    }
                    this.addProperty(e.getAttribute(IrpDatabase.NAME_NAME), e.getTextContent());
                    break;
                }
                default: {
                    throw new ThisCannotHappenException("unknown tag: " + e.getTagName());
                }
            }
        }

        private List<DocumentFragment> getXmlProperties(String key) {
            return UnparsedProtocol.getOrEmptyList(this.xmlMap, key);
        }

        void setXmlProperties(String key, List<DocumentFragment> list) {
            this.xmlMap.put(key, list);
        }

        void removeXmlProperties(String key) {
            this.xmlMap.remove(key);
        }

        private List<String> getProperties(String key) {
            return UnparsedProtocol.getOrEmptyList(this.map, key);
        }

        void setProperties(String key, List<String> list) {
            this.map.put(key, list);
        }

        void removeProperties(String key) {
            this.map.remove(key);
        }

        String getName() {
            return this.getFirstProperty(IrpDatabase.NAME_NAME);
        }

        String getIrp() {
            return this.getFirstProperty("irp");
        }

        DocumentFragment getHtmlDocumentation() {
            List<DocumentFragment> list = this.getXmlProperties(IrpDatabase.DOCUMENTATION_NAME);
            return list.isEmpty() ? null : list.get(0);
        }

        boolean isUsable() {
            String str = this.getFirstProperty(IrpDatabase.USABLE_NAME);
            return str == null || Boolean.parseBoolean(str) || str.equalsIgnoreCase(IrpDatabase.YES_NAME);
        }

        private NamedProtocol toNamedProtocol() throws InvalidNameException, UnsupportedRepeatException, NameUnassignedException, IrpInvalidArgumentException {
            if (this.getIrp() == null) {
                throw new IrpInvalidArgumentException("Irp missing from protocol named " + this.getName());
            }
            return new NamedProtocol(this.getName(), this.getIrp(), this.getHtmlDocumentation(), this.getFirstProperty(IrpDatabase.FREQUENCY_TOLERANCE_NAME), this.getFirstProperty(IrpDatabase.FREQUENCY_LOWER_NAME), this.getFirstProperty(IrpDatabase.FREQUENCY_UPPER_NAME), this.getFirstProperty(IrpDatabase.ABSOLUTE_TOLERANCE_NAME), this.getFirstProperty(IrpDatabase.RELATIVE_TOLERANCE_NAME), this.getFirstProperty(IrpDatabase.MINIMUM_LEADOUT_NAME), this.getFirstProperty(IrpDatabase.DECODABLE_NAME), this.getFirstProperty(IrpDatabase.REJECT_REPEATLESS_NAME), this.getProperties(IrpDatabase.PREFER_OVER_NAME), this.map);
        }

        public String toString() {
            return this.getName() + "\t" + this.getIrp();
        }

        Element toElement(Document doc) {
            Element element = doc.createElementNS(IrpDatabase.IRP_PROTOCOL_NS, "irp:protocol");
            element.setAttribute(IrpDatabase.NAME_NAME, this.getName());
            if (!this.isUsable()) {
                element.setAttribute(IrpDatabase.USABLE_NAME, IrpDatabase.NO_NAME);
            }
            this.comments.forEach(comment -> element.appendChild(doc.createComment((String)comment)));
            Element irp = doc.createElementNS(IrpDatabase.IRP_PROTOCOL_NS, "irp:irp");
            irp.appendChild(doc.createCDATASection(this.getIrp()));
            element.appendChild(irp);
            DocumentFragment docu = this.getHtmlDocumentation();
            if (docu != null) {
                Element docEl = doc.createElementNS(IrpDatabase.IRP_PROTOCOL_NS, "irp:documentation");
                Object userData = docu.getUserData("xml:space");
                if (userData != null && ((Boolean)userData).booleanValue()) {
                    docEl.setAttribute("xml:space", "preserve");
                }
                doc.adoptNode(docu);
                docEl.appendChild(docu);
                element.appendChild(docEl);
            }
            block8: for (Map.Entry<String, List<String>> kvp2 : this.map.entrySet()) {
                switch (kvp2.getKey()) {
                    case "name": 
                    case "usable": 
                    case "irp": {
                        continue block8;
                    }
                }
                kvp2.getValue().stream().map(s -> {
                    Element param = doc.createElementNS(IrpDatabase.IRP_PROTOCOL_NS, "irp:parameter");
                    param.setAttribute(IrpDatabase.NAME_NAME, (String)kvp2.getKey());
                    param.setTextContent((String)s);
                    return param;
                }).forEachOrdered(param -> element.appendChild((Node)param));
            }
            this.xmlMap.entrySet().stream().filter(kvp -> !((String)kvp.getKey()).equals(IrpDatabase.DOCUMENTATION_NAME)).forEachOrdered(kvp -> {
                List list = (List)kvp.getValue();
                if (list != null) {
                    list.forEach(documentFragment -> {
                        Element param = doc.createElementNS(IrpDatabase.IRP_PROTOCOL_NS, "irp:parameter");
                        param.setAttribute(IrpDatabase.NAME_NAME, (String)kvp.getKey());
                        param.setAttribute(IrpDatabase.TYPE_NAME, IrpDatabase.XML_NAME);
                        element.appendChild(param);
                        if (documentFragment != null) {
                            doc.adoptNode((Node)documentFragment);
                            param.appendChild((Node)documentFragment);
                        }
                    });
                }
            });
            return element;
        }

        private boolean isEmpty() {
            return this.map.size() <= 1 && this.xmlMap.isEmpty();
        }
    }

    private static class NamedProtocolIterator
    implements Iterator<NamedProtocol> {
        private Iterator<UnparsedProtocol> unparsedIterator;

        private NamedProtocolIterator(Map<String, UnparsedProtocol> map) {
            this.unparsedIterator = map.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.unparsedIterator.hasNext();
        }

        @Override
        public NamedProtocol next() {
            try {
                UnparsedProtocol unparsed = this.unparsedIterator.next();
                return unparsed.toNamedProtocol();
            }
            catch (IrpException ex) {
                throw new ThisCannotHappenException(ex);
            }
        }
    }
}

