/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import javax.xml.transform.TransformerException;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.harctoolbox.analyze.NoDecoderMatchException;
import org.harctoolbox.cmdline.CmdLineProgram;
import org.harctoolbox.cmdline.CommandAnalyze;
import org.harctoolbox.cmdline.CommandBitField;
import org.harctoolbox.cmdline.CommandCode;
import org.harctoolbox.cmdline.CommandCommonOptions;
import org.harctoolbox.cmdline.CommandDecode;
import org.harctoolbox.cmdline.CommandDemodulate;
import org.harctoolbox.cmdline.CommandExpression;
import org.harctoolbox.cmdline.CommandLirc;
import org.harctoolbox.cmdline.CommandList;
import org.harctoolbox.cmdline.CommandRender;
import org.harctoolbox.cmdline.CommandVersion;
import org.harctoolbox.cmdline.ProgramExitStatus;
import org.harctoolbox.cmdline.UsageException;
import org.harctoolbox.ircore.IrCoreException;
import org.harctoolbox.ircore.OddSequenceLengthException;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.BitSpec;
import org.harctoolbox.irp.IrpDatabase;
import org.harctoolbox.irp.IrpException;
import org.harctoolbox.irp.IrpParseException;
import org.harctoolbox.irp.NamedProtocol;
import org.harctoolbox.irp.ParameterSpec;
import org.xml.sax.SAXException;

public final class IrpTransmogrifier
extends CmdLineProgram {
    private IrpDatabase irpDatabase = null;
    private final CommandCommonOptions commandLineArgs;
    private final CommandVersion commandVersion = new CommandVersion();
    private final CommandList commandList = new CommandList();
    private final CommandRender commandRender = new CommandRender();
    private final CommandDecode commandDecode = new CommandDecode();
    private final CommandDemodulate commandDemodulate = new CommandDemodulate();
    private final CommandAnalyze commandAnalyze = new CommandAnalyze();
    private final CommandCode commandCode = new CommandCode();
    private final CommandBitField commandBitField = new CommandBitField();
    private final CommandExpression commandExpression = new CommandExpression();
    private final CommandLirc commandLirc = new CommandLirc();

    private static void main(String[] args, PrintStream out) {
        IrpTransmogrifier instance = new IrpTransmogrifier(out);
        ProgramExitStatus status = instance.run(args);
        status.die();
    }

    public static void main(String[] args) {
        IrpTransmogrifier.main(args, System.out);
    }

    public IrpTransmogrifier() {
        this(System.out);
    }

    public IrpTransmogrifier(PrintStream out) {
        super(out, new CommandCommonOptions(), "IrpTransmogrifier");
        this.setupCmds(this.commandVersion, this.commandList, this.commandRender, this.commandDecode, this.commandDemodulate, this.commandAnalyze, this.commandCode, this.commandBitField, this.commandExpression, this.commandLirc);
        this.commandLineArgs = (CommandCommonOptions)this.commandBasicOptions;
    }

    @Override
    public void extraSetup() {
        if (this.commandLineArgs.seed != null) {
            ParameterSpec.initRandom(this.commandLineArgs.seed);
        }
    }

    @Override
    public ProgramExitStatus processCommand() {
        try {
            switch (this.command) {
                case "analyze": {
                    this.commandAnalyze.analyze(this.out, this.commandLineArgs);
                    break;
                }
                case "bitfield": {
                    this.commandBitField.bitfield(this.out, this.commandLineArgs);
                    break;
                }
                case "code": {
                    this.irpDatabase = this.commandLineArgs.setupDatabase();
                    this.commandCode.code(this.out, this.commandLineArgs, this.irpDatabase, this.originalArguments);
                    break;
                }
                case "decode": {
                    this.irpDatabase = this.commandLineArgs.setupDatabase();
                    this.commandDecode.decode(this.out, this.commandLineArgs, this.irpDatabase);
                    break;
                }
                case "demodulate": {
                    this.commandDemodulate.demodulate(this.out, this.commandLineArgs);
                    break;
                }
                case "expression": {
                    this.commandExpression.expression(this.out, this.commandLineArgs);
                    break;
                }
                case "help": {
                    this.commandHelp.help(this.out, new CommandCommonOptions(), this.argumentParser, "http://www.harctoolbox.org/IrpTransmogrifier.html");
                    break;
                }
                case "lirc": {
                    this.commandLirc.lirc(this.out, this.commandLineArgs.inputEncoding);
                    break;
                }
                case "list": {
                    this.irpDatabase = this.commandLineArgs.setupDatabase();
                    this.commandList.list(this.out, this.commandLineArgs, this.irpDatabase);
                    break;
                }
                case "render": {
                    this.irpDatabase = this.commandLineArgs.setupDatabase();
                    this.commandRender.render(this.out, this.irpDatabase, this.commandLineArgs);
                    break;
                }
                case "version": {
                    this.irpDatabase = this.commandLineArgs.setupDatabase();
                    this.commandVersion.version(this.out, this.commandLineArgs, this.irpDatabase);
                    break;
                }
                default: {
                    return new ProgramExitStatus("IrpTransmogrifier", 1, "Unknown command: " + this.command);
                }
            }
        }
        catch (OddSequenceLengthException ex) {
            return new ProgramExitStatus("IrpTransmogrifier", 2, this.command.equals("render") ? "IrSequence does not end with a gap." : ex.getLocalizedMessage() + ". Consider using --trailinggap.");
        }
        catch (NamedProtocol.TooDeepPreferOversException ex) {
            return new ProgramExitStatus("IrpTransmogrifier", 4, "Too many level of prefer-overs (10) for protocol \"" + ex.getMessage() + "\"");
        }
        catch (FileNotFoundException | UsageException | IrCoreException | ThisCannotHappenException | BitSpec.IncompatibleBitSpecException | IrpException ex) {
            return new ProgramExitStatus("IrpTransmogrifier", 2, ex.getLocalizedMessage());
        }
        catch (ParseCancellationException ex) {
            if (this.commandLineArgs.logLevel.intValue() < Level.INFO.intValue()) {
                ex.printStackTrace();
            }
            String message = ex.getLocalizedMessage() + "\nIRP parse error";
            return new ProgramExitStatus("IrpTransmogrifier", 4, message);
        }
        catch (IllegalArgumentException ex) {
            return new ProgramExitStatus("IrpTransmogrifier", 1, ex.getLocalizedMessage());
        }
        catch (IOException | SecurityException | UnsupportedOperationException | TransformerException ex) {
            ex.printStackTrace();
            return new ProgramExitStatus("IrpTransmogrifier", 3, ex.getLocalizedMessage());
        }
        catch (IrpParseException ex) {
            if (this.commandLineArgs.logLevel.intValue() < Level.INFO.intValue()) {
                ex.printStackTrace();
            }
            return new ProgramExitStatus("IrpTransmogrifier", 1, "Parse error in \"" + ex.getText() + "\": " + ex.getLocalizedMessage());
        }
        catch (NoDecoderMatchException ex) {
            return new ProgramExitStatus("IrpTransmogrifier", 2, "No decoder matched \"" + ex.getMessage() + "\". Use \"--decoder list\" to list the available decoders.");
        }
        catch (SAXException ex) {
            return new ProgramExitStatus("IrpTransmogrifier", 4, ex.getLocalizedMessage());
        }
        return new ProgramExitStatus();
    }
}

