/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.antlr.v4.gui.TreeViewer;
import org.harctoolbox.ircore.IrCoreUtils;

public final class IrpUtils {
    public static final int EXIT_SUCCESS = 0;
    public static final int EXIT_USAGE_ERROR = 1;
    public static final int EXIT_SEMANTIC_USAGE_ERROR = 2;
    public static final int EXIT_FATAL_PROGRAM_FAILURE = 3;
    public static final int EXIT_INTERNAL_FAILURE = 4;
    public static final int EXIT_CONFIG_READ_ERROR = 5;
    public static final int EXIT_CONFIG_WRITE_ERROR = 6;
    public static final int EXIT_IO_ERROR = 7;
    public static final int EXIT_XML_ERROR = 8;
    public static final int EXIT_DYNAMICLINK_ERROR = 9;
    public static final int EXIT_THIS_CANNOT_HAPPEN = 10;
    public static final int EXIT_INTERRUPTED = 11;
    public static final int EXIT_RESTART = 99;
    public static final String JP1_WIKI_URL = "http://www.hifi-remote.com/wiki/index.php?title=Main_Page";
    public static final String IRP_NOTATION_URL = "http://www.hifi-remote.com/wiki/index.php?title=IRP_Notation";
    public static final String DECODEIR_URL = "http://www.hifi-remote.com/wiki/index.php?title=DecodeIR";
    public static final String C_IDENTIFIER_REGEXP = "[A-Za-z_][A-Za-z0-9_]*";

    public static long variableGet(Map<String, Long> map, String name) {
        Objects.requireNonNull(map);
        return map.containsKey(name) ? map.get(name) : -1L;
    }

    public static String variableHeader(HashMap<String, Long> params) {
        TreeMap<String, Long> map = new TreeMap<String, Long>(params);
        map.remove("D");
        map.remove("F");
        map.remove("S");
        map.remove("T");
        String result = IrpUtils.formatVariable(params, "D", "Device Code: ", "") + IrpUtils.formatVariable(params, "S", ".", "") + " " + IrpUtils.formatVariable(params, "F", "Function: ", "") + IrpUtils.formatVariable(params, "T", ", Toggle: ", "");
        result = map.keySet().stream().map(var -> IrpUtils.formatVariable(params, var, ", " + var + "=", "")).reduce(result, String::concat);
        return result;
    }

    private static String formatVariable(HashMap<String, Long> map, String name, String prefix, String postfix) {
        if (!map.containsKey(name)) {
            return "";
        }
        return prefix + map.get(name) + postfix;
    }

    public static String toCIdentifier(String s) {
        return IrCoreUtils.toCName(s);
    }

    static Map<String, Object> propertiesMap(int noProps, Object object) {
        return IrpUtils.propertiesMap(noProps, object.getClass().getSimpleName());
    }

    static Map<String, Object> propertiesMap(int noProps, String kind) {
        HashMap<String, Object> result = new HashMap<String, Object>(noProps + 1);
        result.put("kind", kind);
        return result;
    }

    public static void showTreeViewer(TreeViewer tv, String title) {
        JPanel panel = new JPanel();
        panel.add(tv);
        JOptionPane.showMessageDialog(null, panel, title, -1);
    }

    private IrpUtils() {
    }
}

