/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.harctoolbox.irp.BitwiseParameter;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.Floatable;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.Number;
import org.harctoolbox.irp.PrimaryItem;
import org.harctoolbox.irp.RecognizeData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class Name
extends PrimaryItem
implements Floatable {
    private static final int WEIGHT = 1;
    private static Pattern namePattern = Pattern.compile("[A-Za-z_][A-Za-z0-9_]*");
    private final String name;

    public static boolean validName(String name) {
        return namePattern.matcher(name.trim()).matches();
    }

    public static long toLong(IrpParser.NameContext ctx, NameEngine nameEngine) throws NameUnassignedException {
        Expression exp = nameEngine.get(Name.toString(ctx));
        return exp.toLong(nameEngine);
    }

    public static String toString(IrpParser.NameContext ctx) {
        return ctx.getText();
    }

    public static void checkName(String candidate) throws InvalidNameException {
        if (!Name.validName(candidate)) {
            throw new InvalidNameException(candidate);
        }
    }

    public Name(IrpParser.NameContext ctx) {
        super(ctx);
        this.name = ctx.getText();
    }

    public Name(String name) throws InvalidNameException {
        super(null);
        Name.checkName(name);
        this.name = name;
    }

    @Override
    public PrimaryItem substituteConstantVariables(Map<String, Long> constantVariables) {
        return constantVariables.containsKey(this.name) ? new Number(constantVariables.get(this.name)) : this;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Name)) {
            return false;
        }
        return this.name.equals(((Name)obj).name);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + Objects.hashCode(this.name);
        return hash;
    }

    @Override
    public String toIrpString(int radix) {
        return this.name;
    }

    @Override
    public long toLong(NameEngine nameEngine) throws NameUnassignedException {
        Expression expression = nameEngine.get(this);
        return expression.toLong(nameEngine);
    }

    @Override
    public long toLong() throws NameUnassignedException {
        throw new NameUnassignedException(this.name);
    }

    @Override
    public Element toElement(Document document) {
        Element element = super.toElement(document);
        element.setTextContent(this.toString());
        return element;
    }

    @Override
    public double toFloat(GeneralSpec generalSpec, NameEngine nameEngine) throws NameUnassignedException {
        return this.toLong(nameEngine);
    }

    @Override
    public boolean constant(NameEngine nameEngine) {
        try {
            Expression expression = nameEngine.get(this);
            return expression.constant(nameEngine);
        }
        catch (NameUnassignedException ex) {
            return false;
        }
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public int weight() {
        return 1;
    }

    @Override
    public Map<String, Object> propertiesMap(boolean eval, GeneralSpec generalSpec, NameEngine nameEngine) {
        Map<String, Object> map = super.propertiesMap(4);
        map.put("name", this.name);
        map.put("eval", eval);
        map.put("scalar", eval);
        map.put("isDefinition", nameEngine.containsKey(this.name));
        return map;
    }

    @Override
    public BitwiseParameter invert(BitwiseParameter rhs, RecognizeData nameEngine) {
        return rhs;
    }

    @Override
    public PrimaryItem leftHandSide() {
        return this;
    }

    @Override
    public BitwiseParameter toBitwiseParameter(RecognizeData recognizeData) {
        return recognizeData.toBitwiseParameter(this.toString());
    }
}

