/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.AggregateLister;
import org.harctoolbox.irp.Decoder;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrpObject;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.Name;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.NumberExpression;
import org.harctoolbox.irp.ParameterInconsistencyException;
import org.harctoolbox.irp.ParserDriver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class NameEngine
extends IrpObject
implements AggregateLister,
Iterable<Map.Entry<String, Expression>> {
    private static final int WEIGHT = 0;
    private static final Logger logger = Logger.getLogger(NameEngine.class.getName());
    public static final NameEngine EMPTY = new NameEngine();
    private Map<String, Expression> map;

    public static NameEngine parseLoose(String str) {
        if (str == null || str.trim().isEmpty()) {
            return new NameEngine();
        }
        String payload = str.trim().replaceFirst("^\\{", "").replaceFirst("\\}$", "").replaceAll("\\s*=\\s*", "=");
        String[] definitions = payload.split("[\\s,;]+");
        return NameEngine.parse(definitions);
    }

    public static NameEngine parse(String[] definitions) {
        NameEngine nameEngine = new NameEngine();
        for (String definition : definitions) {
            ParserDriver parserDriver = new ParserDriver(definition);
            nameEngine.parseDefinition(parserDriver.getParser().definition());
        }
        return nameEngine;
    }

    private static Element mkElement(Document document, Map.Entry<String, Expression> definition) {
        Element element = document.createElement("Definition");
        try {
            element.appendChild(new Name(definition.getKey()).toElement(document));
        }
        catch (InvalidNameException ex) {
            throw new ThisCannotHappenException(ex);
        }
        element.appendChild(definition.getValue().toElement(document));
        return element;
    }

    private static HashMap<String, Expression> mapConvert(Map<String, Long> numericalParameters) {
        HashMap<String, Expression> result = new HashMap<String, Expression>(numericalParameters.size());
        numericalParameters.entrySet().forEach(kvp -> result.put((String)kvp.getKey(), new NumberExpression((Number)kvp.getValue())));
        return result;
    }

    public NameEngine(Map<String, Long> numericalParameters) {
        this(null, NameEngine.mapConvert(numericalParameters));
    }

    public NameEngine() {
        this(0);
    }

    public NameEngine(int initialCapacity) {
        this(null, new HashMap<String, Expression>(initialCapacity));
    }

    private NameEngine(IrpParser.DefinitionsContext ctx, Map<String, Expression> map) {
        super(ctx);
        this.map = map;
    }

    private NameEngine(IrpParser.DefinitionsContext ctx, int initialCapacity) {
        this(ctx, new LinkedHashMap<String, Expression>(initialCapacity));
    }

    private NameEngine(IrpParser.DefinitionsContext ctx) {
        this(ctx, 4);
        this.parseDefinitions(ctx.definitions_list());
    }

    public NameEngine(String str) throws InvalidNameException {
        this(new ParserDriver(str));
    }

    private NameEngine(ParserDriver parserDriver) throws InvalidNameException {
        this(parserDriver.getParser().definitions());
    }

    public NameEngine(NameEngine orig) {
        this(null, new HashMap<String, Expression>(orig.map));
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.map);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NameEngine other = (NameEngine)obj;
        return Objects.equals(this.map, other.map);
    }

    public int size() {
        return this.map.size();
    }

    public boolean numericallyEquals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NameEngine)) {
            return false;
        }
        NameEngine other = (NameEngine)object;
        if (other.size() != this.size()) {
            return false;
        }
        for (Map.Entry<String, Expression> kvp : this.map.entrySet()) {
            try {
                Expression expr;
                String name = kvp.getKey();
                long value = kvp.getValue().toLong(this);
                if (value == (expr = other.get(name)).toLong(other)) continue;
                logger.log(Level.INFO, "Variable \"{0}\" valued {1} instead of {2}", new Object[]{name, value, expr.toLong(other)});
                return false;
            }
            catch (NameUnassignedException ex) {
                return false;
            }
        }
        return true;
    }

    public boolean numericallyEquals(Map<String, Long> other) {
        if (other == null) {
            return false;
        }
        if (other.size() != this.size()) {
            return false;
        }
        for (Map.Entry<String, Expression> kvp : this.map.entrySet()) {
            try {
                String name = kvp.getKey();
                long value = kvp.getValue().toLong(this);
                if (value == other.get(name)) continue;
                return false;
            }
            catch (NameUnassignedException ex) {
                logger.log(Level.SEVERE, null, ex);
                return false;
            }
        }
        return true;
    }

    public boolean numericallyEquals(NameEngine other) {
        try {
            return this.numericallyEquals(other.toMap());
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean numericallyEquals(Decoder.Decode other) {
        try {
            return this.numericallyEquals(other.getMap());
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public Iterator<Map.Entry<String, Expression>> iterator() {
        return this.map.entrySet().iterator();
    }

    private void define(String name, IrpParser.ExpressionContext ctx) throws InvalidNameException {
        this.define(name, Expression.newExpression(ctx));
    }

    public void define(String name, Expression expression) throws InvalidNameException {
        Name.checkName(name);
        this.map.put(name, expression);
    }

    public void define(String name, Number value) throws InvalidNameException {
        this.define(name, new NumberExpression(value));
    }

    public void parseDefinitions(String str) {
        ParserDriver parserDriver = new ParserDriver(str);
        this.parseDefinitions(parserDriver.getParser().definitions());
    }

    public void parseDefinitions(IrpParser.DefinitionsContext ctx) {
        this.parseDefinitions(ctx.definitions_list());
    }

    private void parseDefinition(IrpParser.DefinitionContext ctx) {
        try {
            this.define(ctx.name().getText(), ctx.expression());
        }
        catch (InvalidNameException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    private void parseDefinitions(IrpParser.Definitions_listContext definitions_list) {
        this.parseDefinitions(definitions_list.definition());
    }

    private void parseDefinitions(List<IrpParser.DefinitionContext> list) {
        list.forEach(def -> this.parseDefinition((IrpParser.DefinitionContext)def));
    }

    public Expression get(String name) throws NameUnassignedException {
        Expression expression = this.map.get(name);
        if (expression == null) {
            throw new NameUnassignedException(name);
        }
        return expression;
    }

    public Expression get(Name name) throws NameUnassignedException {
        return this.get(name.toString());
    }

    public Expression getPossiblyNull(String name) {
        return this.map.get(name);
    }

    public long toLong(String name) throws NameUnassignedException {
        Expression expression = this.get(name);
        return expression.toLong(this);
    }

    public boolean containsKey(String name) {
        return this.map.containsKey(name);
    }

    void add(NameEngine definitions) {
        this.map.putAll(definitions.map);
    }

    @Override
    public String toIrpString(int radix) {
        return this.toIrpString(radix, "");
    }

    String toIrpString(int radix, String separator) {
        if (this.map.isEmpty()) {
            return "";
        }
        StringJoiner stringJoiner = new StringJoiner("," + separator, "{", "}");
        this.map.keySet().stream().sorted().forEach(key -> stringJoiner.add(key + "=" + this.map.get(key).toIrpString(radix)));
        return stringJoiner.toString();
    }

    @Override
    public Element toElement(Document document) {
        Element root = document.createElement("Definitions");
        this.map.entrySet().forEach(definition -> root.appendChild(NameEngine.mkElement(document, definition)));
        return root;
    }

    public Set<String> getNames() {
        return this.map.keySet();
    }

    public Map<String, Long> toMap() {
        HashMap<String, Long> result = new HashMap<String, Long>(this.map.size());
        this.map.entrySet().forEach(kvp -> {
            try {
                result.put((String)kvp.getKey(), ((Expression)kvp.getValue()).toLong(this));
            }
            catch (NameUnassignedException ex) {
                throw new ThisCannotHappenException(ex);
            }
        });
        return result;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    void addBarfByConflicts(NameEngine nameEngine) throws ParameterInconsistencyException {
        for (Map.Entry<String, Expression> kvp : nameEngine.map.entrySet()) {
            String name = kvp.getKey();
            Expression val = kvp.getValue();
            if (this.map.containsKey(name)) {
                try {
                    if (this.map.get(name).toLong(this) == val.toLong(nameEngine)) continue;
                    logger.log(Level.FINER, "Name conflict {0}", name);
                    throw new ParameterInconsistencyException(name, this.map.get(name).toLong(this), val.toLong(nameEngine));
                }
                catch (NameUnassignedException ex) {
                    throw new ThisCannotHappenException(ex);
                }
            }
            this.map.put(name, val);
        }
    }

    @Override
    public int weight() {
        return 0;
    }

    @Override
    public Map<String, Object> propertiesMap(GeneralSpec generalSpec, NameEngine nameEngine) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("kind", this.getClass().getSimpleName());
        ArrayList list = new ArrayList(this.map.size());
        result.put("list", list);
        this.map.entrySet().stream().map(kvp -> {
            HashMap<String, Object> m = new HashMap<String, Object>(2);
            m.put("name", kvp.getKey());
            m.put("expression", ((Expression)kvp.getValue()).propertiesMap(true, generalSpec, nameEngine));
            return m;
        }).forEachOrdered(m -> list.add(m));
        return result;
    }

    Map<String, Long> getNumericLiterals() {
        HashMap<String, Long> result = new HashMap<String, Long>(this.size());
        this.map.entrySet().forEach(kvp -> {
            String name = (String)kvp.getKey();
            Expression exp = (Expression)kvp.getValue();
            try {
                long val = exp.toLong();
                result.put(name, val);
            }
            catch (NameUnassignedException nameUnassignedException) {
                // empty catch block
            }
        });
        return result;
    }

    NameEngine remove(Iterable<String> names) {
        NameEngine result = new NameEngine(this);
        names.forEach(key -> result.map.remove(key));
        return result;
    }
}

