/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.BitwiseParameter;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.Name;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.PrimaryItem;
import org.harctoolbox.irp.PrimaryItemExpression;
import org.harctoolbox.irp.RecognizeData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class NameExpression
extends PrimaryItemExpression {
    private final Name name;

    static Expression newExpression(ParseTree original, IrpParser.NameContext nameContext) {
        try {
            return new NameExpression(original, nameContext.getText());
        }
        catch (InvalidNameException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    static Expression newExpression(Name name) {
        return new NameExpression(null, name);
    }

    private NameExpression(ParseTree original, String text) throws InvalidNameException {
        this(original, new Name(text));
    }

    private NameExpression(ParseTree original, Name name) {
        super(original);
        this.name = name;
    }

    @Override
    public String toIrpString(int radix) {
        return this.name.toIrpString(radix);
    }

    @Override
    public Map<String, Object> propertiesMap(boolean eval, GeneralSpec generalSpec, NameEngine nameEngine) {
        Map<String, Object> map = this.name.propertiesMap(true, generalSpec, nameEngine);
        map.put("scalar", true);
        return map;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + Objects.hashCode(this.name);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NameExpression other = (NameExpression)obj;
        return Objects.equals(this.name, other.name);
    }

    @Override
    public long toLong(NameEngine nameEngine) throws NameUnassignedException {
        return this.name.toLong(nameEngine);
    }

    @Override
    public BitwiseParameter toBitwiseParameter(RecognizeData recognizeData) {
        return this.name.toBitwiseParameter(recognizeData);
    }

    @Override
    public Element toElement(Document document) {
        Element el = super.toElement(document);
        el.appendChild(this.name.toElement(document));
        return el;
    }

    @Override
    public BitwiseParameter invert(BitwiseParameter rhs, RecognizeData nameEngine) {
        return rhs;
    }

    @Override
    public PrimaryItem leftHandSide() {
        return this.name;
    }

    @Override
    public PrimaryItem substituteConstantVariables(Map<String, Long> constantVariables) {
        return this.name.substituteConstantVariables(constantVariables);
    }

    @Override
    public boolean constant(NameEngine nameEngine) {
        return this.name.constant(nameEngine);
    }
}

