/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.ModulatedIrSequence;
import org.harctoolbox.ircore.OddSequenceLengthException;
import org.harctoolbox.irp.CodeGenerator;
import org.harctoolbox.irp.Decoder;
import org.harctoolbox.irp.DomainViolationException;
import org.harctoolbox.irp.HasPreferOvers;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrpDatabase;
import org.harctoolbox.irp.IrpException;
import org.harctoolbox.irp.IrpInvalidArgumentException;
import org.harctoolbox.irp.IrpUtils;
import org.harctoolbox.irp.ItemCodeGenerator;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.PreferOver;
import org.harctoolbox.irp.Protocol;
import org.harctoolbox.irp.SignalRecognitionException;
import org.harctoolbox.irp.UnknownProtocolException;
import org.harctoolbox.irp.UnsupportedRepeatException;
import org.harctoolbox.xml.DumbHtmlRenderer;
import org.harctoolbox.xml.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class NamedProtocol
extends Protocol
implements HasPreferOvers,
Comparable<NamedProtocol> {
    private static final Logger logger = Logger.getLogger(NamedProtocol.class.getName());
    private static final int MAX_NESTED_PREFER_OVERS = 10;
    private final String name;
    private final transient DocumentFragment htmlDocumentation;
    private final Double absoluteTolerance;
    private final Double relativeTolerance;
    private final Double frequencyTolerance;
    private final Double frequencyLower;
    private final Double frequencyUpper;
    private final Double minimumLeadout;
    private final boolean decodable;
    private final List<PreferOver> preferOver;
    private final Map<String, List<String>> auxParameters;
    private final boolean rejectRepeatless;

    public static Document toDocument(Iterable<NamedProtocol> protocols) {
        Document document = XmlUtils.newDocument();
        Element root = document.createElement("named-protocols");
        document.appendChild(root);
        for (NamedProtocol protocol : protocols) {
            Element el = protocol.toElement(document);
            root.appendChild(el);
        }
        return document;
    }

    private static void putParameter(Map<String, Object> map, String parameterName, Double userValue, Double databaseValue) {
        if (userValue != null) {
            map.put(parameterName, userValue);
        } else if (databaseValue != null) {
            map.put(parameterName, databaseValue);
        }
    }

    private static boolean inInterval(double x, double lower, double upper) {
        return lower <= x && x <= upper;
    }

    private static double getDoubleWithSubstitute(Double value, double fallback) {
        return value != null ? value : fallback;
    }

    public NamedProtocol(String name, String irp, DocumentFragment htmlDocumentation, String frequencyTolerance, String frequencyLower, String frequencyUpper, String absoluteTolerance, String relativeTolerance, String minimumLeadout, String decodable, String rejectRepeatless, List<String> preferOver, Map<String, List<String>> map) throws InvalidNameException, UnsupportedRepeatException, NameUnassignedException, IrpInvalidArgumentException {
        super(irp);
        this.name = name;
        this.htmlDocumentation = htmlDocumentation;
        this.frequencyTolerance = frequencyTolerance != null ? Double.valueOf(frequencyTolerance) : null;
        this.frequencyLower = frequencyLower != null ? Double.valueOf(frequencyLower) : null;
        this.frequencyUpper = frequencyUpper != null ? Double.valueOf(frequencyUpper) : null;
        this.absoluteTolerance = absoluteTolerance != null ? Double.valueOf(absoluteTolerance) : null;
        this.relativeTolerance = relativeTolerance != null ? Double.valueOf(relativeTolerance) : null;
        this.minimumLeadout = minimumLeadout != null ? Double.valueOf(minimumLeadout) : null;
        this.decodable = decodable == null || Boolean.parseBoolean(decodable);
        this.rejectRepeatless = rejectRepeatless != null && Boolean.parseBoolean(rejectRepeatless);
        this.preferOver = PreferOver.parse(preferOver);
        this.auxParameters = new HashMap<String, List<String>>(map.size());
        map.entrySet().stream().filter(kvp -> !IrpDatabase.isKnownKeyword((String)kvp.getKey())).forEach(kvp -> this.auxParameters.put((String)kvp.getKey(), (List)kvp.getValue()));
    }

    public NamedProtocol(String name, String irp, DocumentFragment documentation) throws InvalidNameException, UnsupportedRepeatException, NameUnassignedException, IrpInvalidArgumentException {
        this(name, irp, documentation, null, null, null, null, null, null, null, null, null, new HashMap<String, List<String>>(0));
    }

    public Set<String> preferredOvers() {
        HashSet<String> result = new HashSet<String>(16);
        for (PreferOver prefOver : this.preferOver) {
            String remove = prefOver.toBeRemoved();
            if (remove == null) continue;
            result.add(remove);
        }
        return result;
    }

    public Set<String> preferredOvers(Map<String, Long> params) {
        HashSet<String> result = new HashSet<String>(16);
        for (PreferOver prefOver : this.preferOver) {
            String remove = prefOver.toBeRemoved(params);
            if (remove == null) continue;
            result.add(remove);
        }
        return result;
    }

    public Set<String> preferredOvers(IrpDatabase irpDatabase) throws InvalidNameException, UnsupportedRepeatException, IrpInvalidArgumentException, NameUnassignedException, TooDeepPreferOversException {
        return this.preferredOvers(irpDatabase, 0);
    }

    public Set<String> preferredOvers(IrpDatabase irpDatabase, int level) throws UnsupportedRepeatException, IrpInvalidArgumentException, NameUnassignedException, TooDeepPreferOversException {
        if (level >= 10) {
            throw new TooDeepPreferOversException(this.name);
        }
        HashSet<String> result = new HashSet<String>(16);
        for (PreferOver prefOver : this.preferOver) {
            String remove = prefOver.toBeRemoved();
            if (remove == null) continue;
            result.add(remove);
            try {
                NamedProtocol namedProtocol = irpDatabase.getNamedProtocol(remove);
                Set<String> secondary = namedProtocol.preferredOvers(irpDatabase);
                result.addAll(secondary);
            }
            catch (InvalidNameException | UnknownProtocolException ex) {
                logger.log(Level.SEVERE, "{0}", ex.getMessage());
            }
        }
        return result;
    }

    public void dumpPreferOvers(PrintStream out) {
        out.println(this.name + ":");
        this.preferOver.forEach(prefOver -> out.println("\t" + prefOver));
    }

    public void dumpPreferOvers(PrintStream out, IrpDatabase irpDatabase) throws TooDeepPreferOversException {
        this.dumpPreferOvers(out, irpDatabase, 0);
    }

    public void dumpPreferOvers(PrintStream out, IrpDatabase irpDatabase, int level) throws TooDeepPreferOversException {
        if (level >= 10) {
            throw new TooDeepPreferOversException(this.name);
        }
        for (PreferOver prefOver : this.preferOver) {
            String r = prefOver.toBeRemoved();
            try {
                out.println(IrCoreUtils.tabs(level + 1) + prefOver);
                NamedProtocol namedProtocol = irpDatabase.getNamedProtocol(r);
                namedProtocol.dumpPreferOvers(out, irpDatabase, level + 1);
            }
            catch (UnknownProtocolException ex) {
                logger.log(Level.WARNING, "{0}", ex.getMessage());
            }
            catch (InvalidNameException | IrpInvalidArgumentException | NameUnassignedException | UnsupportedRepeatException ex) {
                Logger.getLogger(NamedProtocol.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public Map<String, Long> recognize(IrSignal irSignal, boolean strict) throws SignalRecognitionException, Protocol.ProtocolNotDecodableException {
        Decoder.DecoderParameters params = new Decoder.DecoderParameters();
        return this.recognize(irSignal, params);
    }

    @Override
    public Map<String, Long> recognize(IrSignal irSignal, Decoder.DecoderParameters params) throws Protocol.ProtocolNotDecodableException, SignalRecognitionException {
        if (!this.isDecodeable()) {
            throw new Protocol.ProtocolNotDecodableException(this.name);
        }
        logger.log(Level.FINE, "Protocol: {0}: \"{1}\", actual data: {2}", new Object[]{this.getName(), this.getIrp(), irSignal.toString(true)});
        Decoder.DecoderParameters fixedParams = params.select(this.isRejectRepeats(), this.frequencyTolerance, this.absoluteTolerance, this.relativeTolerance, this.minimumLeadout);
        return super.recognize(irSignal, fixedParams);
    }

    public Decoder.Decode recognize(ModulatedIrSequence irSequence, int beginPos, Decoder.DecoderParameters userSuppliedDecoderParameters) throws SignalRecognitionException, Protocol.ProtocolNotDecodableException {
        if (!this.isDecodeable()) {
            throw new Protocol.ProtocolNotDecodableException(this.name);
        }
        logger.log(Level.FINE, "Protocol: {0}: \"{1}\", actual data: {2}", new Object[]{this.getName(), this.getIrp(), irSequence.toString(true)});
        Decoder.DecoderParameters actualParameters = userSuppliedDecoderParameters.select(false, this.frequencyTolerance, this.absoluteTolerance, this.relativeTolerance, this.minimumLeadout);
        Decoder.Decode decode = super.recognize(irSequence, beginPos, this.isRejectRepeats(), actualParameters);
        return new Decoder.Decode(this, decode);
    }

    @Override
    protected void checkFrequency(Double frequency, Decoder.DecoderParameters params) throws SignalRecognitionException {
        if (params.getFrequencyTolerance() < 0.0) {
            logger.log(Level.FINER, "Frequency not checked since frequencyTolerance < 0");
            return;
        }
        double lower = this.frequencyLower != null ? this.frequencyLower : this.getFrequencyWithDefault() - params.getFrequencyTolerance();
        double upper = this.frequencyUpper != null ? this.frequencyUpper : this.getFrequencyWithDefault() + params.getFrequencyTolerance();
        boolean success = NamedProtocol.inInterval(frequency, lower, upper);
        logger.log(Level.FINER, "Frequency was checked, {0}OK.", success ? "" : "NOT ");
        if (!success) {
            throw new SignalRecognitionException("Frequency does not match");
        }
    }

    @Override
    public String warningsString() {
        String str = super.warningsString();
        if (!this.name.matches("[A-Za-z_][A-Za-z0-9_]*")) {
            str = str + "WARNING: The name \"" + this.name + "\" is not a valid C name." + IrCoreUtils.LINE_SEPARATOR;
        }
        return str;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 41 * hash + Objects.hashCode(this.name);
        hash = 41 * hash + Objects.hashCode(this.htmlDocumentation);
        hash = 41 * hash + Objects.hashCode(this.absoluteTolerance);
        hash = 41 * hash + Objects.hashCode(this.relativeTolerance);
        hash = 41 * hash + Objects.hashCode(this.frequencyTolerance);
        hash = 41 * hash + Objects.hashCode(this.minimumLeadout);
        hash = 41 * hash + Objects.hashCode(this.decodable);
        hash = 41 * hash + Objects.hashCode(this.preferOver);
        hash = 41 * hash + Objects.hashCode(this.auxParameters);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof NamedProtocol)) {
            return false;
        }
        NamedProtocol other = (NamedProtocol)obj;
        return super.equals(obj) && this.name.equals(other.name) && this.htmlDocumentation.equals(other.htmlDocumentation) && Double.compare(this.absoluteTolerance, other.absoluteTolerance) == 0 && Double.compare(this.relativeTolerance, other.relativeTolerance) == 0 && Double.compare(this.frequencyTolerance, other.frequencyTolerance) == 0 && Double.compare(this.minimumLeadout, other.minimumLeadout) == 0 && this.decodable == other.decodable && this.preferOver.equals(other.preferOver) && this.auxParameters.equals(other.auxParameters);
    }

    public IrSignal render(NameEngine nameEngine) throws DomainViolationException, NameUnassignedException, IrpInvalidArgumentException, InvalidNameException, Protocol.ProtocolNotRenderableException, OddSequenceLengthException {
        List<String> list = this.auxParameters.get("decode-only");
        if (list != null && Boolean.parseBoolean(list.get(0))) {
            throw new Protocol.ProtocolNotRenderableException(this.name);
        }
        return super.toIrSignal(nameEngine);
    }

    @Override
    public String toString() {
        return this.name + ": " + super.toString();
    }

    @Override
    public String toString(int radix) {
        return this.name + ": " + super.toString(radix);
    }

    @Override
    public String toString(int radix, String separator) {
        return this.toString(radix);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public DocumentFragment getDocumentation() {
        return this.htmlDocumentation;
    }

    public boolean isDecodeable() {
        return this.decodable;
    }

    public boolean isRejectRepeats() {
        return this.rejectRepeatless;
    }

    public Double getRelativeTolerance() {
        return this.relativeTolerance;
    }

    public double getRelativeToleranceWithDefault() {
        return NamedProtocol.getDoubleWithSubstitute(this.relativeTolerance, 0.3);
    }

    public Double getAbsoluteTolerance() {
        return this.absoluteTolerance;
    }

    public double getAbsoluteToleranceWithDefault() {
        return NamedProtocol.getDoubleWithSubstitute(this.absoluteTolerance, 100.0);
    }

    public Double getFrequencyTolerance() {
        return this.frequencyTolerance;
    }

    public double getFrequencyToleranceWithDefault() {
        return NamedProtocol.getDoubleWithSubstitute(this.frequencyTolerance, 2000.0);
    }

    public Double getFrequencyUpper() {
        return this.frequencyUpper;
    }

    public Double getFrequencyLower() {
        return this.frequencyLower;
    }

    public Double getMinimumLeadout() {
        return this.minimumLeadout;
    }

    public double getMinimumLeadoutWithDefault() {
        return NamedProtocol.getDoubleWithSubstitute(this.minimumLeadout, 20000.0);
    }

    List<PreferOver> getPreferOver() {
        return Collections.unmodifiableList(this.preferOver);
    }

    @Override
    public Set<String> getPreferOverNames() {
        HashSet<String> result = new HashSet<String>(this.preferOver.size());
        this.preferOver.forEach(po -> result.add(po.toBeRemoved()));
        return result;
    }

    @Override
    public Document toDocument() {
        Document document = XmlUtils.newDocument();
        document.appendChild(this.toElement(document));
        return document;
    }

    @Override
    public Element toElement(Document document) {
        Element root = super.toElement(document);
        root.setAttribute("name", this.getName());
        XmlUtils.addAttributeIfNonNull(root, "absolute-tolerance", this.absoluteTolerance);
        XmlUtils.addAttributeIfNonNull(root, "relative-tolerance", this.relativeTolerance);
        XmlUtils.addAttributeIfNonNull(root, "frequency-tolerance", this.frequencyTolerance);
        XmlUtils.addAttributeIfNonNull(root, "frequency-lower", this.frequencyLower);
        XmlUtils.addAttributeIfNonNull(root, "frequency-upper", this.frequencyUpper);
        XmlUtils.addAttributeIfNonNull(root, "minimum-leadout", this.minimumLeadout);
        XmlUtils.addBooleanAttributeIfFalse(root, "decodable", this.decodable);
        XmlUtils.addBooleanAttributeIfTrue(root, "reject-repeatless", this.rejectRepeatless);
        DocumentFragment html = this.getDocumentation();
        if (html != null) {
            Element docu = document.createElement("Html");
            docu.appendChild(document.adoptNode(html.cloneNode(true)));
            root.appendChild(docu);
            Element textDocu = document.createElement("Documentation");
            String textdoc = DumbHtmlRenderer.render(this.getDocumentation());
            textDocu.setTextContent(textdoc);
            root.appendChild(textDocu);
        }
        Element irpElement = document.createElement("Irp");
        irpElement.appendChild(document.createTextNode(this.getIrp()));
        root.appendChild(irpElement);
        Element parameters = document.createElement("Parameters");
        root.appendChild(parameters);
        for (Map.Entry<String, List<String>> param : this.auxParameters.entrySet()) {
            Element parameter = document.createElement("Parameter");
            parameters.appendChild(parameter);
            parameter.setAttribute("name", param.getKey());
            param.getValue().stream().map(val -> {
                Element value = document.createElement("Value");
                value.setTextContent((String)val);
                return value;
            }).forEachOrdered(value -> parameter.appendChild((Node)value));
        }
        return root;
    }

    ItemCodeGenerator code(CodeGenerator codeGenerator, Map<String, String> parameters, Double absoluteTolerance, Double relativeTolerance, Double frequencyTolerance) {
        ItemCodeGenerator template = codeGenerator.newItemCodeGenerator(this);
        template.addAggregateList("metaData", this.metaDataPropertiesMap(parameters, absoluteTolerance, relativeTolerance, frequencyTolerance));
        template.addAggregateList("protocol", this, this.getGeneralSpec(), this.getDefinitions());
        return template;
    }

    private Map<String, Object> metaDataPropertiesMap(Map<String, String> parameters, Double userAbsoluteTolerance, Double userRelativeTolerance, Double userFrequencyTolerance) {
        Map<String, Object> map = IrpUtils.propertiesMap(parameters.size() + 11, this);
        this.auxParameters.entrySet().forEach(kvp -> map.put((String)kvp.getKey(), kvp.getValue()));
        map.put("protocolName", this.getName());
        map.put("irp", this.getIrp());
        map.put("documentation", IrCoreUtils.javaifyString(DumbHtmlRenderer.render(this.getDocumentation())));
        NamedProtocol.putParameter(map, "relative-tolerance", userRelativeTolerance, this.relativeTolerance);
        NamedProtocol.putParameter(map, "absolute-tolerance", userAbsoluteTolerance, this.absoluteTolerance);
        NamedProtocol.putParameter(map, "frequency-tolerance", userFrequencyTolerance, this.frequencyTolerance);
        map.putAll(parameters);
        return map;
    }

    @Override
    public int compareTo(NamedProtocol namedProtocol) {
        return IrCoreUtils.lexicalCompare(this.name.compareTo(namedProtocol.name), this.toIrpString().compareTo(namedProtocol.toIrpString()));
    }

    public static class TooDeepPreferOversException
    extends IrpException {
        public static final int MAX_NESTED_PREFER_OVERS = 10;

        private TooDeepPreferOversException(String name) {
            super(name);
        }
    }
}

