/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.irp.BitwiseParameter;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NumberExpression;
import org.harctoolbox.irp.PrimaryItem;
import org.harctoolbox.irp.RecognizeData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class Number
extends PrimaryItem {
    private static final int WEIGHT = 1;
    public static final int SIZE = 64;
    private static final long UINT8_MAX = 255L;
    private static final long UINT16_MAX = 65535L;
    private static final long UINT24_MAX = 0xFFFFFFL;
    private static final long UINT32_MAX = 0xFFFFFFFFL;
    private static final long UINT64_MAX = -1L;
    private java.lang.Number data;

    static NumberExpression newExpression(IrpParser.NumberContext child) {
        return Number.newExpression(child.getText());
    }

    static NumberExpression newExpression(String str) {
        java.lang.Number num = Number.parse(str);
        return new NumberExpression(num);
    }

    static java.lang.Number parse(IrpParser.NumberContext ctx) {
        return Number.parse(ctx.getText());
    }

    public static java.lang.Number parse(String str) {
        String s;
        int radix;
        if (str.length() >= 3 && str.substring(0, 2).equals("0x")) {
            radix = 16;
            s = str.substring(2);
        } else if (str.length() >= 3 && str.substring(0, 2).equals("0b")) {
            radix = 2;
            s = str.substring(2);
        } else if (str.length() >= 2 && str.substring(0, 1).equals("0")) {
            radix = 8;
            s = str.substring(1);
        } else {
            radix = 10;
            s = str;
        }
        return Number.parse(s, radix);
    }

    public static java.lang.Number parse(String str, int radix) {
        try {
            return Long.valueOf(str, radix);
        }
        catch (NumberFormatException ex) {
            return str.equals("UINT8_MAX") ? (java.lang.Number)255L : (java.lang.Number)(str.equals("UINT16_MAX") ? (java.lang.Number)65535L : (java.lang.Number)(str.equals("UINT24_MAX") ? (java.lang.Number)0xFFFFFFL : (java.lang.Number)(str.equals("UINT32_MAX") ? (java.lang.Number)0xFFFFFFFFL : (java.lang.Number)(str.equals("UINT64_MAX") ? Long.valueOf(-1L) : new BigInteger(str, radix)))));
        }
    }

    private static String pad(String rawString, int length, double noBits) {
        StringBuilder str = new StringBuilder(rawString);
        int effectiveLength = (int)Math.ceil((double)length / noBits);
        while (str.length() < effectiveLength) {
            str.insert(0, '0');
        }
        return str.toString();
    }

    public Number(java.lang.Number n) {
        super(null);
        this.data = n;
    }

    public Number(IrpParser.NumberContext ctx) {
        this(ctx.getText());
    }

    public Number(TerminalNode n) {
        this(n.getText());
    }

    public Number(String str) {
        this(Number.parse(str));
    }

    public long longValueExact() throws ArithmeticException {
        return this.data instanceof BigInteger ? ((BigInteger)this.data).longValueExact() : this.data.longValue();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Number)) {
            return false;
        }
        Number other = (Number)obj;
        if (this.data.equals(other.data)) {
            return true;
        }
        try {
            return this.longValueExact() == other.longValueExact();
        }
        catch (ArithmeticException ex) {
            return false;
        }
    }

    public boolean isZero() {
        return this.data instanceof Long ? this.data.longValue() == 0L : this.data.equals(BigInteger.ZERO);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.data);
        return hash;
    }

    public Number shiftRight(int n) {
        return this.data instanceof Long ? new Number((Long)this.data >> n) : new Number(((BigInteger)this.data).shiftRight(n));
    }

    long and(long mask) {
        return this.data instanceof Long ? (Long)this.data & mask : ((BigInteger)this.data).and(BigInteger.valueOf(mask)).longValueExact();
    }

    @Override
    public String toString(int radix) {
        return IrCoreUtils.radixPrefix(radix) + (this.data instanceof BigInteger ? ((BigInteger)this.data).toString(radix) : Long.toUnsignedString(this.data.longValue(), radix));
    }

    @Override
    public long toLong(NameEngine nameEngine) throws ArithmeticException {
        return this.toLong();
    }

    @Override
    public BitwiseParameter toBitwiseParameter(RecognizeData recognizeData) {
        return new BitwiseParameter(this.toLong());
    }

    @Override
    public long toLong() throws ArithmeticException {
        return this.longValueExact();
    }

    @Override
    public String toIrpString(int radix) {
        return this.toString(radix);
    }

    @Override
    public Element toElement(Document document) {
        Element element = super.toElement(document);
        element.setTextContent(this.toString());
        return element;
    }

    @Override
    public int weight() {
        return 1;
    }

    @Override
    public Map<String, Object> propertiesMap(boolean eval, GeneralSpec generalSpec, NameEngine nameEngine) {
        Map<String, Object> map = super.propertiesMap(1);
        map.put("value", this.toString());
        return map;
    }

    @Override
    public BitwiseParameter invert(BitwiseParameter rhs, RecognizeData nameEngine) {
        return rhs;
    }

    @Override
    public PrimaryItem leftHandSide() {
        return this;
    }

    @Override
    public PrimaryItem substituteConstantVariables(Map<String, Long> constantVariables) {
        return this;
    }

    public String formatIntegerWithLeadingZeros(int radix, int length) {
        return IrCoreUtils.radixPrefix(radix) + (this.data instanceof Long ? IrCoreUtils.formatIntegerWithLeadingZeros(this.data.longValue(), radix, length) : Number.pad(((BigInteger)this.data).toString(radix), length, Math.log(radix) / Math.log(2.0)));
    }

    public boolean testBit(int n) {
        return this.data instanceof Long ? ((Long)this.data & 1L << n) != 0L : ((BigInteger)this.data).testBit(n);
    }

    @Override
    public boolean constant(NameEngine nameEngine) {
        return true;
    }
}

