/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;
import org.harctoolbox.irp.BitwiseParameter;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.Number;
import org.harctoolbox.irp.PrimaryItem;
import org.harctoolbox.irp.PrimaryItemExpression;
import org.harctoolbox.irp.RecognizeData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class NumberExpression
extends PrimaryItemExpression {
    private final Number number;

    static NumberExpression newExpression(IrpParser.NumberContext numberContext) {
        return new NumberExpression(numberContext, numberContext);
    }

    static NumberExpression newExpression(ParseTree ctx, IrpParser.NumberContext numberContext) {
        return new NumberExpression(ctx, numberContext);
    }

    NumberExpression(java.lang.Number value) {
        super(null);
        this.number = new Number(value);
    }

    private NumberExpression(ParseTree original, IrpParser.NumberContext ctx) {
        super(original);
        this.number = new Number(ctx.getText());
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + Objects.hashCode(this.number);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberExpression other = (NumberExpression)obj;
        return Objects.equals(this.number, other.number);
    }

    @Override
    public long toLong() {
        return this.number.toLong();
    }

    @Override
    public long toLong(NameEngine nameEngine) {
        return this.number.toLong();
    }

    @Override
    public Number toNumber() {
        return this.number;
    }

    @Override
    public Element toElement(Document document) {
        Element el = super.toElement(document);
        el.appendChild(this.number.toElement(document));
        return el;
    }

    @Override
    public String toIrpString(int radix) {
        return this.number.toIrpString(radix);
    }

    @Override
    public Map<String, Object> propertiesMap(boolean eval, GeneralSpec generalSpec, NameEngine nameEngine) {
        Map<String, Object> map = this.number.propertiesMap(eval, generalSpec, nameEngine);
        map.put("scalar", true);
        return map;
    }

    public Long invert(long rhs, NameEngine nameEngine, long bitmask) {
        return rhs & bitmask;
    }

    @Override
    public PrimaryItem leftHandSide() {
        return null;
    }

    @Override
    public boolean isNumericLiteral() {
        return true;
    }

    @Override
    public PrimaryItem substituteConstantVariables(Map<String, Long> constantVariables) {
        return this;
    }

    @Override
    public boolean constant(NameEngine nameEngine) {
        return true;
    }

    @Override
    public BitwiseParameter toBitwiseParameter(RecognizeData recognizeData) {
        return new BitwiseParameter(this.toLong());
    }
}

