/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.irp.FloatNumber;
import org.harctoolbox.irp.Floatable;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.IrpObject;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.ParserDriver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class NumberWithDecimals
extends IrpObject
implements Floatable {
    private static final int WEIGHT = 1;
    private static final double EQUALITY_TOLERANCE = 1.0E-6;
    private double data;

    public static double parse(String str) {
        NumberWithDecimals numberWithDecimals = new NumberWithDecimals(str);
        return numberWithDecimals.toFloat();
    }

    public static double parse(IrpParser.Number_with_decimalsContext ctx) {
        NumberWithDecimals numberWithDecimals = new NumberWithDecimals(ctx);
        return numberWithDecimals.toFloat();
    }

    public NumberWithDecimals(String str) {
        this(new ParserDriver(str));
    }

    public NumberWithDecimals(ParserDriver parserDriver) {
        this(parserDriver.getParser().number_with_decimals());
    }

    public NumberWithDecimals(IrpParser.Number_with_decimalsContext ctx) {
        super(ctx);
        ParseTree child = ctx.getChild(0);
        Objects.requireNonNull(child);
        this.data = child instanceof IrpParser.Float_numberContext ? FloatNumber.parse((IrpParser.Float_numberContext)child) : (double)Long.parseLong(child.getText());
    }

    public NumberWithDecimals(double d) {
        super(null);
        this.data = d;
    }

    public NumberWithDecimals(int i) {
        this((double)i);
    }

    public NumberWithDecimals(long n) {
        this((double)n);
    }

    @Override
    public double toFloat(GeneralSpec generalSpec, NameEngine nameEngine) {
        return this.toFloat();
    }

    public double toFloat() {
        return this.data;
    }

    @Override
    public String toIrpString(int radix) {
        return IrCoreUtils.approximatelyEquals(this.data, Double.valueOf((long)this.data), 0.0, 0.01) ? Long.toString((long)this.data) : Double.toString(this.data);
    }

    @Override
    public Element toElement(Document document) {
        Element element = super.toElement(document);
        element.setTextContent(this.toString());
        return element;
    }

    @Override
    public int weight() {
        return 1;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof NumberWithDecimals)) {
            return false;
        }
        NumberWithDecimals other = (NumberWithDecimals)obj;
        return IrCoreUtils.approximatelyEquals(this.data, other.data, 1.0E-6, 0.0);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (int)(Double.doubleToLongBits(this.data) ^ Double.doubleToLongBits(this.data) >>> 32);
        return hash;
    }

    @Override
    public boolean constant(NameEngine nameEngine) {
        return true;
    }
}

