/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.BitwiseParameter;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.ParameterInconsistencyException;
import org.harctoolbox.irp.ParameterSpecs;
import org.harctoolbox.irp.RecognizeData;

public final class ParameterCollector
implements Cloneable {
    private static final Logger logger = Logger.getLogger(ParameterCollector.class.getName());
    public static final long INVALID = -1L;
    public static final ParameterCollector EMPTY = new ParameterCollector(new HashMap<String, Long>(0), null);
    private HashMap<String, BitwiseParameter> map;
    private final Map<String, Long> parameterSpecBitmasks;

    public ParameterCollector(int capacity, Map<String, Long> parameterSpecBitmasks) {
        this.map = new LinkedHashMap<String, BitwiseParameter>(capacity);
        this.parameterSpecBitmasks = parameterSpecBitmasks;
    }

    public ParameterCollector() {
        this(0, new HashMap<String, Long>(4));
    }

    ParameterCollector(Map<String, Long> nameMap, Map<String, Long> parameterSpecBitmasks) {
        this(nameMap.size(), parameterSpecBitmasks);
        nameMap.entrySet().stream().forEach(kvp -> {
            try {
                this.add((String)kvp.getKey(), (Long)kvp.getValue());
            }
            catch (ParameterInconsistencyException parameterInconsistencyException) {
                // empty catch block
            }
        });
    }

    public ParameterCollector(NameEngine nameEngine, Map<String, Long> parameterSpecBitmasks) throws NameUnassignedException {
        this(nameEngine.size(), parameterSpecBitmasks);
        for (Map.Entry<String, Expression> kvp : nameEngine) {
            String name = kvp.getKey();
            Expression expr = kvp.getValue();
            try {
                this.add(name, expr.toLong(nameEngine));
            }
            catch (ParameterInconsistencyException parameterInconsistencyException) {}
        }
    }

    public ParameterCollector(NameEngine nameEngine) throws NameUnassignedException {
        this(nameEngine, new HashMap<String, Long>(0));
    }

    ParameterCollector(ParameterSpecs parameterSpecs) {
        this(new HashMap<String, Long>(4), parameterSpecs.bitmasks());
    }

    /*
     * Enabled aggressive block sorting
     */
    void add(String name, BitwiseParameter parameter) throws ParameterInconsistencyException {
        logger.log(Level.FINER, "Assigning {0} = {1}", new Object[]{name, parameter});
        BitwiseParameter oldParameter = this.map.get(name);
        if (oldParameter == parameter) {
            return;
        }
        if (oldParameter == null) {
            this.overwrite(name, parameter);
            return;
        }
        if (oldParameter.isConsistent(parameter)) {
            oldParameter.aggregate(parameter);
            return;
        }
        logger.log(Level.FINE, "Name inconsistency: {0}, new value: {1}, old value: {2}", new Object[]{name, parameter.toString(), oldParameter.toString()});
        throw new ParameterInconsistencyException(name, parameter, oldParameter);
    }

    void add(String name, long value) throws ParameterInconsistencyException {
        this.add(name, new BitwiseParameter(value));
    }

    void add(String name, long value, long bitmask) throws ParameterInconsistencyException {
        this.add(name, new BitwiseParameter(value, bitmask));
    }

    BitwiseParameter remove(String name) {
        return this.map.remove(name);
    }

    private void overwrite(String name, BitwiseParameter parameter) {
        logger.log(Level.FINER, "Overwriting {0} = {1}", new Object[]{name, parameter});
        this.map.put(name, parameter);
    }

    public Set<String> getNames() {
        return this.map.keySet();
    }

    BitwiseParameter get(String name) {
        return this.map.get(name);
    }

    public long getValue(String name) {
        return this.map.containsKey(name) ? this.map.get(name).getValue() : -1L;
    }

    public NameEngine toNameEngine() {
        NameEngine nameEngine = new NameEngine(this.map.size());
        this.map.entrySet().forEach(kvp -> {
            Long bitmask;
            String name = (String)kvp.getKey();
            BitwiseParameter parameter = (BitwiseParameter)kvp.getValue();
            if (parameter.isFinished(bitmask = this.parameterSpecBitmasks.get(name))) {
                try {
                    nameEngine.define((String)kvp.getKey(), parameter.getValue());
                }
                catch (InvalidNameException ex) {
                    throw new ThisCannotHappenException(ex);
                }
            }
        });
        return nameEngine;
    }

    void fixParameterSpecs(ParameterSpecs parameterSpecs) {
        this.map.entrySet().forEach(kvp -> {
            String name = (String)kvp.getKey();
            BitwiseParameter parameter = (BitwiseParameter)kvp.getValue();
            Long bitmask = this.parameterSpecBitmasks.get(name);
            if (!parameter.isEmpty() && bitmask != null && parameter.isFinished(bitmask)) {
                long val = parameter.getValue();
                long modulus = 1L << parameter.length();
                val = parameterSpecs.fixValue(name, val, modulus);
                parameter.assign(val);
            }
        });
    }

    public Map<String, Long> collectedNames() {
        HashMap<String, Long> names = new HashMap<String, Long>(this.map.size());
        this.collectedNames(names);
        return names;
    }

    public void collectedNames(Map<String, Long> names) {
        this.map.entrySet().forEach(kvp -> {
            BitwiseParameter parameter = (BitwiseParameter)kvp.getValue();
            if (!parameter.isEmpty()) {
                names.put((String)kvp.getKey(), parameter.getValue());
            }
        });
    }

    void transferToNamesMap(Map<String, Long> nameEngine) {
        this.map.entrySet().stream().forEach(kvp -> nameEngine.put((String)kvp.getKey(), ((BitwiseParameter)kvp.getValue()).getValue()));
    }

    public String toString() {
        StringJoiner str = new StringJoiner(";", "{", "}");
        this.map.entrySet().stream().forEach(kvp -> str.add((String)kvp.getKey() + "=" + ((BitwiseParameter)kvp.getValue()).toString()));
        return str.toString();
    }

    public ParameterCollector clone() {
        ParameterCollector result;
        try {
            result = (ParameterCollector)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex);
        }
        result.map = new LinkedHashMap<String, BitwiseParameter>(10);
        this.map.entrySet().stream().forEach(kvp -> result.map.put((String)kvp.getKey(), new BitwiseParameter((BitwiseParameter)kvp.getValue())));
        return result;
    }

    boolean isConsistent(String name, long value) {
        BitwiseParameter param = this.get(name);
        return param.isConsistent(value);
    }

    void checkConsistency(RecognizeData recognizeData) throws NameUnassignedException, ParameterInconsistencyException {
        for (Map.Entry<String, BitwiseParameter> kvp : this.map.entrySet()) {
            Expression expression;
            BitwiseParameter expected;
            String name = kvp.getKey();
            BitwiseParameter param = kvp.getValue();
            if (param.isConsistent(expected = (expression = recognizeData.nameEngine.get(name)).toBitwiseParameter(recognizeData))) continue;
            throw new ParameterInconsistencyException(name, expected, param);
        }
    }

    public boolean contains(String name) {
        return this.map.containsKey(name);
    }

    public Long getBitmask(String name) {
        return this.parameterSpecBitmasks.get(name);
    }

    public boolean isFinished(String name) {
        BitwiseParameter param = this.get(name);
        Long bitmask = this.parameterSpecBitmasks.get(name);
        return param.isFinished(bitmask);
    }
}

