/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.irp.CodeGenerator;
import org.harctoolbox.irp.DomainViolationException;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrpObject;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.ItemCodeGenerator;
import org.harctoolbox.irp.Name;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.Number;
import org.harctoolbox.irp.ParserDriver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ParameterSpec
extends IrpObject {
    private static final int WEIGHT = 1;
    private static Random random;
    private static final List<String> STANDARD_NAMES;
    private Name name;
    private Number min;
    private Number max;
    private Expression deflt;
    private boolean memory = false;

    public static boolean isStandardName(String name) {
        return STANDARD_NAMES.contains(name);
    }

    public static void initRandom(long seed) {
        random = new Random(seed);
    }

    public ParameterSpec(String str) {
        this(new ParserDriver(str).getParser().parameter_spec());
    }

    public ParameterSpec(IrpParser.Parameter_specContext ctx) {
        this(ctx.name(), ctx.getChild(1).getText().equals("@"), ctx.number(0), ctx.number(1), ctx.expression());
    }

    public ParameterSpec(IrpParser.NameContext name, boolean hasMemory, IrpParser.NumberContext min, IrpParser.NumberContext max, IrpParser.ExpressionContext deflt) {
        super(null);
        this.name = new Name(name);
        this.memory = hasMemory;
        this.min = new Number(min);
        this.max = new Number(max);
        this.deflt = deflt != null ? Expression.newExpression(deflt) : null;
    }

    public ParameterSpec(String name, boolean memory, long min, long max, Expression deflt) throws InvalidNameException {
        super(null);
        this.name = new Name(name);
        this.min = new Number(min);
        this.max = new Number(max);
        this.memory = memory;
        this.deflt = deflt;
    }

    public ParameterSpec(String name, boolean memory, long min, long max) throws InvalidNameException {
        this(name, memory, min, max, null);
        this.memory = false;
    }

    public ParameterSpec(String name, boolean memory, int length) throws InvalidNameException {
        this(name, memory, 0L, length == 64 ? -1L : (long)((1 << length) - 1));
    }

    @Override
    public String toIrpString(int radix) {
        return this.name + (this.memory ? "@" : "") + ":" + this.min.toIrpString(radix) + ".." + this.max.toIrpString(radix) + (this.deflt != null ? "=" + this.deflt.toIrpString(radix) : "");
    }

    public void check(NameEngine nameEngine) throws InvalidNameException, DomainViolationException, NameUnassignedException {
        if (!nameEngine.containsKey(this.name.toString())) {
            if (this.hasMemory()) {
                return;
            }
            if (this.deflt != null) {
                nameEngine.define(this.name.toString(), this.deflt);
            } else {
                throw new NameUnassignedException(this.name, true);
            }
        }
        Long value = nameEngine.get(this.name).toLong(nameEngine);
        this.checkDomain(value);
    }

    public void checkDomain(long value) throws DomainViolationException {
        if (!this.isWithinDomain(value)) {
            throw new DomainViolationException(this, value);
        }
    }

    public boolean isWithinDomain(long x) {
        return this.min.toLong() <= x && x <= this.max.toLong();
    }

    @Override
    public Element toElement(Document document) {
        Element el = super.toElement(document);
        el.setAttribute("name", this.name.toString());
        el.setAttribute("min", this.min.toString());
        el.setAttribute("max", this.max.toString());
        el.setAttribute("memory", Boolean.toString(this.memory));
        if (this.deflt != null) {
            Element def = document.createElement("Default");
            el.appendChild(def);
            def.appendChild(this.deflt.toElement(document));
        }
        return el;
    }

    long bitmask() {
        long n = this.max.toLong() - this.min.toLong();
        return (Long.highestOneBit(n) << 1) - 1L;
    }

    public String domainAsString() {
        return this.min + ".." + this.max;
    }

    public String getName() {
        return this.name.toString();
    }

    public Expression getDefault() {
        return this.deflt;
    }

    public boolean hasDefault() {
        return this.deflt != null;
    }

    public long getMin() {
        return this.min.toLong();
    }

    public long getMax() {
        return this.max.toLong();
    }

    public boolean hasMemory() {
        return this.memory;
    }

    public long random() {
        return this.random(random);
    }

    public long random(Random rng) {
        long interval = this.getMax() - this.getMin() + 1L;
        return interval <= Integer.MAX_VALUE && interval > 0L ? this.randomSimple(rng) : this.randomHairy(rng);
    }

    private long randomSimple(Random rng) {
        return (long)rng.nextInt((int)(this.getMax() - this.getMin() + 1L)) + this.getMin();
    }

    private long randomHairy(Random rng) {
        long x = rng.nextLong() & IrCoreUtils.ones(63);
        double frac = (double)x / 9.223372036854776E18;
        return (long)((double)(this.getMax() - this.getMin()) * frac + (double)this.getMin());
    }

    @Override
    public int weight() {
        return 1;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ParameterSpec)) {
            return false;
        }
        ParameterSpec other = (ParameterSpec)obj;
        return this.memory == other.memory && this.min == other.min && this.max == other.max && this.name.equals(other.name) && this.deflt.equals(other.deflt);
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 61 * hash + Objects.hashCode(this.name);
        hash = 61 * hash + Objects.hashCode(this.min);
        hash = 61 * hash + Objects.hashCode(this.max);
        hash = 61 * hash + Objects.hashCode(this.deflt);
        hash = 61 * hash + (this.memory ? 1 : 0);
        return hash;
    }

    String code(CodeGenerator codeGenerator) {
        ItemCodeGenerator template = codeGenerator.newItemCodeGenerator(this);
        template.addAttribute("name", this.name);
        template.addAttribute("min", this.min);
        template.addAttribute("max", this.max);
        template.addAttribute("deflt", this.deflt);
        template.addAttribute("memory", this.memory);
        return template.render();
    }

    long fixValue(long x, long modulus) {
        if (this.isWithinDomain(x)) {
            return x;
        }
        long n = (long)Math.ceil((double)(this.getMin() - x) / (double)modulus);
        return x + n * modulus;
    }

    void tweak(long min, long max) {
        if (min < this.getMin()) {
            this.min = new Number(min);
        }
        if (max > this.getMax()) {
            this.max = new Number(max);
        }
    }

    static {
        STANDARD_NAMES = Arrays.asList("D", "S", "F", "T");
        random = new Random();
    }
}

