/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.AggregateLister;
import org.harctoolbox.irp.CodeGenerator;
import org.harctoolbox.irp.DomainViolationException;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrpObject;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.ItemCodeGenerator;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.ParameterSpec;
import org.harctoolbox.irp.ParserDriver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ParameterSpecs
extends IrpObject
implements Iterable<ParameterSpec>,
AggregateLister,
Comparator<String> {
    private Map<String, ParameterSpec> map = new LinkedHashMap<String, ParameterSpec>(3);

    public ParameterSpecs() {
        super(null);
    }

    public ParameterSpecs(String parameter_specs) {
        this(new ParserDriver(parameter_specs).getParser().parameter_specs());
    }

    public ParameterSpecs(IrpParser.ProtocolContext ctx) {
        this(ctx.parameter_specs());
    }

    public ParameterSpecs(IrpParser.Parameter_specsContext ctx) {
        super(ctx);
        if (ctx == null) {
            return;
        }
        ctx.parameter_spec().stream().map(parameterSpec -> new ParameterSpec((IrpParser.Parameter_specContext)parameterSpec)).forEachOrdered(ps -> this.map.put(ps.getName(), (ParameterSpec)ps));
    }

    public ParameterSpecs(List<ParameterSpec> list) {
        this();
        list.forEach(ps -> this.map.put(ps.getName(), (ParameterSpec)ps));
    }

    @Override
    public int compare(String first, String second) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        for (String parameterName : this.map.keySet()) {
            if (first.equals(parameterName)) {
                return second.equals(parameterName) ? 0 : -1;
            }
            if (!second.equals(parameterName)) continue;
            return 1;
        }
        return first.compareTo(second);
    }

    public Map<String, Long> sort(Map<String, Long> unsortedMap) {
        TreeMap<String, Long> sortedMap = new TreeMap<String, Long>(this);
        sortedMap.putAll(unsortedMap);
        return sortedMap;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ParameterSpecs)) {
            return false;
        }
        ParameterSpecs other = (ParameterSpecs)obj;
        if (this.map.size() != other.map.size()) {
            return false;
        }
        boolean result = true;
        for (Map.Entry<String, ParameterSpec> kvp : this.map.entrySet()) {
            String key = kvp.getKey();
            if (kvp.getValue().equals(other.map.get(key))) continue;
            result = false;
        }
        return result;
    }

    public void replace(ParameterSpecs newParameterSpecs) {
        this.map = newParameterSpecs.map;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.map);
        return hash;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<String> getNames() {
        return this.map.keySet();
    }

    public Collection<ParameterSpec> getParams() {
        return this.map.values();
    }

    public ParameterSpec getParameterSpec(String name) {
        return this.map.get(name);
    }

    public Long bitmask(String name) {
        ParameterSpec parameterSpec = this.map.get(name);
        return parameterSpec != null ? Long.valueOf(parameterSpec.bitmask()) : null;
    }

    public Map<String, Long> bitmasks() {
        HashMap<String, Long> result = new HashMap<String, Long>(this.size());
        this.map.entrySet().forEach(name -> result.put((String)name.getKey(), ((ParameterSpec)name.getValue()).bitmask()));
        return result;
    }

    @Override
    public String toIrpString(int radix) {
        return this.toIrpString(radix, "");
    }

    public String toIrpString(int radix, String separator) {
        if (this.isEmpty()) {
            return separator;
        }
        StringBuilder str = new StringBuilder("[");
        this.map.values().stream().forEach(ps -> str.append(ps.toIrpString(radix)).append(",").append(separator));
        if (str.length() > 0) {
            str.delete(str.length() - 1 - separator.length(), str.length());
        }
        str.append("]");
        return str.toString();
    }

    @Override
    public Element toElement(Document document) {
        Element el = super.toElement(document);
        this.map.values().forEach(parameterSpec -> el.appendChild(parameterSpec.toElement(document)));
        return el;
    }

    void check(NameEngine nameEngine) throws DomainViolationException, InvalidNameException, NameUnassignedException {
        for (ParameterSpec parameter : this.map.values()) {
            parameter.check(nameEngine);
        }
    }

    public Map<String, Long> random() {
        HashMap<String, Long> nameEngine = new HashMap<String, Long>(this.map.size());
        this.map.values().stream().forEach(parameter -> nameEngine.put(parameter.getName(), parameter.random()));
        return nameEngine;
    }

    public Map<String, Long> random(Random rng) {
        HashMap<String, Long> nameEngine = new HashMap<String, Long>(this.map.size());
        this.map.values().stream().forEach(parameter -> nameEngine.put(parameter.getName(), parameter.random(rng)));
        return nameEngine;
    }

    public Map<String, Long> randomUsingDefaults() {
        HashMap<String, Long> nameEngine = new HashMap<String, Long>(this.map.size());
        this.map.values().stream().filter(parameter -> parameter.getDefault() == null).forEach(parameter -> nameEngine.put(parameter.getName(), parameter.random()));
        return nameEngine;
    }

    public Map<String, Long> randomUsingDefaults(Random rng) {
        HashMap<String, Long> nameEngine = new HashMap<String, Long>(this.map.size());
        this.map.values().stream().filter(parameter -> parameter.getDefault() == null).forEach(parameter -> nameEngine.put(parameter.getName(), parameter.random(rng)));
        return nameEngine;
    }

    @Override
    public Iterator<ParameterSpec> iterator() {
        return this.map.values().iterator();
    }

    boolean contains(String name) {
        return this.map.containsKey(name);
    }

    @Override
    public int weight() {
        int weight = 0;
        weight = this.map.values().stream().map(parameterSpec -> parameterSpec.weight()).reduce(weight, Integer::sum);
        return weight;
    }

    public void removeDefaulteds(Map<String, Long> namesMap) {
        NameEngine nameEngine = new NameEngine(namesMap);
        ArrayList<String> names = new ArrayList<String>(namesMap.keySet());
        names.forEach(name -> {
            Expression expression;
            ParameterSpec parameterSpec = this.map.get(name);
            if (parameterSpec != null && (expression = parameterSpec.getDefault()) != null) {
                try {
                    long deflt = expression.toLong(nameEngine);
                    if ((Long)namesMap.get(name) == deflt) {
                        namesMap.remove(name);
                    }
                }
                catch (NameUnassignedException ex) {
                    throw new ThisCannotHappenException();
                }
            }
        });
    }

    public void addDefaulteds(Map<String, Long> params) {
        NameEngine nameEngine = new NameEngine(params);
        this.map.values().stream().filter(parameter -> parameter.hasDefault() && !params.containsKey(parameter.getName())).forEachOrdered(parameter -> {
            try {
                params.put(parameter.getName(), parameter.getDefault().toLong(nameEngine));
            }
            catch (NameUnassignedException nameUnassignedException) {
                // empty catch block
            }
        });
    }

    public void removeNotInParameterSpec(Map<String, Long> namesMap) {
        ArrayList<String> names = new ArrayList<String>(namesMap.keySet());
        names.stream().filter(name -> !this.map.containsKey(name)).forEach(name -> namesMap.remove(name));
    }

    public String code(CodeGenerator codeGenerator) {
        ItemCodeGenerator template = codeGenerator.newItemCodeGenerator(this);
        ArrayList list = new ArrayList(this.map.size());
        this.map.values().stream().forEach(param -> list.add(param.code(codeGenerator)));
        template.addAttribute("arg", list);
        return template.render();
    }

    @Override
    public Map<String, Object> propertiesMap(GeneralSpec generalSpec, NameEngine nameEngine) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("kind", this.getClass().getSimpleName());
        ArrayList list = new ArrayList(this.map.size());
        result.put("list", list);
        this.map.values().stream().forEach(ps -> {
            HashMap<String, Object> m = new HashMap<String, Object>(5);
            list.add(m);
            m.put("name", ps.getName());
            m.put("min", ps.getMin());
            m.put("max", ps.getMax());
            m.put("memory", ps.hasMemory());
            Expression dflt = ps.getDefault();
            if (dflt != null) {
                m.put("default", dflt);
            }
        });
        return result;
    }

    public boolean hasParameter(String name) {
        return this.map.containsKey(name);
    }

    public boolean hasParameterMemory(String parameterName) {
        ParameterSpec parameterSpec = this.getParameterSpec(parameterName);
        return parameterSpec != null && parameterSpec.hasMemory();
    }

    public Expression getParameterDefault(String parameterName) {
        ParameterSpec parameterSpec = this.getParameterSpec(parameterName);
        return parameterSpec == null ? null : parameterSpec.getDefault();
    }

    public boolean hasParameterDefault(String parameterName) {
        ParameterSpec parameterSpec = this.getParameterSpec(parameterName);
        return parameterSpec != null && parameterSpec.hasDefault();
    }

    public long getParameterMax(String parameterName) throws NullPointerException {
        ParameterSpec parameterSpec = this.getParameterSpec(parameterName);
        return parameterSpec.getMax();
    }

    public long getParameterMin(String parameterName) throws NullPointerException {
        ParameterSpec parameterSpec = this.getParameterSpec(parameterName);
        return parameterSpec.getMin();
    }

    public boolean hasNonStandardParameters() {
        return this.map.keySet().stream().anyMatch(name -> !ParameterSpec.isStandardName(name));
    }

    long fixValue(String name, long value, long modulo) {
        ParameterSpec parameterSpec = this.map.get(name);
        if (parameterSpec == null) {
            return value;
        }
        return parameterSpec.fixValue(value, modulo);
    }

    public int size() {
        return this.map.size();
    }

    public void tweak(String name, long min, long max) throws InvalidNameException {
        ParameterSpec oldSpec = this.map.get(name);
        if (oldSpec == null) {
            ParameterSpec newSpec = new ParameterSpec(name, false, min, max);
            this.map.put(name, newSpec);
        } else {
            oldSpec.tweak(min, max);
        }
    }
}

