/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.harctoolbox.irp.ErrorStrategy;
import org.harctoolbox.irp.IrpLexer;
import org.harctoolbox.irp.IrpParser;

public final class ParserDriver {
    private final IrpLexer lexer;
    private final CommonTokenStream tokens;
    private final IrpParser parser;

    public ParserDriver(String irpString) {
        this.lexer = new IrpLexer(CharStreams.fromString(irpString));
        this.lexer.removeErrorListeners();
        this.lexer.addErrorListener(new myErrorListener());
        this.tokens = new CommonTokenStream(this.lexer);
        this.parser = new IrpParser(this.tokens);
        this.parser.removeErrorListeners();
        this.parser.addErrorListener(new myErrorListener());
        this.parser.setErrorHandler(new ErrorStrategy());
    }

    public String toStringTree() {
        IrpParser.ProtocolContext protocol = this.parser.protocol();
        return protocol != null ? protocol.toStringTree(this.parser) : null;
    }

    public IrpParser getParser() {
        return this.parser;
    }

    private static class myErrorListener
    extends BaseErrorListener {
        myErrorListener() {
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            throw new ParseCancellationException("line " + line + ":" + charPositionInLine + " " + msg, e);
        }
    }
}

