/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;

public final class PreferOver
implements Serializable {
    private Expression predicate;
    private String protocolName;

    public static List<PreferOver> parse(Iterable<String> strings) {
        if (strings == null) {
            return new ArrayList<PreferOver>(0);
        }
        ArrayList<PreferOver> result = new ArrayList<PreferOver>(8);
        for (String string : strings) {
            result.add(PreferOver.parse(string));
        }
        return result;
    }

    public static PreferOver parse(String string) {
        String[] arr = string.split(";");
        return arr.length == 1 ? new PreferOver(string) : new PreferOver(arr[1].trim(), arr[0]);
    }

    public PreferOver(String name, Expression predicate) {
        Objects.requireNonNull(predicate, "Predicate must be non-null.");
        this.protocolName = name;
        this.predicate = predicate;
    }

    public PreferOver(String name, String predicateString) {
        this(name, Expression.newExpression(predicateString));
    }

    public PreferOver(String name) {
        this(name, Expression.TRUE);
    }

    public String toBeRemoved(NameEngine nameEngine) {
        try {
            return this.predicate.toLong(nameEngine) == 0L ? null : this.protocolName;
        }
        catch (NameUnassignedException ex) {
            return null;
        }
    }

    public String toBeRemoved(Map<String, Long> map) {
        return this.toBeRemoved(new NameEngine(map));
    }

    public String toBeRemoved() {
        return this.protocolName;
    }

    public String toString() {
        return (this.predicate == Expression.TRUE ? "" : this.predicate.toString()) + this.protocolName;
    }
}

