/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.v4.gui.TreeViewer;
import org.harctoolbox.analyze.AbstractDecoder;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.IrSequence;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.ModulatedIrSequence;
import org.harctoolbox.ircore.OddSequenceLengthException;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.AggregateLister;
import org.harctoolbox.irp.BareIrStream;
import org.harctoolbox.irp.BitDirection;
import org.harctoolbox.irp.BitSpec;
import org.harctoolbox.irp.BitspecIrstream;
import org.harctoolbox.irp.Decoder;
import org.harctoolbox.irp.DomainViolationException;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrStream;
import org.harctoolbox.irp.IrStreamItem;
import org.harctoolbox.irp.IrpException;
import org.harctoolbox.irp.IrpInvalidArgumentException;
import org.harctoolbox.irp.IrpObject;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.ParameterCollector;
import org.harctoolbox.irp.ParameterSpec;
import org.harctoolbox.irp.ParameterSpecs;
import org.harctoolbox.irp.ParserDriver;
import org.harctoolbox.irp.RecognizeData;
import org.harctoolbox.irp.RenderData;
import org.harctoolbox.irp.RepeatMarker;
import org.harctoolbox.irp.SignalRecognitionException;
import org.harctoolbox.irp.UnsupportedRepeatException;
import org.harctoolbox.irp.Variation;
import org.harctoolbox.xml.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Protocol
extends IrpObject
implements AggregateLister {
    private static final Logger logger = Logger.getLogger(Protocol.class.getName());
    private static final int SILLYNESSPENALTY = 3;
    private static final double LOWER_COMMON_FREQUENCY1 = 36000.0;
    private static final double UPPER_COMMON_FREQUENCY1 = 40000.0;
    private static final double LOWER_COMMON_FREQUENCY2 = 56000.0;
    private static final double UPPER_COMMON_FREQUENCY2 = 58000.0;
    private final GeneralSpec generalSpec;
    private final ParameterSpecs parameterSpecs;
    private final BitspecIrstream bitspecIrstream;
    private Variation normalFormVariation;
    private final NameEngine initialDefinitions;
    private NameEngine definitions;
    private final NameEngine memoryVariables;
    private Boolean interleavingFlash = null;
    private Boolean interleavingGap = null;
    private transient ParserDriver parserDriver = null;
    private final Class<? extends AbstractDecoder> decoderClass;
    private String irp;

    private static String warn(String message) {
        return "Warning: " + message + "." + IrCoreUtils.LINE_SEPARATOR;
    }

    private static boolean commonFrequency(double f) {
        return IrCoreUtils.approximatelyEquals(f, 0.0) || f >= 36000.0 && f <= 40000.0 || f >= 56000.0 && f <= 58000.0;
    }

    public Protocol(GeneralSpec generalSpec, BitspecIrstream bitspecIrstream, NameEngine definitions, ParameterSpecs parameterSpecs) {
        this(generalSpec, bitspecIrstream, definitions, parameterSpecs, null);
    }

    public Protocol(GeneralSpec generalSpec, BitspecIrstream bitspecIrstream, NameEngine definitions, ParameterSpecs parameterSpecs, IrpParser.ProtocolContext parseTree) {
        this(generalSpec, bitspecIrstream, definitions, parameterSpecs, parseTree, null);
    }

    public Protocol(GeneralSpec generalSpec, BitspecIrstream bitspecIrstream, NameEngine definitions, ParameterSpecs parameterSpecs, IrpParser.ProtocolContext parseTree, Class<? extends AbstractDecoder> decoderClass) {
        super(parseTree);
        this.generalSpec = generalSpec;
        this.bitspecIrstream = bitspecIrstream;
        this.initialDefinitions = definitions;
        this.decoderClass = decoderClass;
        this.memoryVariables = new NameEngine();
        this.initializeDefinitions();
        this.parameterSpecs = parameterSpecs != null ? parameterSpecs : new ParameterSpecs();
        this.computeNormalForm();
        this.irp = this.computeIrp(10);
    }

    public Protocol() {
        this(new GeneralSpec(), new BitspecIrstream(), new NameEngine(), new ParameterSpecs());
    }

    public Protocol(String irpString) throws UnsupportedRepeatException, NameUnassignedException, InvalidNameException, IrpInvalidArgumentException {
        this(new ParserDriver(irpString));
        this.irp = irpString;
    }

    private Protocol(ParserDriver parserDriver) throws UnsupportedRepeatException, NameUnassignedException, InvalidNameException, IrpInvalidArgumentException {
        this(parserDriver.getParser().protocol());
        this.parserDriver = parserDriver;
    }

    public Protocol(IrpParser.ProtocolContext parseTree) throws UnsupportedRepeatException, NameUnassignedException, InvalidNameException, IrpInvalidArgumentException {
        this(new GeneralSpec(parseTree), new BitspecIrstream(parseTree), new NameEngine(), new ParameterSpecs(parseTree), parseTree);
        parseTree.definitions().forEach(defs -> this.initialDefinitions.parseDefinitions((IrpParser.DefinitionsContext)defs));
        this.initializeDefinitions();
        for (ParameterSpec parameter : this.parameterSpecs) {
            if (!parameter.hasMemory()) continue;
            String name = parameter.getName();
            long initVal = parameter.getDefault().toLong();
            this.memoryVariables.define(name, initVal);
        }
        this.checkSanity();
    }

    private String computeIrp(int radix) {
        return this.generalSpec.toIrpString(radix) + this.bitspecIrstream.toIrpString(radix) + this.initialDefinitions.toIrpString(radix) + this.parameterSpecs.toIrpString(radix);
    }

    public String getDecoderName() {
        return this.decoderClass != null ? this.decoderClass.getSimpleName() : "";
    }

    private void initializeDefinitions() {
        this.definitions = new NameEngine(this.initialDefinitions);
    }

    public String toStringTree() {
        return this.toStringTree(this.parserDriver);
    }

    public TreeViewer toTreeViewer() {
        return this.toTreeViewer(this.parserDriver);
    }

    private void computeNormalForm() {
        BareIrStream intro = this.bitspecIrstream.extractPass(IrSignal.Pass.intro);
        BareIrStream repeat = this.bitspecIrstream.extractPass(IrSignal.Pass.repeat);
        BareIrStream ending = this.bitspecIrstream.extractPass(IrSignal.Pass.ending);
        this.normalFormVariation = new Variation(intro, repeat, ending);
    }

    public boolean constantSequence(IrSignal.Pass pass) {
        BareIrStream sequence = this.bitspecIrstream.extractPass(pass);
        BitspecIrstream bitspecIrStream = new BitspecIrstream(this.bitspecIrstream.getBitSpec(), new IrStream(sequence));
        return bitspecIrStream.constant(this.definitions);
    }

    public boolean nonEmptySequence(IrSignal.Pass pass) {
        BareIrStream sequence = this.bitspecIrstream.extractPass(pass);
        return !sequence.isEmpty(this.definitions);
    }

    public boolean constantNonEmptySequence(IrSignal.Pass pass) {
        BareIrStream sequence = this.bitspecIrstream.extractPass(pass);
        if (sequence.isEmpty(this.definitions)) {
            return false;
        }
        BitspecIrstream bitspecIrStream = new BitspecIrstream(this.bitspecIrstream.getBitSpec(), new IrStream(sequence));
        return bitspecIrStream.constant(this.definitions);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Protocol)) {
            return false;
        }
        Protocol other = (Protocol)obj;
        return this.generalSpec.equals(other.generalSpec) && this.bitspecIrstream.equals(other.bitspecIrstream) && this.parameterSpecs.equals(other.parameterSpecs) && this.initialDefinitions.equals(other.initialDefinitions);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hashCode(this.generalSpec);
        hash = 31 * hash + Objects.hashCode(this.parameterSpecs);
        hash = 31 * hash + Objects.hashCode(this.bitspecIrstream);
        hash = 31 * hash + Objects.hashCode(this.initialDefinitions);
        return hash;
    }

    public Protocol substituteConstantVariables() {
        Map<String, Long> constantVariables = this.definitions.getNumericLiterals();
        NameEngine newDefs = this.definitions.remove(constantVariables.keySet());
        IrStreamItem newBitspecIrstream = this.bitspecIrstream.substituteConstantVariables((Map)constantVariables);
        return new Protocol(this.generalSpec, (BitspecIrstream)newBitspecIrstream, newDefs, this.parameterSpecs);
    }

    private void checkSanity() throws UnsupportedRepeatException {
        if (this.numberOfInfiniteRepeats() > 1) {
            throw new UnsupportedRepeatException();
        }
        if (this.hasVariation(null) && this.numberOfInfiniteRepeats() == 0) {
            throw new UnsupportedRepeatException("Variations are not allowed in IrStream without infinite repeat");
        }
        if (this.hasVariation(IrSignal.Pass.intro) && this.bitspecIrstream.getIrStream().getRepeatMarker().getMin() == 0) {
            throw new UnsupportedRepeatException("Cannot have a variations with non-empty intro in an IrStream with repeat \"*\"; please change to \"+\".");
        }
        Integer numberBits = this.numberOfBits();
        if (this.parameterSpecs.isEmpty() && numberBits != null && numberBits > 0) {
            logger.log(Level.WARNING, "Parameter specs are missing from protocol. Runtime errors due to unassigned variables are possile. Also silent truncation of parameters can occur. Further messages on parameters will be suppressed.");
        }
        if (this.generalSpec == null) {
            throw new ThisCannotHappenException("GeneralSpec missing from protocol");
        }
    }

    public Protocol normalFormProtocol() {
        ArrayList<IrStreamItem> list = new ArrayList<IrStreamItem>(1);
        list.add(this.normalFormVariation);
        return this.mkProtocolFromNormalFormVariation(new BareIrStream(list));
    }

    public Protocol normalForm(IrSignal.Pass pass) {
        return this.mkProtocolFromNormalFormVariation(this.normalFormVariation.select(pass));
    }

    public BareIrStream normalBareIrStream(IrSignal.Pass pass) {
        return this.normalFormVariation.select(pass);
    }

    public boolean isEmpty(IrSignal.Pass pass) {
        return this.normalFormVariation.select(pass).isEmpty();
    }

    private Protocol mkProtocolFromNormalFormVariation(BareIrStream bareIrStream) {
        IrStream irStream = new IrStream(bareIrStream, RepeatMarker.newRepeatMarker('+'));
        BitspecIrstream normalBitspecIrstream = new BitspecIrstream(this.bitspecIrstream.getBitSpec(), irStream);
        return new Protocol(this.generalSpec, normalBitspecIrstream, this.definitions, this.parameterSpecs, null);
    }

    public String normalFormIrpString(int radix) {
        Protocol normal = this.normalFormProtocol();
        return normal.toIrpString(radix);
    }

    public IrSignal toIrSignal(NameEngine nameEngine) throws DomainViolationException, NameUnassignedException, IrpInvalidArgumentException, InvalidNameException, OddSequenceLengthException {
        this.initializeDefinitions();
        nameEngine.add(this.definitions);
        this.parameterSpecs.check(nameEngine);
        this.fetchMemoryVariables(nameEngine);
        IrSequence intro = this.toIrSequence(nameEngine, IrSignal.Pass.intro);
        IrSequence repeat = this.toIrSequence(nameEngine, IrSignal.Pass.repeat);
        IrSequence ending = this.toIrSequence(nameEngine, IrSignal.Pass.ending);
        this.saveMemoryVariables(nameEngine);
        return new IrSignal(intro, repeat, ending, (Double)this.getFrequencyWithDefault(), this.getDutyCycle());
    }

    public IrSignal toIrSignal(Map<String, Long> params) throws DomainViolationException, NameUnassignedException, IrpInvalidArgumentException, InvalidNameException, OddSequenceLengthException {
        NameEngine nameEngine = new NameEngine(params);
        return this.toIrSignal(nameEngine);
    }

    private void fetchMemoryVariables(NameEngine nameEngine) {
        for (Map.Entry<String, Expression> kvp : this.memoryVariables) {
            String name = kvp.getKey();
            if (nameEngine.containsKey(name)) continue;
            try {
                nameEngine.define(name, kvp.getValue());
            }
            catch (InvalidNameException ex) {
                throw new ThisCannotHappenException(ex);
            }
        }
    }

    private void saveMemoryVariables(NameEngine nameEngine) {
        for (Map.Entry<String, Expression> kvp : this.memoryVariables) {
            String name = kvp.getKey();
            try {
                this.memoryVariables.define(name, nameEngine.get(name));
            }
            catch (InvalidNameException | NameUnassignedException ex) {
                throw new ThisCannotHappenException(ex);
            }
        }
    }

    public ModulatedIrSequence toModulatedIrSequence(NameEngine nameEngine, IrSignal.Pass pass) throws NameUnassignedException, IrpInvalidArgumentException, OddSequenceLengthException {
        return new ModulatedIrSequence(this.toIrSequence(nameEngine, pass), this.getFrequency(), this.getDutyCycle());
    }

    private IrSequence toIrSequence(NameEngine nameEngine, IrSignal.Pass pass) throws NameUnassignedException, IrpInvalidArgumentException, OddSequenceLengthException {
        RenderData renderData = new RenderData(this.generalSpec, nameEngine);
        BitspecIrstream stream = this.extractBitspecIrstream(pass);
        stream.render(renderData, new ArrayList<BitSpec>(0));
        IrSequence irSequence = renderData.toIrSequence();
        logger.log(Level.FINE, "{0} {1}", new Object[]{pass, irSequence});
        return irSequence;
    }

    private BitspecIrstream extractBitspecIrstream(IrSignal.Pass pass) {
        BitSpec bitSpec = this.bitspecIrstream.getBitSpec();
        BareIrStream irStream = this.normalFormVariation.select(pass);
        return new BitspecIrstream(bitSpec, new IrStream(irStream));
    }

    @Override
    public int numberOfInfiniteRepeats() {
        return this.bitspecIrstream.numberOfInfiniteRepeats();
    }

    public String getIrp() {
        return this.irp;
    }

    public BitDirection getBitDirection() {
        return this.generalSpec.getBitDirection();
    }

    public Double getFrequency() {
        return this.generalSpec.getFrequency();
    }

    protected double getFrequencyWithDefault() {
        return this.generalSpec.getFrequencyWitDefault();
    }

    public double getUnit() {
        return this.generalSpec.getUnit();
    }

    public Double getDutyCycle() {
        return this.generalSpec.getDutyCycle();
    }

    long getMemoryVariable(String name) throws NameUnassignedException {
        return this.memoryVariables.get(name).toLong();
    }

    boolean hasMemoryVariable(String name) {
        return this.memoryVariables.containsKey(name);
    }

    public boolean isPWM2() {
        return this.bitspecIrstream.isPWM2();
    }

    public boolean isPWM4() {
        return this.bitspecIrstream.isPWM4();
    }

    boolean isPWM16() {
        return this.bitspecIrstream.isPWM16();
    }

    public boolean isBiphase() {
        return this.bitspecIrstream.isBiphase(this.generalSpec, this.initialDefinitions);
    }

    public boolean isTrivial(boolean inverted) {
        return this.bitspecIrstream.isTrivial(this.generalSpec, this.initialDefinitions, inverted);
    }

    public boolean isTrivial() {
        return this.isTrivial(true) || this.isTrivial(false);
    }

    public boolean interleavingOk() {
        return this.interleavingFlashOk() && this.interleavingGapOk();
    }

    public boolean interleavingFlashOk() {
        if (this.interleavingFlash == null) {
            this.interleavingFlash = this.bitspecIrstream.interleavingFlashOk();
        }
        return this.interleavingFlash;
    }

    public boolean interleavingGapOk() {
        if (this.interleavingGap == null) {
            this.interleavingGap = this.bitspecIrstream.interleavingGapOk();
        }
        return this.interleavingGap;
    }

    public boolean isSonyType() {
        return this.bitspecIrstream.isSonyType(this.generalSpec, new NameEngine(this.initialDefinitions));
    }

    public boolean isRPlus() {
        return this.bitspecIrstream.isRPlus();
    }

    public boolean startsWithFlash() {
        return this.bitspecIrstream.startsWithFlash();
    }

    public boolean hasVariation(IrSignal.Pass pass) {
        return this.bitspecIrstream.hasVariation(pass);
    }

    public boolean hasExtent() {
        return this.bitspecIrstream.hasExtent();
    }

    public BitspecIrstream getBitspecIrstream() {
        return this.bitspecIrstream;
    }

    @Override
    public Element toElement(Document document) {
        Element root = super.toElement(document);
        Element renderer = document.createElement(Protocol.class.getSimpleName());
        root.appendChild(renderer);
        XmlUtils.addBooleanAttributeIfTrue(renderer, "toggle", this.hasMemoryVariable("T"));
        XmlUtils.addBooleanAttributeIfTrue(renderer, "pwm2", this.isPWM2());
        XmlUtils.addBooleanAttributeIfTrue(renderer, "pwm4", this.isPWM4());
        XmlUtils.addBooleanAttributeIfTrue(renderer, "pwm16", this.isPWM16());
        XmlUtils.addBooleanAttributeIfTrue(renderer, "biphase", this.isBiphase());
        XmlUtils.addBooleanAttributeIfTrue(renderer, "trivial", this.isTrivial(false));
        XmlUtils.addBooleanAttributeIfTrue(renderer, "invTrivial", this.isTrivial(true));
        XmlUtils.addBooleanAttributeIfTrue(renderer, "interleavingOk", this.interleavingOk());
        XmlUtils.addBooleanAttributeIfTrue(renderer, "interleavingFlashOk", this.interleavingFlashOk());
        XmlUtils.addBooleanAttributeIfTrue(renderer, "interleavingGapOk", this.interleavingGapOk());
        XmlUtils.addBooleanAttributeIfTrue(renderer, "sonyType", this.isSonyType());
        XmlUtils.addBooleanAttributeIfTrue(renderer, "startsWithFlash", this.startsWithFlash());
        XmlUtils.addBooleanAttributeIfTrue(renderer, "hasVariation", this.hasVariation(null));
        XmlUtils.addBooleanAttributeIfTrue(renderer, "rplus", this.isRPlus());
        XmlUtils.addDoubleAttributeAsInteger(renderer, "minDiff", this.minDurationDiff());
        Element generalSpecElement = this.generalSpec.toElement(document);
        renderer.appendChild(generalSpecElement);
        Element bitspecIrstreamElement = this.bitspecIrstream.toElement(document);
        bitspecIrstreamElement.appendChild(this.normalFormElement(document));
        renderer.appendChild(bitspecIrstreamElement);
        Element definitionsElement = this.definitions.toElement(document);
        renderer.appendChild(definitionsElement);
        renderer.appendChild(this.parameterSpecs.toElement(document));
        return root;
    }

    public Element normalFormElement(Document document) {
        Element element = document.createElement("NormalForm");
        element.appendChild(this.mkElement(document, IrSignal.Pass.intro));
        element.appendChild(this.mkElement(document, IrSignal.Pass.repeat));
        element.appendChild(this.mkElement(document, IrSignal.Pass.ending));
        return element;
    }

    private Element mkElement(Document document, IrSignal.Pass pass) {
        BareIrStream stream = this.normalBareIrStream(pass);
        String tagName = IrCoreUtils.capitalize(pass.toString());
        Element element = stream.toElement(document, tagName);
        int bitspecLength = this.bitspecIrstream.getBitSpec().numberOfDurations();
        Integer noDurations = stream.numberOfDurations(bitspecLength);
        if (noDurations != null) {
            element.setAttribute("numberOfDurations", Integer.toString(noDurations));
        }
        return element;
    }

    @Override
    public String toIrpString(int radix) {
        return this.toIrpString(radix, false);
    }

    public String toIrpString(int radix, boolean usePeriods) {
        return this.toIrpString(radix, usePeriods, "");
    }

    public String toIrpString(int radix, boolean usePeriods, String separator) {
        return this.generalSpec.toIrpString(usePeriods) + separator + this.bitspecIrstream.toIrpString(radix, separator) + separator + this.definitions.toIrpString(radix, separator) + separator + this.parameterSpecs.toIrpString(radix, separator);
    }

    public String toIrpString(int radix, boolean usePeriods, boolean tsvOptimized) {
        return this.toIrpString(radix, usePeriods, tsvOptimized ? "\t" : "");
    }

    public Map<String, Long> randomParameters() {
        return this.parameterSpecs.random();
    }

    public Map<String, Long> randomParameters(Random random) {
        return this.parameterSpecs.random(random);
    }

    public Map<String, Long> recognize(IrSignal irSignal) throws SignalRecognitionException, ProtocolNotDecodableException {
        return this.recognize(irSignal, true);
    }

    public Map<String, Long> recognize(IrSignal irSignal, boolean strict) throws SignalRecognitionException, ProtocolNotDecodableException {
        Decoder.DecoderParameters params = new Decoder.DecoderParameters(strict);
        return this.recognize(irSignal, params);
    }

    public Map<String, Long> recognize(IrSignal irSignal, boolean strict, double frequencyTolerance, double absoluteTolerance, double relativeTolerance, double minimumLeadout) throws SignalRecognitionException, ProtocolNotDecodableException {
        Decoder.DecoderParameters params = new Decoder.DecoderParameters(strict, frequencyTolerance, absoluteTolerance, relativeTolerance, minimumLeadout);
        return this.recognize(irSignal, params);
    }

    public Map<String, Long> recognize(IrSignal irSignal, Decoder.DecoderParameters parameters) throws SignalRecognitionException, ProtocolNotDecodableException {
        this.checkFrequency(irSignal.getFrequencyWithDefault(), parameters);
        this.initializeDefinitions();
        ParameterCollector parameterCollector = new ParameterCollector(this.definitions.size() + this.parameterSpecs.size(), this.parameterSpecs.bitmasks());
        boolean matched = this.recognizeIntro(irSignal, parameters, parameterCollector);
        if (!matched) {
            this.recognizeIntroAsRepeat(irSignal, parameters, parameterCollector);
        } else {
            this.recognizeRepeat(irSignal, parameters, parameterCollector);
        }
        this.recognizeEnding(irSignal, parameters, parameterCollector);
        Map<String, Long> params = parameterCollector.collectedNames();
        this.parameterSpecs.removeNotInParameterSpec(params);
        return params;
    }

    private boolean recognizeIntro(IrSignal irSignal, Decoder.DecoderParameters parameters, ParameterCollector parameterCollector) throws SignalRecognitionException {
        boolean matchFailed;
        int pos = this.decode(parameterCollector, irSignal.getIntroSequence(), IrSignal.Pass.intro, parameters);
        boolean bl = matchFailed = pos == 0 && irSignal.getIntroLength() > 0;
        if (matchFailed && parameters.isStrict()) {
            throw new SignalRecognitionException("Intro sequence was not matched");
        }
        return !matchFailed;
    }

    private void recognizeIntroAsRepeat(IrSignal irSignal, Decoder.DecoderParameters parameters, ParameterCollector parameterCollector) throws SignalRecognitionException {
        int pos = this.decode(parameterCollector, irSignal.getIntroSequence(), IrSignal.Pass.repeat, parameters);
        if (pos < irSignal.getIntroLength()) {
            throw new SignalRecognitionException("Intro sequence was not matched, also not as repeat");
        }
    }

    private void recognizeRepeat(IrSignal irSignal, Decoder.DecoderParameters parameters, ParameterCollector parameterCollector) throws SignalRecognitionException {
        int pos = this.decode(parameterCollector, irSignal.getRepeatSequence(), IrSignal.Pass.repeat, parameters);
        if (pos < irSignal.getRepeatLength()) {
            throw new SignalRecognitionException("Repeat sequence was not fully matched");
        }
    }

    private void recognizeEnding(IrSignal irSignal, Decoder.DecoderParameters parameters, ParameterCollector parameterCollector) throws SignalRecognitionException {
        block3: {
            try {
                int pos = this.decode(parameterCollector, irSignal.getEndingSequence(), IrSignal.Pass.ending, parameters);
                if (pos < irSignal.getEndingLength()) {
                    throw new SignalRecognitionException("Ending sequence was not fully matched");
                }
            }
            catch (SignalRecognitionException ex) {
                if (!parameters.isStrict()) break block3;
                throw ex;
            }
        }
    }

    public Decoder.Decode recognize(ModulatedIrSequence irSequence, boolean rejectNoRepeats, boolean strict) throws SignalRecognitionException {
        return this.recognize(irSequence, 0, rejectNoRepeats, new Decoder.DecoderParameters(strict));
    }

    public Decoder.Decode recognize(ModulatedIrSequence irSequence, int beginPos, boolean rejectNoRepeats, Decoder.DecoderParameters params) throws SignalRecognitionException {
        this.checkFrequency(irSequence.getFrequencyWithDefault(), params);
        this.initializeDefinitions();
        ParameterCollector names = new ParameterCollector();
        int pos = this.decode(names, irSequence, beginPos, IrSignal.Pass.intro, params);
        int noRepeatsMatched = 0;
        while (true) {
            int oldPos = pos;
            try {
                pos = this.decode(names, irSequence, oldPos, IrSignal.Pass.repeat, params);
                if (pos == oldPos) break;
                ++noRepeatsMatched;
            }
            catch (SignalRecognitionException ex) {
                logger.log(Level.FINE, "Protocol did not parse: {0}", ex.getMessage());
                break;
            }
        }
        if (rejectNoRepeats) {
            if (noRepeatsMatched == 0) {
                throw new SignalRecognitionException("No repeat sequence matched; this was required through rejectNoRepeats");
            }
            if (noRepeatsMatched == 1 && this.isEmpty(IrSignal.Pass.intro)) {
                throw new SignalRecognitionException("Intro empty, rejectNoRepeats and only one repeat sequence matched; rejected");
            }
        }
        if (pos == beginPos) {
            throw new SignalRecognitionException("Neither intro- nor repeat sequence was matched");
        }
        try {
            pos = this.decode(names, irSequence, pos, IrSignal.Pass.ending, params);
            if (params.isStrict() && pos < irSequence.getLength() - 1) {
                throw new SignalRecognitionException("Sequence was not fully matched");
            }
        }
        catch (SignalRecognitionException ex) {
            if (params.isStrict()) {
                throw ex;
            }
            logger.log(Level.WARNING, "Ending sequence not matched.");
        }
        Map<String, Long> parameters = names.collectedNames();
        this.parameterSpecs.removeNotInParameterSpec(parameters);
        return new Decoder.Decode(null, parameters, beginPos, pos - 1, noRepeatsMatched);
    }

    protected void checkFrequency(Double frequency, Decoder.DecoderParameters params) throws SignalRecognitionException {
        logger.log(Level.FINER, "Expected frequency {0}, actual {1}, tolerance {2}", new Object[]{(int)this.getFrequencyWithDefault(), frequency.intValue(), params.getFrequencyTolerance().intValue()});
        boolean success = params.getFrequencyTolerance() < 0.0 || IrCoreUtils.approximatelyEquals(this.getFrequencyWithDefault(), frequency, params.getFrequencyTolerance(), 0.0);
        logger.log(Level.FINER, "Frequency was checked, {0}OK.", success ? "" : "NOT ");
        if (!success) {
            throw new SignalRecognitionException("Frequency does not match");
        }
    }

    private int decode(ParameterCollector names, IrSequence irSequence, IrSignal.Pass pass, Decoder.DecoderParameters params) throws SignalRecognitionException {
        return this.decode(names, irSequence, 0, pass, params);
    }

    private int decode(ParameterCollector names, IrSequence irSequence, int beginPos, IrSignal.Pass pass, Decoder.DecoderParameters params) throws SignalRecognitionException {
        RecognizeData recognizeData = new RecognizeData(this.generalSpec, this.definitions, this.parameterSpecs, irSequence, beginPos, this.interleavingOk(), names, params, pass);
        Protocol reducedProtocol = this.normalForm(pass);
        reducedProtocol.decode(recognizeData);
        try {
            names.fixParameterSpecs(this.parameterSpecs);
            recognizeData.checkConsistency();
            this.checkDomain(names);
        }
        catch (DomainViolationException | NameUnassignedException ex) {
            throw new SignalRecognitionException(ex);
        }
        return recognizeData.getPosition();
    }

    private void decode(RecognizeData recognizeData) throws SignalRecognitionException {
        this.bitspecIrstream.decode(recognizeData, new ArrayList<BitSpec>(0), true);
        recognizeData.finish();
    }

    @Override
    public int weight() {
        int w = this.generalSpec.weight() + this.bitspecIrstream.weight() + this.initialDefinitions.weight() + this.parameterSpecs.weight();
        int penalty = this.isTrivial() ? 3 : 1;
        return penalty * w;
    }

    public GeneralSpec getGeneralSpec() {
        return this.generalSpec;
    }

    public ParameterSpecs getParameterSpecs() {
        return this.parameterSpecs;
    }

    public Map<String, Long> sort(Map<String, Long> map) {
        return this.parameterSpecs.sort(map);
    }

    public NameEngine getDefinitions() {
        return this.definitions;
    }

    public String classificationString() {
        StringBuilder str = new StringBuilder(128);
        str.append((int)this.minDurationDiff());
        str.append("\t").append((int)(this.getFrequency() != null ? this.getFrequency() : 38000.0));
        str.append("\t").append(this.hasMemoryVariable("T") ? "toggle\t" : "\t");
        str.append(this.isPWM2() ? "PWM2" : "");
        str.append(this.isPWM4() ? "PWM4" : "");
        str.append(this.isPWM16() ? "PWM16" : "");
        str.append(this.isBiphase() ? "Biphase" : "");
        str.append(this.isTrivial(false) ? "Trivial" : "");
        str.append(this.isTrivial(true) ? "invTrivial" : "");
        str.append("\t").append(this.interleavingOk() ? "interleaving\t" : "\t");
        str.append("\t").append(this.interleavingFlashOk() ? "flashint\t" : "\t");
        str.append("\t").append(this.interleavingGapOk() ? "gapint\t" : "\t");
        str.append("\t").append(this.isSonyType() ? "sony\t" : "\t");
        str.append(this.startsWithFlash() ? "SWD\t" : "\t");
        str.append(this.hasVariation(null) ? "variation\t" : "\t");
        str.append(this.nonEmptySequence(IrSignal.Pass.intro) ? "I" : "");
        str.append(this.nonEmptySequence(IrSignal.Pass.repeat) ? (this.isRPlus() ? "R+" : "R*") : "");
        str.append(this.nonEmptySequence(IrSignal.Pass.ending) ? "E\t" : "\t");
        str.append(this.constantNonEmptySequence(IrSignal.Pass.intro) ? "constIntro" : "");
        str.append(this.constantNonEmptySequence(IrSignal.Pass.repeat) ? "constRepeat" : "");
        return str.toString();
    }

    public String warningsString() {
        return this.warningFrequency() + this.warningStartsWithFlash() + this.warningTrivialBitspec() + this.warningRepeatPlus() + this.warningsInterleaving() + this.warningNonConstantLengthBitFields() + this.warningNoParameterSpecs();
    }

    public String warningFrequency() {
        Double frequency = this.getFrequency();
        return frequency == null ? Protocol.warn("Frequency is missing, using default frequency = 38000.0") : (!Protocol.commonFrequency(frequency) ? Protocol.warn("Uncommon frequency = " + frequency.longValue()) : "");
    }

    public String warningStartsWithFlash() {
        return !this.startsWithFlash() ? Protocol.warn("Protocol does not start with a Duration/Flash") : "";
    }

    public String warningTrivialBitspec() {
        return this.isTrivial() ? Protocol.warn("Protocol uses trivial bitspec") : "";
    }

    public String warningRepeatPlus() {
        return this.isRPlus() ? Protocol.warn("Protocol uses infinite repeat with min > 0") : "";
    }

    public String warningsInterleaving() {
        return this.interleavingOk() ? "" : (this.isBiphase() ? Protocol.warn("Protocol not interleaving; is biphase") : (this.isSonyType() ? Protocol.warn("Protocol not interleaving, but is Sony-like") : Protocol.warn("Protocol not interleaving")));
    }

    public String warningNonConstantLengthBitFields() {
        return this.nonConstantBitFieldLength() ? Protocol.warn("Protocol contains bitfields with non-constant lengths") : "";
    }

    public String warningNoParameterSpecs() {
        return this.getParameterSpecs().isEmpty() ? Protocol.warn("ParameterSpecs missing from the protocol") : "";
    }

    private void checkDomain(ParameterCollector names) throws DomainViolationException {
        for (String kvp : names.getNames()) {
            ParameterSpec parameterSpec = this.parameterSpecs.getParameterSpec(kvp);
            if (parameterSpec == null) continue;
            parameterSpec.checkDomain(names.getValue(kvp));
        }
    }

    @Override
    public Map<String, Object> propertiesMap(GeneralSpec generalSpec, NameEngine nameEngine) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        this.addProperties(map, "generalSpec", this.getGeneralSpec());
        this.addProperties(map, "parameterSpecs", this.getParameterSpecs());
        Set<String> variables = this.getBitspecIrstream().assignmentVariables();
        Set<String> params = this.getParameterSpecs().getNames();
        variables.removeAll(params);
        map.put("assignmentVariables", variables);
        this.addProperties(map, "definitions", this.getDefinitions());
        this.addProperties(map, "bitSpec", this.getBitspecIrstream().getBitSpec());
        map.put("sonyType", this.isSonyType());
        map.put("interleavingOk", this.interleavingOk());
        map.put("interleavingFlashOk", this.interleavingFlashOk());
        map.put("interleavingGapOk", this.interleavingGapOk());
        map.put("minDiff", this.minDurationDiff());
        this.addSequence(map, IrSignal.Pass.intro);
        this.addSequence(map, IrSignal.Pass.repeat);
        this.addSequence(map, IrSignal.Pass.ending);
        return map;
    }

    private void addSequence(Map<String, Object> map, IrSignal.Pass pass) {
        BareIrStream bareIrSequence = this.normalBareIrStream(pass);
        Map<String, Object> propMap = bareIrSequence.topLevelPropertiesMap(this.generalSpec, this.definitions, this.bitspecIrstream.getBitSpec().numberOfDurations());
        map.put(pass.toString(), propMap);
    }

    private void addProperties(Map<String, Object> map, String name, AggregateLister listener) {
        Map<String, Object> props = listener.propertiesMap(this.generalSpec, this.definitions);
        map.put(name, props);
    }

    @Override
    public Integer numberOfBits() {
        return this.bitspecIrstream.numberOfBits();
    }

    public boolean nonConstantBitFieldLength() {
        return this.bitspecIrstream.nonConstantBitFieldLength();
    }

    public Integer guessParameterLength(String name) {
        return this.bitspecIrstream.guessParameterLength(name);
    }

    public TreeSet<Double> allDurationsInMicros() {
        return this.bitspecIrstream.allDurationsInMicros(this.generalSpec, this.definitions);
    }

    public double minDurationDiff() {
        return IrCoreUtils.minDiff(this.allDurationsInMicros());
    }

    public boolean hasParameter(String name) {
        return this.parameterSpecs.hasParameter(name);
    }

    public boolean hasParameterDefault(String name) {
        return this.parameterSpecs.hasParameterDefault(name);
    }

    public boolean hasParameterMemory(String parameterName) {
        return this.parameterSpecs.hasParameterMemory(parameterName);
    }

    public Expression getParameterDefault(String parameterName) {
        return this.parameterSpecs.getParameterDefault(parameterName);
    }

    public long getParameterMax(String parameterName) {
        return this.parameterSpecs.getParameterMax(parameterName);
    }

    public long getParameterMin(String parameterName) {
        return this.parameterSpecs.getParameterMin(parameterName);
    }

    public void removeDefaulteds(Map<String, Long> params) {
        this.getParameterSpecs().removeDefaulteds(params);
    }

    public void addDefaulteds(Map<String, Long> params) {
        this.getParameterSpecs().addDefaulteds(params);
    }

    public boolean hasNonStandardParameters() {
        return this.getParameterSpecs().hasNonStandardParameters();
    }

    public Map<String, Long> fillInDefaults(Map<String, Long> parameters) throws NameUnassignedException {
        HashMap<String, Long> result = new HashMap<String, Long>(parameters);
        NameEngine nameEngine = new NameEngine(parameters);
        for (ParameterSpec parameterSpec : this.parameterSpecs) {
            String name = parameterSpec.getName();
            if (result.containsKey(name)) continue;
            Expression deflt = parameterSpec.getDefault();
            if (deflt == null) {
                throw new NameUnassignedException(name);
            }
            long val = deflt.toLong(nameEngine);
            result.put(name, val);
        }
        return result;
    }

    private ParameterSpecs computeParameterSpecs() throws InvalidNameException, NameUnassignedException {
        ParameterSpecs paramSpecs = new ParameterSpecs();
        this.bitspecIrstream.createParameterSpecs(paramSpecs);
        return paramSpecs;
    }

    private void createParameterSpecs() throws InvalidNameException, NameUnassignedException {
        ParameterSpecs paramSpecs = this.computeParameterSpecs();
        this.parameterSpecs.replace(paramSpecs);
    }

    public void createParameterSpecsIfPossible() {
        try {
            this.createParameterSpecs();
        }
        catch (InvalidNameException ex) {
            logger.log(Level.WARNING, null, ex);
        }
        catch (NameUnassignedException ex) {
            Logger.getLogger(Protocol.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static class ProtocolNotRenderableException
    extends IrpException {
        ProtocolNotRenderableException(String protocolName) {
            super("Protocol " + protocolName + " not renderable.");
        }
    }

    public static class ProtocolNotDecodableException
    extends IrpException {
        ProtocolNotDecodableException(String name) {
            super("Protocol " + name + " not decodable.");
        }
    }
}

