/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.harctoolbox.analyze.Analyzer;
import org.harctoolbox.ircore.IrSequence;
import org.harctoolbox.irp.Decoder;
import org.harctoolbox.irp.ElementaryDecode;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.Protocol;
import org.harctoolbox.xml.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ProtocolListDomFactory {
    private Map<Integer, Protocol> protocolsWithoutDefs = new HashMap<Integer, Protocol>(8);
    private final Document doc;
    private final List<String> names;
    private final int radix;
    private final Analyzer analyzer;
    private final List<Protocol> protocols;
    private int counter;
    private Element commandSet;

    public static Document protocolListToDom(Analyzer analyzer, List<Protocol> protocols, List<String> names, int radix, boolean fat) {
        ProtocolListDomFactory factory = new ProtocolListDomFactory(analyzer, protocols, names, radix, fat);
        return factory.getDocument();
    }

    private ProtocolListDomFactory(Analyzer analyzer, List<Protocol> protocols, List<String> names, int radix, boolean fat) {
        this.analyzer = analyzer;
        this.protocols = protocols;
        this.names = names;
        this.radix = radix;
        this.counter = 0;
        this.doc = XmlUtils.newDocument(true);
        this.doc.appendChild(this.doc.createComment("This file is in the Girr (General IR Remote) format, see http://www.harctoolbox.org/Girr.html"));
        Element remotes = this.doc.createElementNS("http://www.harctoolbox.org/Girr", "remotes");
        remotes.setAttribute("xsi:schemaLocation", "http://www.harctoolbox.org/Girr http://www.harctoolbox.org/schemas/girr_ns-1.2.xsd http://www.harctoolbox.org/irp-protocols http://www.harctoolbox.org/schemas/irp-protocols.xsd");
        remotes.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        remotes.setAttribute("title", "Generated by IrpTransmogrifier version 1.2.14");
        remotes.setAttribute("girrVersion", "1.2");
        this.doc.appendChild(remotes);
        if (protocols != null) {
            Element protocolsElement = this.mkProtocols();
            remotes.appendChild(protocolsElement);
        }
        Element remote = this.commandsToElement(fat);
        remotes.appendChild(remote);
    }

    public ProtocolListDomFactory(int radix) {
        this(null, null, null, radix, false);
    }

    private Element commandsToElement(boolean fat) {
        Element remote = this.doc.createElementNS("http://www.harctoolbox.org/Girr", "remote");
        remote.setAttribute("name", "remote");
        this.commandSet = this.doc.createElementNS("http://www.harctoolbox.org/Girr", "commandSet");
        this.commandSet.setAttribute("name", "commandSet");
        remote.appendChild(this.commandSet);
        if (this.analyzer != null) {
            if (this.analyzer.isSignalMode()) {
                this.commandSet.appendChild(this.commandToElement(this.protocols.get(0), this.names != null && !this.names.isEmpty() ? this.names.get(0) : null, this.analyzer.cleanedIrSequence(0), this.analyzer.cleanedIrSequence(1), this.analyzer.cleanedIrSequence(2), fat));
            } else {
                for (int i = 0; i < this.protocols.size(); ++i) {
                    this.commandSet.appendChild(this.commandToElement(this.protocols.get(i), this.names != null && this.names.size() > i ? this.names.get(i) : null, this.analyzer.cleanedIrSequence(i), null, null, fat));
                }
            }
        }
        return remote;
    }

    private Element commandToElement(Protocol protocol, String name, IrSequence intro, IrSequence repeat, IrSequence ending, boolean fat) {
        Element command = this.doc.createElementNS("http://www.harctoolbox.org/Girr", "command");
        String commandName = name != null ? name : "unnamed_" + Integer.toString(this.counter++);
        command.setAttribute("name", commandName);
        Element parameters = this.parametersToElement(protocol);
        command.appendChild(parameters);
        Element raw = this.rawToElement(intro, repeat, ending, fat);
        command.appendChild(raw);
        command.setAttribute("master", "raw");
        return command;
    }

    private Element rawToElement(IrSequence intro, IrSequence repeat, IrSequence ending, boolean fat) {
        Element raw = this.doc.createElementNS("http://www.harctoolbox.org/Girr", "raw");
        raw.setAttribute("frequency", Integer.toString(this.analyzer.getFrequency() != null ? this.analyzer.getFrequency().intValue() : 38000));
        if (intro != null) {
            raw.appendChild(this.irSequenceToElement(intro, "intro", fat));
        }
        if (repeat != null) {
            raw.appendChild(this.irSequenceToElement(repeat, "repeat", fat));
        }
        if (ending != null) {
            raw.appendChild(this.irSequenceToElement(ending, "ending", fat));
        }
        return raw;
    }

    private Element irSequenceToElement(IrSequence irSequence, String name, boolean fat) {
        Element element = this.doc.createElementNS("http://www.harctoolbox.org/Girr", name);
        if (fat) {
            for (int i = 0; i < irSequence.getLength(); ++i) {
                Element el = this.doc.createElementNS("http://www.harctoolbox.org/Girr", (i & 1) != 0 ? "gap" : "flash");
                Text text = this.doc.createTextNode(Long.toString(Math.round(irSequence.get(i))));
                el.appendChild(text);
                element.appendChild(el);
            }
        } else {
            Text content = this.doc.createTextNode(irSequence.toString(true, " ", "", ""));
            element.appendChild(content);
        }
        return element;
    }

    private Element parametersToElement(Protocol protocol) {
        Element parameters = this.defsToElement(protocol.getDefinitions());
        Protocol withoutDefs = new Protocol(protocol.getGeneralSpec(), protocol.getBitspecIrstream(), new NameEngine(), null);
        parameters.setAttribute("protocol", this.formatProtocolnameFromHash(withoutDefs.hashCode()));
        return parameters;
    }

    private Element decodesToElement(Decoder.Decode d) {
        Element parameters = this.doc.createElementNS("http://www.harctoolbox.org/Girr", "parameters");
        parameters.setAttribute("protocol", d.getName());
        for (Map.Entry<String, Long> definition : d.getMap().entrySet()) {
            Element parameter = this.doc.createElementNS("http://www.harctoolbox.org/Girr", "parameter");
            parameter.setAttribute("name", definition.getKey());
            parameter.setAttribute("value", Long.toString(definition.getValue(), this.radix));
            parameters.appendChild(parameter);
        }
        return parameters;
    }

    private Element defsToElement(NameEngine definitions) {
        Element parameters = this.doc.createElementNS("http://www.harctoolbox.org/Girr", "parameters");
        for (Map.Entry<String, Expression> definition : definitions) {
            Element parameter = this.doc.createElementNS("http://www.harctoolbox.org/Girr", "parameter");
            parameter.setAttribute("name", definition.getKey());
            parameter.setAttribute("value", definition.getValue().toIrpString(this.radix));
            parameters.appendChild(parameter);
        }
        return parameters;
    }

    private Element mkProtocols() {
        this.protocolsWithoutDefs = new HashMap<Integer, Protocol>(4);
        this.protocols.stream().map(protocol -> new Protocol(protocol.getGeneralSpec(), protocol.getBitspecIrstream(), new NameEngine(), protocol.getParameterSpecs())).forEachOrdered(withoutDefs -> this.protocolsWithoutDefs.put(withoutDefs.hashCode(), (Protocol)withoutDefs));
        Element protocolsElement = this.doc.createElementNS("http://www.harctoolbox.org/irp-protocols", "irp:protocols");
        this.protocolsWithoutDefs.entrySet().forEach(proto -> {
            Element protocolElement = this.doc.createElementNS("http://www.harctoolbox.org/irp-protocols", "irp:protocol");
            protocolElement.setAttribute("name", this.formatProtocolnameFromHash((Integer)proto.getKey()));
            protocolsElement.appendChild(protocolElement);
            Element irp = this.doc.createElementNS("http://www.harctoolbox.org/irp-protocols", "irp:irp");
            irp.appendChild(this.doc.createCDATASection(((Protocol)proto.getValue()).toIrpString(this.radix)));
            protocolElement.appendChild(irp);
        });
        return protocolsElement;
    }

    private Document getDocument() {
        return this.doc;
    }

    private String formatProtocolnameFromHash(Integer key) {
        return "p_" + Integer.toUnsignedString(key, 16);
    }

    public void add(Decoder.AbstractDecodesCollection<? extends ElementaryDecode> decodes, String name) {
        this.commandSet.appendChild(this.mkParametrized(decodes, name));
    }

    public void add(Decoder.AbstractDecodesCollection<? extends ElementaryDecode> decodes) {
        String commandName = "unnamed_" + Integer.toString(this.counter++);
        this.add(decodes, commandName);
    }

    private Element mkParametrized(Decoder.AbstractDecodesCollection<? extends ElementaryDecode> decodes, String commandName) {
        Element command = this.doc.createElementNS("http://www.harctoolbox.org/Girr", "command");
        command.setAttribute("name", commandName);
        Decoder.Decode d = decodes.first().getDecode();
        Element parameters = this.decodesToElement(d);
        command.appendChild(parameters);
        command.setAttribute("master", "parameters");
        return command;
    }

    public Document toDocument() {
        return this.doc;
    }
}

