/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.harctoolbox.ircore.IrSequence;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.irp.BitwiseParameter;
import org.harctoolbox.irp.Decoder;
import org.harctoolbox.irp.Duration;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrStreamItem;
import org.harctoolbox.irp.Name;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.Numerical;
import org.harctoolbox.irp.ParameterCollector;
import org.harctoolbox.irp.ParameterInconsistencyException;
import org.harctoolbox.irp.ParameterSpecs;
import org.harctoolbox.irp.SignalRecognitionException;
import org.harctoolbox.irp.Traverser;

public final class RecognizeData
extends Traverser
implements Cloneable {
    private int position;
    private double hasConsumed;
    private ParameterCollector parameterCollector;
    private final IrSequence irSequence;
    private int extentStart;
    private final boolean interleaving;
    private ParameterCollector needsChecking;
    private final double absoluteTolerance;
    private final double relativeTolerance;
    private BitwiseParameter danglingBitFieldData = new BitwiseParameter();
    private final double minimumLeadout;
    private int level;
    private final IrSignal.Pass pass;

    public RecognizeData(GeneralSpec generalSpec, NameEngine definitions, ParameterSpecs parameterSpecs, IrSequence irSequence, int position, boolean interleaving, ParameterCollector parameterCollector, double absoluteTolerance, double relativeTolerance, double minimumLeadout, IrSignal.Pass pass) {
        super(generalSpec, definitions);
        this.position = position;
        this.hasConsumed = 0.0;
        this.irSequence = irSequence;
        this.parameterCollector = parameterCollector;
        this.extentStart = position;
        this.interleaving = interleaving;
        this.needsChecking = new ParameterCollector(parameterSpecs);
        this.absoluteTolerance = absoluteTolerance;
        this.relativeTolerance = relativeTolerance;
        this.minimumLeadout = minimumLeadout;
        this.pass = pass;
        this.level = 0;
    }

    public RecognizeData(GeneralSpec generalSpec, NameEngine definitions, ParameterSpecs parameterSpecs, IrSequence irSequence, int beginPos, boolean interleavingOk, ParameterCollector names, Decoder.DecoderParameters params, IrSignal.Pass pass) {
        this(generalSpec, definitions, parameterSpecs, irSequence, beginPos, interleavingOk, names, params.getAbsoluteTolerance(), params.getRelativeTolerance(), params.getMinimumLeadout(), pass);
    }

    public RecognizeData() {
        this(new NameEngine());
    }

    public RecognizeData(NameEngine nameEngine) {
        this(new GeneralSpec(), nameEngine, new ParameterSpecs(), new IrSequence(), 0, false, new ParameterCollector(), new Decoder.DecoderParameters(), IrSignal.Pass.intro);
    }

    public RecognizeData clone() {
        RecognizeData result;
        try {
            result = (RecognizeData)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex);
        }
        result.setParameterCollector(this.getParameterCollector().clone());
        result.nameEngine = new NameEngine(this.nameEngine);
        return result;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public ParameterCollector getParameterCollector() {
        return this.parameterCollector;
    }

    public void setParameterCollector(ParameterCollector parameterCollector) {
        this.parameterCollector = parameterCollector;
    }

    public void add(String name, BitwiseParameter parameter) throws ParameterInconsistencyException {
        Expression expression = this.getNameEngine().getPossiblyNull(name);
        if (expression == null) {
            this.parameterCollector.add(name, parameter);
        } else {
            BitwiseParameter expected = expression.toBitwiseParameter(this);
            boolean consistent = expected.isConsistent(parameter);
            if (!consistent) {
                throw new ParameterInconsistencyException(name, expected, parameter);
            }
            this.parameterCollector.add(name, parameter);
            Long bitmask = this.parameterCollector.getBitmask(name);
            if (bitmask == null || !parameter.isFinished(bitmask)) {
                this.needsChecking.add(name, parameter);
            }
        }
    }

    public void add(Name name, BitwiseParameter value) throws ParameterInconsistencyException {
        this.add(name.toString(), value);
    }

    public void add(String name, long value) throws ParameterInconsistencyException {
        this.add(name, new BitwiseParameter(value));
    }

    public BitwiseParameter remove(String name) {
        return this.parameterCollector.remove(name);
    }

    public boolean isOn() {
        return Duration.isOn(this.position);
    }

    public double get() {
        return this.position < this.irSequence.getLength() ? Math.abs(this.irSequence.get(this.position)) - this.getHasConsumed() : 0.0;
    }

    public void consume() {
        ++this.position;
        this.hasConsumed = 0.0;
    }

    public void consume(double amount) {
        this.hasConsumed += amount;
    }

    public void markExtentStart() {
        this.extentStart = this.position + 1;
    }

    public double getHasConsumed() {
        return this.hasConsumed;
    }

    public void setHasConsumed(double hasConsumed) {
        this.hasConsumed = hasConsumed;
    }

    public boolean leadoutOk(boolean isLast) throws SignalRecognitionException {
        return isLast && this.get() >= this.minimumLeadout;
    }

    public boolean check(boolean on) {
        return this.isOn() == on && this.position < this.irSequence.getLength();
    }

    public double elapsed() {
        return this.irSequence.getTotalDuration(this.extentStart, this.position - this.extentStart);
    }

    public double getExtentDuration() {
        int endPosition = Math.min(this.position + 1, this.irSequence.getLength());
        return this.irSequence.getTotalDuration(this.extentStart, endPosition - this.extentStart);
    }

    public boolean allowChopping() {
        return !this.interleaving;
    }

    void checkConsistency() throws NameUnassignedException, ParameterInconsistencyException {
        this.needsChecking.checkConsistency(this);
        this.needsChecking = new ParameterCollector();
    }

    public double getAbsoluteTolerance() {
        return this.absoluteTolerance;
    }

    public double getRelativeTolerance() {
        return this.relativeTolerance;
    }

    BitwiseParameter getDanglingBitFieldData() {
        return this.danglingBitFieldData;
    }

    void setDanglingBitFieldData(long data, long bitmask) {
        this.danglingBitFieldData = new BitwiseParameter(data, bitmask);
    }

    void setDanglingBitFieldData() {
        this.danglingBitFieldData = new BitwiseParameter();
    }

    void finish() {
        if (this.hasConsumed > 0.0) {
            ++this.position;
            this.hasConsumed = 0.0;
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public Level getLogLevel() {
        return this.level <= 2 ? Level.FINE : (this.level == 3 ? Level.FINER : Level.FINEST);
    }

    public IrSignal.Pass getPass() {
        return this.pass;
    }

    LogRecord logRecordEnter(IrStreamItem item) {
        return this.logRecord(item, true);
    }

    LogRecord logRecordExit(IrStreamItem item) {
        return this.logRecord(item, false);
    }

    private LogRecord logRecord(IrStreamItem item, boolean enter) {
        if (item instanceof Numerical && !enter) {
            BitwiseParameter value = ((Numerical)((Object)item)).toBitwiseParameter(this);
            LogRecord logRecord = new LogRecord(this.getLogLevel(), "{0}Level {1}: \"{2}\", result: {3}");
            logRecord.setParameters(new Object[]{enter ? ">" : "<", this.level, item.toString(), value});
            return logRecord;
        }
        LogRecord logRecord = new LogRecord(this.getLogLevel(), "{0}Level {1}: \"{2}\"");
        logRecord.setParameters(new Object[]{enter ? ">" : "<", this.level, item.toString()});
        return logRecord;
    }

    public LogRecord logRecordEnterWithIrStream(IrStreamItem item) {
        LogRecord logRecord = new LogRecord(this.getLogLevel(), "{0} {1}Level {2}: \"{3}\", IrSequence: {4}");
        logRecord.setParameters(new Object[]{this.getPass().toString(), ">", this.level, item.toString(), this.irSequence});
        return logRecord;
    }

    public void assignment(String nameString, long val) throws InvalidNameException {
        this.nameEngine.define(nameString, val);
    }

    public BitwiseParameter toBitwiseParameter(String name) {
        Expression expression = this.nameEngine.getPossiblyNull(name);
        return expression != null ? expression.toBitwiseParameter(this) : this.parameterCollector.get(name);
    }
}

