/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import org.harctoolbox.irp.IrpObject;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.ParserDriver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class RepeatMarker
extends IrpObject {
    private int min;
    private int max;

    public static RepeatMarker newRepeatMarker(char ch) {
        return ch == '*' ? new RepeatMarker(0, Integer.MAX_VALUE) : (ch == '+' ? new RepeatMarker(1, Integer.MAX_VALUE) : new RepeatMarker(Character.toString(ch)));
    }

    public RepeatMarker(String str) {
        this(new ParserDriver(str));
    }

    private RepeatMarker(ParserDriver parserDriver) {
        this(parserDriver.getParser().repeat_marker());
    }

    public RepeatMarker(IrpParser.Repeat_markerContext ctx) {
        super(ctx);
        String ch;
        switch (ch = ctx.getChild(0).getText()) {
            case "*": {
                this.min = 0;
                this.max = Integer.MAX_VALUE;
                break;
            }
            case "+": {
                this.min = 1;
                this.max = Integer.MAX_VALUE;
                break;
            }
            default: {
                this.min = Integer.parseInt(ch);
                this.max = ctx.getChildCount() > 1 ? Integer.MAX_VALUE : this.min;
            }
        }
    }

    public RepeatMarker(int min, int max) {
        super(null);
        this.min = min;
        this.max = max;
    }

    public RepeatMarker(int n) {
        this(n, n);
    }

    public RepeatMarker() {
        this(1, 1);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RepeatMarker)) {
            return false;
        }
        RepeatMarker other = (RepeatMarker)obj;
        return this.min == other.min && this.max == other.max;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + this.min;
        hash = 89 * hash + this.max;
        return hash;
    }

    public boolean isInfinite() {
        return this.max == Integer.MAX_VALUE;
    }

    @Override
    public int numberOfInfiniteRepeats() {
        return this.isInfinite() ? 1 : 0;
    }

    @Override
    public String toIrpString(int radix) {
        return this.min == 0 && this.max == Integer.MAX_VALUE ? "*" : (this.min == 1 && this.max == Integer.MAX_VALUE ? "+" : (this.min == 1 && this.max == 1 ? "" : (this.min == this.max ? Integer.toString(this.min) : (this.max == Integer.MAX_VALUE ? Integer.toString(this.min) + "+" : "??"))));
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    boolean isRPlus() {
        return this.isInfinite() && this.getMin() > 0;
    }

    @Override
    public Element toElement(Document document) {
        Element element = super.toElement(document);
        if (this.min > 0) {
            element.setAttribute("min", Integer.toString(this.min));
        }
        if (this.max < Integer.MAX_VALUE) {
            element.setAttribute("max", Integer.toString(this.max));
        }
        element.setTextContent(this.toString());
        return element;
    }

    public boolean isTrivial() {
        return this.min == 1 && this.max == 1;
    }

    @Override
    public int weight() {
        return this.isTrivial() ? 0 : 1;
    }
}

