/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.CodeGenerator;
import org.harctoolbox.irp.ItemCodeGenerator;
import org.harctoolbox.irp.STItemCodeGenerator;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.StringRenderer;

public final class STCodeGenerator
extends CodeGenerator {
    private static final Logger logger = Logger.getLogger(STCodeGenerator.class.getName());
    public static final String ST_GROUP_FILEEXTENSION = ".stg";
    private static String stDir = null;
    private STGroup stGroup;

    public static void setStDir(String newStDir) {
        stDir = newStDir;
    }

    public static void trackCreationEvents(boolean value) {
        STGroup.trackCreationEvents = value;
    }

    public static List<String> listTargets() throws IOException {
        File[] candidates = new File(stDir).listFiles((dir, name) -> name.toLowerCase().endsWith(ST_GROUP_FILEEXTENSION));
        ArrayList<String> result = new ArrayList<String>(candidates.length);
        for (File file : candidates) {
            if (new STCodeGenerator(file).isAbstract()) continue;
            String f = file.getName();
            String name2 = f.substring(0, f.length() - 4);
            result.add(name2);
        }
        return result;
    }

    private static STGroupFile newSTGroupFile(File file) throws IOException {
        if (!file.canRead()) {
            throw new FileNotFoundException("ST Group file " + file.getCanonicalPath() + " cannot be read.");
        }
        STGroupFile group = new STGroupFile(file.getCanonicalPath());
        group.registerRenderer(String.class, new StringRenderer());
        return group;
    }

    public STCodeGenerator(String target) throws IOException {
        this(new File(stDir, target + ST_GROUP_FILEEXTENSION));
    }

    public STCodeGenerator(File file) throws IOException {
        this(STCodeGenerator.newSTGroupFile(file));
    }

    public STCodeGenerator(STGroup stGroup) {
        this.stGroup = stGroup;
    }

    @Override
    public ItemCodeGenerator newItemCodeGenerator(String name) {
        ST st = this.stGroup.getInstanceOf(name);
        if (st == null) {
            logger.log(Level.WARNING, "Template {0} was not found", name);
            return null;
        }
        return new STItemCodeGenerator(st);
    }

    @Override
    public void setInspect(boolean inspect) {
        STCodeGenerator.trackCreationEvents(inspect);
    }

    @Override
    public String fileName(String protocolName) {
        ItemCodeGenerator itemCodeGenerator = this.newItemCodeGenerator("FileName");
        if (itemCodeGenerator == null) {
            throw new ThisCannotHappenException("Template \"FileName\" not found.");
        }
        itemCodeGenerator.setAttribute("protocolName", protocolName);
        return itemCodeGenerator.render();
    }
}

