/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.OddSequenceLengthException;
import org.harctoolbox.ircore.Pronto;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.Decoder;
import org.harctoolbox.irp.DomainViolationException;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrpDatabase;
import org.harctoolbox.irp.IrpInvalidArgumentException;
import org.harctoolbox.irp.IrpParseException;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.Protocol;
import org.harctoolbox.irp.UnsupportedRepeatException;

public final class ShortPronto
extends Pronto {
    private static final int RC5_CODE = 20480;
    private static final int RC5X_CODE = 20481;
    private static final int RC6_CODE = 24576;
    private static final int NEC1_CODE = 36874;
    private static final int RC5_FREQUENCY = 115;
    private static final int RC5X_FREQUENCY = 115;
    private static final int RC6_FREQUENCY = 115;
    private static final int NEC1_FREQUENCY = 108;
    private static final String RC5_IRP = "{36k,msb,889}<1,-1|-1,1>((1,~F:1:6,T:1,D:5,F:6,^114m)*,T=1-T)[D:0..31,F:0..127,T@:0..1=0]";
    private static final String RC5X_IRP = "{36k,msb,889}<1,-1|-1,1>((1,~S:1:6,T:1,D:5,-4,S:6,F:6,^114m)*,T=1-T)[D:0..31,S:0..127,F:0..63,T@:0..1=0]";
    private static final String RC6_IRP = "{36k,444,msb}<-1,1|1,-1>((6,-2,1:1,0:3,<-2,2|2,-2>(T:1),D:8,F:8,^107m)*,T=1-T)[D:0..255,F:0..255,T@:0..1=0]";
    private static final String NEC1_IRP = "{38.4k,564}<1,-1|1,-3>(16,-8,D:8,S:8,F:8,~F:8,1,-78,(16,-4,1,-173)*) [D:0..255,S:0..255=255-D,F:0..255]";
    private static final String RC5_NAME = "RC5";
    private static final String RC5X_NAME = "RC5x";
    private static final String RC6_NAME = "RC6";
    private static final String NEC1_NAME = "NEC1";
    private static final Logger logger = Logger.getLogger(ShortPronto.class.getName());
    private static final Decoder decoder = ShortPronto.miniDecoder();

    private static Decoder miniDecoder() {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put(RC5_NAME, RC5_IRP);
        map.put(RC5X_NAME, RC5X_IRP);
        map.put(RC6_NAME, RC6_IRP);
        map.put(NEC1_NAME, NEC1_IRP);
        try {
            IrpDatabase irpDatabase = IrpDatabase.parseIrp(map);
            return new Decoder(irpDatabase);
        }
        catch (IrpParseException ex) {
            return null;
        }
    }

    public static IrSignal parse(int[] ccf) throws InvalidArgumentException {
        if (ccf.length < 6) {
            throw new InvalidArgumentException("CCF is invalid since less than 6 numbers long.");
        }
        if (ccf.length % 2 != 0) {
            throw new OddSequenceLengthException("CCF is invalid since it has an odd number (" + ccf.length + ") of durations.");
        }
        String irp = null;
        Integer D = null;
        Integer S = null;
        Integer F = null;
        int type = ccf[0];
        int introLength = ccf[2];
        int repeatLength = ccf[3];
        if (4 + 2 * (introLength + repeatLength) != ccf.length) {
            throw new InvalidArgumentException("Inconsistent length in CCF (claimed " + (introLength + repeatLength) + " pairs, was " + (ccf.length - 4) / 2 + " pairs).");
        }
        IrSignal irSignal = null;
        int index = 4;
        switch (type) {
            case 0: 
            case 256: {
                irSignal = Pronto.parse(ccf);
                break;
            }
            case 20480: {
                if (introLength + repeatLength != 1) {
                    throw new InvalidArgumentException("Erroneous Pronto Hex lengths");
                }
                irp = RC5_IRP;
                D = ccf[index++];
                F = ccf[index++];
                break;
            }
            case 20481: {
                if (introLength + repeatLength != 2) {
                    throw new InvalidArgumentException("Erroneous Pronto Hex lengths");
                }
                irp = RC5X_IRP;
                D = ccf[index++];
                S = ccf[index++];
                F = ccf[index++];
                break;
            }
            case 24576: {
                if (introLength + repeatLength != 1) {
                    throw new InvalidArgumentException("Erroneous Pronto Hex lengths");
                }
                irp = RC6_IRP;
                D = ccf[index++];
                F = ccf[index++];
                break;
            }
            case 36874: {
                if (introLength + repeatLength != 1) {
                    throw new InvalidArgumentException("Erroneous Pronto Hex lengths");
                }
                irp = NEC1_IRP;
                D = ccf[index] >> 8;
                S = ccf[index++] & 0xFF;
                F = ccf[index] >> 8;
                int cmd_chk = 255 - (ccf[index++] & 0xFF);
                if (F == cmd_chk) break;
                throw new InvalidArgumentException("checksum erroneous");
            }
            default: {
                throw new InvalidArgumentException("CCF type 0x" + Integer.toHexString(type) + " not supported");
            }
        }
        if (irSignal == null) {
            NameEngine nameEngine = new NameEngine(3);
            try {
                nameEngine.define("D", D);
                if (S != null) {
                    nameEngine.define("S", S);
                }
                nameEngine.define("F", F);
                Protocol protocol = new Protocol(irp);
                irSignal = protocol.toIrSignal(nameEngine);
            }
            catch (DomainViolationException ex) {
                logger.log(Level.SEVERE, "{0}", ex.getMessage());
                throw new InvalidArgumentException(ex);
            }
            catch (ArithmeticException | InvalidNameException | IrpInvalidArgumentException | NameUnassignedException | UnsupportedRepeatException ex) {
                throw new ThisCannotHappenException(ex);
            }
        }
        return irSignal;
    }

    public static String long2short(String longString) throws InvalidArgumentException, Pronto.NonProntoFormatException {
        IrSignal irSignal = ShortPronto.parse(longString);
        return ShortPronto.toString(irSignal);
    }

    public static IrSignal parse(String hexstring) throws InvalidArgumentException, Pronto.NonProntoFormatException {
        int[] ccf;
        try {
            ccf = Pronto.parseAsInts(hexstring);
        }
        catch (NumberFormatException ex) {
            throw new InvalidArgumentException("Non-parseable CCF strings");
        }
        if (ccf == null) {
            throw new InvalidArgumentException("Invalid CCF strings");
        }
        return ShortPronto.parse(ccf);
    }

    public static String toString(String protocolName, Long D, Long S, Long F) throws InvalidArgumentException {
        int[] ccf = ShortPronto.toArray(protocolName, D, S, F);
        return ShortPronto.toString(ccf);
    }

    public static String toString(IrSignal irSignal, boolean fallback) {
        Decoder.SimpleDecodesSet decodes = decoder.decodeIrSignal(irSignal);
        if (decodes.isEmpty()) {
            return fallback ? Pronto.toString(irSignal) : null;
        }
        Decoder.Decode decode = (Decoder.Decode)decodes.first();
        return ShortPronto.toString(decode);
    }

    public static String toString(IrSignal irSignal) {
        return ShortPronto.toString(irSignal, true);
    }

    private static String toString(Decoder.Decode decode) {
        try {
            Map<String, Long> map = decode.getMap();
            return ShortPronto.toString(decode.getName(), map.get("D"), map.get("S"), map.get("F"));
        }
        catch (InvalidArgumentException ex) {
            logger.log(Level.SEVERE, null, ex);
            throw new ThisCannotHappenException();
        }
    }

    private static int[] toArray(String protocolName, Long D, Long S, Long F) throws InvalidArgumentException {
        int index = 0;
        if (protocolName.equalsIgnoreCase(RC5_NAME)) {
            if (D > 31L || S != null || F > 127L) {
                throw new InvalidArgumentException("Invalid parameters");
            }
            int[] result = new int[6];
            result[index++] = 20480;
            result[index++] = 115;
            result[index++] = 0;
            result[index++] = 1;
            result[index++] = D.intValue();
            result[index++] = F.intValue();
            return result;
        }
        if (protocolName.equalsIgnoreCase(RC5X_NAME)) {
            if (D > 31L || S > 127L || S < 0L || F > 63L) {
                throw new InvalidArgumentException("Invalid parameters");
            }
            int[] result = new int[8];
            result[index++] = 20481;
            result[index++] = 115;
            result[index++] = 0;
            result[index++] = 2;
            result[index++] = D.intValue();
            result[index++] = S.intValue();
            result[index++] = F.intValue();
            result[index++] = 0;
            return result;
        }
        if (protocolName.equalsIgnoreCase(RC6_NAME)) {
            if (D > 255L || S != null || F > 255L) {
                throw new InvalidArgumentException("Invalid parameters");
            }
            int[] result = new int[6];
            result[index++] = 24576;
            result[index++] = 115;
            result[index++] = 0;
            result[index++] = 1;
            result[index++] = D.intValue();
            result[index++] = F.intValue();
            return result;
        }
        if (protocolName.equalsIgnoreCase(NEC1_NAME)) {
            if (D > 255L || S != null && S > 255L || F > 255L) {
                throw new InvalidArgumentException("Invalid parameters");
            }
            int[] result = new int[6];
            result[index++] = 36874;
            result[index++] = 108;
            result[index++] = 0;
            result[index++] = 1;
            result[index++] = (int)((D << 8) + (S != null && S >= 0L ? S : 255L - D));
            result[index++] = (int)((F << 8) + (255L - F));
            return result;
        }
        return new int[0];
    }

    private ShortPronto() {
    }
}

