/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.ircore.AbstractIrParser;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.IrSignalParser;
import org.harctoolbox.ircore.Pronto;
import org.harctoolbox.irp.ShortPronto;

public class ShortProntoParser
extends AbstractIrParser
implements IrSignalParser {
    private static final Logger logger = Logger.getLogger(ShortProntoParser.class.getName());

    public static IrSignal parse(String str) throws InvalidArgumentException {
        ShortProntoParser instance = new ShortProntoParser(str);
        return instance.toIrSignal();
    }

    public ShortProntoParser(String source) {
        super(source);
    }

    public ShortProntoParser(Iterable<? extends CharSequence> args) {
        super(args);
    }

    @Override
    public IrSignal toIrSignal(Double fallbackFrequency, Double dummyGap) throws InvalidArgumentException {
        try {
            return ShortPronto.parse(this.getSource());
        }
        catch (Pronto.NonProntoFormatException ex) {
            logger.log(Level.FINER, "Tried as Short Pronto, gave up ({0})", ex.getMessage());
            return null;
        }
    }

    @Override
    public String getName() {
        return "Short Pronto Hex";
    }
}

