/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.BitwiseParameter;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.PrimaryItem;
import org.harctoolbox.irp.PrimaryItemExpression;
import org.harctoolbox.irp.RecognizeData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class ThreePartExpression
extends Expression {
    private final String operator;
    private final Expression op1;
    private final Expression op2;

    public static Expression newExpression(IrpParser.ExpressionContext ctx) {
        return new ThreePartExpression((ParseTree)ctx, ctx.expression(0), ctx.getChild(1).getText(), ctx.expression(1));
    }

    public static Expression newExpression(ParseTree ctx, IrpParser.ExpressionContext left, String operator, IrpParser.ExpressionContext right) {
        return new ThreePartExpression(ctx, left, operator, right);
    }

    private static BitwiseParameter wrap(BitwiseParameter param) {
        return param != null ? param : BitwiseParameter.ZERO;
    }

    private ThreePartExpression(ParseTree ctx, IrpParser.ExpressionContext left, String op, IrpParser.ExpressionContext right) {
        this(ctx, Expression.newExpression(left), op, Expression.newExpression(right));
    }

    private ThreePartExpression(ParseTree ctx, Expression first, String operator, Expression third) {
        super(ctx);
        this.op1 = first;
        this.operator = operator;
        this.op2 = third;
    }

    private ThreePartExpression(PrimaryItem pi1, String operator, PrimaryItem pi2) {
        this(null, PrimaryItemExpression.newExpression(pi1), operator, PrimaryItemExpression.newExpression(pi2));
    }

    @Override
    public PrimaryItem substituteConstantVariables(Map<String, Long> constantVariables) {
        return new ThreePartExpression(this.op1.substituteConstantVariables(constantVariables), this.operator, this.op2.substituteConstantVariables(constantVariables));
    }

    @Override
    public String toIrpString(int radix) {
        return "(" + this.op1.toIrpString(radix) + this.operator + this.op2.toIrpString(radix) + ")";
    }

    @Override
    public Map<String, Object> propertiesMap(boolean eval, GeneralSpec generalSpec, NameEngine nameEngine) {
        Map<String, Object> map = super.propertiesMap(10);
        String type = this.operator.equals("**") ? "Exponentiate" : (this.operator.equals("+") ? "Add" : (this.operator.equals("-") ? "Subtract" : (this.operator.equals("*") ? "Multiply" : (this.operator.equals("/") ? "Divide" : (this.operator.equals("%") ? "Modulo" : (this.operator.equals("<<") ? "ShiftLeft" : (this.operator.equals(">>") ? "ShiftRight" : (this.operator.equals("<=") ? "LessOrEqual" : (this.operator.equals(">=") ? "GreaterOrEqual" : (this.operator.equals(">") ? "Greater" : (this.operator.equals("<") ? "Less" : (this.operator.equals("==") ? "Equals" : (this.operator.equals("!=") ? "NotEquals" : (this.operator.equals("&") ? "BitwiseAnd" : (this.operator.equals("|") ? "BitwiseOr" : (this.operator.equals("^") ? "BitwiseExclusiveOr" : (this.operator.equals("&&") ? "And" : (this.operator.equals("||") ? "Or" : null))))))))))))))))));
        map.put("kind", type);
        Map<String, Object> arg1 = this.op1.propertiesMap(true, generalSpec, nameEngine);
        map.put("arg1", arg1);
        map.put("scalar", true);
        Map<String, Object> arg2 = this.op2.propertiesMap(true, generalSpec, nameEngine);
        map.put("arg2", arg2);
        return map;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + Objects.hashCode(this.operator);
        hash = 41 * hash + Objects.hashCode(this.op1);
        hash = 41 * hash + Objects.hashCode(this.op2);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThreePartExpression other = (ThreePartExpression)obj;
        if (!Objects.equals(this.operator, other.operator)) {
            return false;
        }
        if (!Objects.equals(this.op1, other.op1)) {
            return false;
        }
        return Objects.equals(this.op2, other.op2);
    }

    @Override
    public int weight() {
        return 1 + this.op1.weight() + this.op2.weight();
    }

    @Override
    public long toLong(NameEngine nameEngine) throws NameUnassignedException {
        boolean shortCircuiting = this.operator.equals("&&") || this.operator.equals("||");
        long left = this.op1.toLong(nameEngine);
        long right = shortCircuiting ? 0L : this.op2.toLong(nameEngine);
        switch (this.operator) {
            case "**": {
                return IrCoreUtils.power(left, right);
            }
            case "*": {
                return left * right;
            }
            case "/": {
                return left / right;
            }
            case "%": {
                return left % right;
            }
            case "+": {
                return left + right;
            }
            case "-": {
                return left - right;
            }
            case "<<": {
                return left << (int)right;
            }
            case ">>": {
                return left >> (int)right;
            }
            case "<=": {
                return ThreePartExpression.cBoolean(left <= right);
            }
            case ">=": {
                return ThreePartExpression.cBoolean(left >= right);
            }
            case "<": {
                return ThreePartExpression.cBoolean(left < right);
            }
            case ">": {
                return ThreePartExpression.cBoolean(left > right);
            }
            case "==": {
                return ThreePartExpression.cBoolean(left == right);
            }
            case "!=": {
                return ThreePartExpression.cBoolean(left != right);
            }
            case "&": {
                return left & right;
            }
            case "^": {
                return left ^ right;
            }
            case "|": {
                return left | right;
            }
            case "&&": {
                return left == 0L ? 0L : this.op2.toLong(nameEngine);
            }
            case "||": {
                return left != 0L ? left : this.op2.toLong(nameEngine);
            }
        }
        throw new ThisCannotHappenException("Unknown operator: " + this.operator);
    }

    @Override
    public BitwiseParameter toBitwiseParameter(RecognizeData recognizeData) {
        BitwiseParameter left = this.op1.toBitwiseParameter(recognizeData);
        if (left == null) {
            return BitwiseParameter.NULL;
        }
        boolean shortCircuiting = this.operator.equals("&&") || this.operator.equals("||");
        BitwiseParameter right = null;
        if (!shortCircuiting && (right = this.op2.toBitwiseParameter(recognizeData)) == null) {
            return BitwiseParameter.NULL;
        }
        switch (this.operator) {
            case "**": {
                return left.power(right);
            }
            case "*": {
                return left.mul(right);
            }
            case "/": {
                return left.div(right);
            }
            case "%": {
                return left.mod(right);
            }
            case "+": {
                return left.plus(right);
            }
            case "-": {
                return left.minus(right);
            }
            case "<<": {
                return left.leftShift(right);
            }
            case ">>": {
                return left.rightShift(right);
            }
            case "<=": {
                return left.le(right);
            }
            case ">=": {
                return left.ge(right);
            }
            case "<": {
                return left.lt(right);
            }
            case ">": {
                return left.gt(right);
            }
            case "==": {
                return left.eq(right);
            }
            case "!=": {
                return left.ne(right);
            }
            case "&": {
                return left.and(right);
            }
            case "^": {
                return left.xor(right);
            }
            case "|": {
                return left.or(right);
            }
            case "&&": {
                return left.isFalse() ? left : ThreePartExpression.wrap(this.op2.toBitwiseParameter(recognizeData));
            }
            case "||": {
                return left.isTrue() ? left : ThreePartExpression.wrap(this.op2.toBitwiseParameter(recognizeData));
            }
        }
        throw new ThisCannotHappenException("Unknown operator: " + this.operator);
    }

    @Override
    public Element toElement(Document document) {
        Element el = super.toElement(document);
        Element e = document.createElement("BinaryOperator");
        e.setAttribute("kind", this.operator);
        el.appendChild(e);
        e.appendChild(this.op1.toElement(document));
        e.appendChild(this.op2.toElement(document));
        return el;
    }

    @Override
    public BitwiseParameter invert(BitwiseParameter rhs, RecognizeData recognizeData) throws NameUnassignedException {
        BitwiseParameter right = this.op2.toBitwiseParameter(recognizeData);
        if (right == null) {
            return BitwiseParameter.NULL;
        }
        switch (this.operator) {
            case "+": {
                return rhs.minus(right);
            }
            case "-": {
                return rhs.plus(right);
            }
            case "*": {
                return rhs.div(right);
            }
            case "/": {
                return rhs.mul(right);
            }
            case "^": {
                return rhs.xor(right);
            }
        }
        return null;
    }

    @Override
    public PrimaryItem leftHandSide() {
        return this.op1;
    }

    @Override
    public boolean constant(NameEngine nameEngine) {
        return this.op1.constant(nameEngine) && this.op1.constant(nameEngine);
    }
}

