/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.BitwiseParameter;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.PrimaryItem;
import org.harctoolbox.irp.PrimaryItemExpression;
import org.harctoolbox.irp.RecognizeData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class TwoPartExpression
extends Expression {
    private final char operator;
    private final Expression operand;

    public static Expression newExpression(IrpParser.ExpressionContext ctx) {
        return TwoPartExpression.newExpression((ParseTree)ctx, ctx.getChild(0).getText().charAt(0), ctx.expression(0));
    }

    public static Expression newExpression(ParseTree ctx, char operator, IrpParser.ExpressionContext expression) {
        return new TwoPartExpression(ctx, operator, expression);
    }

    public static Expression newExpression(ParseTree ctx, ParseTree first, ParseTree second) {
        return new TwoPartExpression(ctx, first, second);
    }

    private TwoPartExpression(ParseTree ctx, char operator, IrpParser.ExpressionContext operand) {
        this(ctx, operator, Expression.newExpression(operand));
    }

    private TwoPartExpression(ParseTree ctx, ParseTree first, ParseTree second) {
        this(ctx, first.getText().charAt(0), Expression.newExpression((IrpParser.ExpressionContext)second));
    }

    private TwoPartExpression(ParseTree ctx, char operator, Expression operand) {
        super(ctx);
        this.operator = operator;
        this.operand = operand;
    }

    private TwoPartExpression(char operator, PrimaryItem primaryItem) {
        this(null, operator, PrimaryItemExpression.newExpression(primaryItem));
    }

    @Override
    public PrimaryItem substituteConstantVariables(Map<String, Long> constantVariables) {
        return new TwoPartExpression(this.operator, this.operand.substituteConstantVariables(constantVariables));
    }

    @Override
    public String toIrpString(int radix) {
        return "(" + this.operator + this.operand.toIrpString(radix) + ")";
    }

    @Override
    public Map<String, Object> propertiesMap(boolean eval, GeneralSpec generalSpec, NameEngine nameEngine) {
        Map<String, Object> map = super.propertiesMap(4);
        String kind = this.operator == '~' ? "BitInvert" : (this.operator == '!' ? "Negate" : (this.operator == '-' ? "UnaryMinus" : (this.operator == '#' ? "BitCount" : null)));
        map.put("kind", kind);
        Map<String, Object> arg = this.operand.propertiesMap(true, generalSpec, nameEngine);
        map.put("arg", arg);
        return map;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + this.operator;
        hash = 37 * hash + Objects.hashCode(this.operand);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TwoPartExpression other = (TwoPartExpression)obj;
        if (this.operator != other.operator) {
            return false;
        }
        return Objects.equals(this.operand, other.operand);
    }

    @Override
    public int weight() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long toLong(NameEngine nameEngine) throws NameUnassignedException {
        long op = this.operand.toLong(nameEngine);
        switch (this.operator) {
            case '!': {
                return op == 0L ? 1L : 0L;
            }
            case '#': {
                return Long.bitCount(op);
            }
            case '-': {
                return -op;
            }
            case '~': {
                return op ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        throw new ThisCannotHappenException("Unknown operator: " + this.operator);
    }

    @Override
    public BitwiseParameter toBitwiseParameter(RecognizeData recognizeData) {
        BitwiseParameter op = this.operand.toBitwiseParameter(recognizeData);
        if (op == null) {
            return BitwiseParameter.NULL;
        }
        switch (this.operator) {
            case '!': {
                return op.negation();
            }
            case '#': {
                return op.bitCount();
            }
            case '-': {
                return op.minus();
            }
            case '~': {
                return op.bitInvert();
            }
        }
        throw new ThisCannotHappenException("Unknown operator: " + this.operator);
    }

    @Override
    public Element toElement(Document document) {
        Element el = super.toElement(document);
        Element e = document.createElement("UnaryOperator");
        e.setAttribute("kind", "" + this.operator);
        el.appendChild(e);
        e.appendChild(this.operand.toElement(document));
        return el;
    }

    @Override
    public BitwiseParameter invert(BitwiseParameter rhs, RecognizeData nameEngine) {
        switch (this.operator) {
            case '~': {
                return rhs.bitInvert();
            }
            case '-': {
                return rhs.minus();
            }
        }
        return null;
    }

    @Override
    public PrimaryItem leftHandSide() {
        return this.operand;
    }

    @Override
    public boolean constant(NameEngine nameEngine) {
        return this.operand.constant(nameEngine);
    }
}

