/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.BareIrStream;
import org.harctoolbox.irp.BitSpec;
import org.harctoolbox.irp.DurationType;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrStream;
import org.harctoolbox.irp.IrStreamItem;
import org.harctoolbox.irp.IrpObject;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.ParameterSpecs;
import org.harctoolbox.irp.ParserDriver;
import org.harctoolbox.irp.RecognizeData;
import org.harctoolbox.irp.RenderData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class Variation
extends IrpObject
implements IrStreamItem {
    private final BareIrStream intro;
    private final BareIrStream repeat;
    private final BareIrStream ending;

    private static int numberOfInfiniteRepeats(BareIrStream bareIrStream) {
        return bareIrStream == null ? 0 : bareIrStream.numberOfInfiniteRepeats();
    }

    public Variation(String str) {
        this(new ParserDriver(str));
    }

    public Variation(ParserDriver parserDriver) {
        this(parserDriver.getParser().variation());
    }

    public Variation(IrpParser.VariationContext variation) {
        super(variation);
        this.intro = new BareIrStream(variation.alternative(0).bare_irstream());
        this.repeat = new BareIrStream(variation.alternative(1).bare_irstream());
        this.ending = variation.alternative().size() > 2 ? new BareIrStream(variation.alternative(2).bare_irstream()) : new BareIrStream();
    }

    public Variation(BareIrStream intro, BareIrStream repeat, BareIrStream ending) {
        super(null);
        this.intro = intro;
        this.repeat = repeat;
        this.ending = ending;
    }

    @Override
    public IrStreamItem substituteConstantVariables(Map<String, Long> constantVariables) {
        return new Variation((BareIrStream)this.intro.substituteConstantVariables((Map)constantVariables), (BareIrStream)this.repeat.substituteConstantVariables((Map)constantVariables), (BareIrStream)this.ending.substituteConstantVariables((Map)constantVariables));
    }

    @Override
    public boolean isEmpty(NameEngine nameEngine) {
        return this.intro.isEmpty(nameEngine) && this.repeat.isEmpty(nameEngine) && (this.ending == null || this.ending.isEmpty(nameEngine));
    }

    public BareIrStream select(IrSignal.Pass pass) {
        BareIrStream result;
        switch (pass) {
            case intro: {
                result = this.intro;
                break;
            }
            case repeat: {
                result = this.repeat;
                break;
            }
            case ending: {
                result = this.ending;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result;
    }

    @Override
    public int numberOfInfiniteRepeats() {
        return Math.max(Variation.numberOfInfiniteRepeats(this.intro), Math.max(Variation.numberOfInfiniteRepeats(this.repeat), Variation.numberOfInfiniteRepeats(this.ending)));
    }

    @Override
    public Element toElement(Document document) {
        Element element = super.toElement(document);
        element.appendChild(this.intro.toElement(document));
        element.appendChild(this.repeat.toElement(document));
        element.appendChild(this.ending.toElement(document));
        return element;
    }

    @Override
    public Integer numberOfBareDurations() {
        return null;
    }

    @Override
    public Integer numberOfBits() {
        try {
            return this.intro.numberOfBits() + this.repeat.numberOfBits() + this.ending.numberOfBits();
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @Override
    public String toIrpString(int radix) {
        StringBuilder str = new StringBuilder(50);
        str.append("[").append(this.intro.toIrpString(radix)).append("]");
        str.append("[").append(this.repeat.toIrpString(radix)).append("]");
        if (this.ending != null && !this.ending.isEmpty(null)) {
            str.append("[").append(this.ending.toIrpString(radix)).append("]");
        }
        return str.toString();
    }

    @Override
    public void decode(RecognizeData recognizeData, List<BitSpec> bitSpecs, boolean isLast) {
        throw new ThisCannotHappenException("decode cannot be called on a protocol with variation.");
    }

    @Override
    public BareIrStream extractPass(IrSignal.Pass pass, IrStream.PassExtractorState state) {
        return this.select(state.getState()).extractPass(pass, state);
    }

    @Override
    public void updateStateWhenEntering(IrSignal.Pass pass, IrStream.PassExtractorState state) {
        if (this.select(state.getState()).isEmpty()) {
            state.setState(IrSignal.Pass.finish);
        }
    }

    @Override
    public boolean interleavingOk(DurationType last, boolean gapFlashBitSpecs) {
        return BareIrStream.interleavingOk(this.intro, last, gapFlashBitSpecs) && BareIrStream.interleavingOk(this.intro, last, gapFlashBitSpecs) && BareIrStream.interleavingOk(this.intro, last, gapFlashBitSpecs);
    }

    @Override
    public boolean interleavingOk(DurationType toCheck, DurationType last, boolean gapFlashBitSpecs) {
        return BareIrStream.interleavingOk(toCheck, this.intro, last, gapFlashBitSpecs) && BareIrStream.interleavingOk(toCheck, this.intro, last, gapFlashBitSpecs) && BareIrStream.interleavingOk(toCheck, this.intro, last, gapFlashBitSpecs);
    }

    @Override
    public DurationType endingDurationType(DurationType last, boolean gapFlashBitSpecs) {
        return BareIrStream.endingDurationType(this.intro, last, gapFlashBitSpecs).combine(BareIrStream.endingDurationType(this.repeat, last, gapFlashBitSpecs)).combine(BareIrStream.endingDurationType(this.ending, last, gapFlashBitSpecs));
    }

    @Override
    public DurationType startingDuratingType(DurationType last, boolean gapFlashBitSpecs) {
        return BareIrStream.startingDurationType(this.intro, last, gapFlashBitSpecs).combine(BareIrStream.startingDurationType(this.repeat, last, gapFlashBitSpecs)).combine(BareIrStream.startingDurationType(this.ending, last, gapFlashBitSpecs));
    }

    @Override
    public int weight() {
        return this.intro.weight() + this.repeat.weight() + this.ending.weight();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Variation)) {
            return false;
        }
        Variation other = (Variation)obj;
        return this.intro.equals(other.intro) && this.repeat.equals(other.repeat) && this.ending.equals(other.ending);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + Objects.hashCode(this.intro);
        hash = 61 * hash + Objects.hashCode(this.repeat);
        hash = 61 * hash + Objects.hashCode(this.ending);
        return hash;
    }

    @Override
    public boolean hasExtent() {
        return this.intro.hasExtent() || this.repeat.hasExtent() || this.ending.hasExtent();
    }

    public boolean hasPart(IrSignal.Pass part) {
        if (part == null) {
            return true;
        }
        return !this.select(part).isEmpty();
    }

    @Override
    public Set<String> assignmentVariables() {
        Set<String> list = this.intro.assignmentVariables();
        list.addAll(this.repeat.assignmentVariables());
        list.addAll(this.ending.assignmentVariables());
        return list;
    }

    @Override
    public Map<String, Object> propertiesMap(GeneralSpec generalSpec, NameEngine nameEngine) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Double microSeconds(GeneralSpec generalSpec, NameEngine nameEngine) {
        return null;
    }

    @Override
    public Integer numberOfDurations() {
        return null;
    }

    @Override
    public void render(RenderData renderData, List<BitSpec> bitSpecs) {
        throw new ThisCannotHappenException();
    }

    @Override
    public void evaluate(RenderData renderData, List<BitSpec> bitSpecStack) {
        throw new ThisCannotHappenException();
    }

    public boolean startsWithFlash() {
        return (!this.intro.isEmpty() ? this.intro : this.repeat).startsWithFlash();
    }

    @Override
    public boolean nonConstantBitFieldLength() {
        return this.intro.nonConstantBitFieldLength() || this.repeat.nonConstantBitFieldLength() || this.ending.nonConstantBitFieldLength();
    }

    @Override
    public Integer guessParameterLength(String name) {
        Integer result = this.intro.guessParameterLength(name);
        if (result != null) {
            return result;
        }
        result = this.repeat.guessParameterLength(name);
        if (result != null) {
            return result;
        }
        return this.ending.guessParameterLength(name);
    }

    @Override
    public TreeSet<Double> allDurationsInMicros(GeneralSpec generalSpec, NameEngine nameEngine) {
        TreeSet<Double> result = new TreeSet<Double>();
        for (IrSignal.Pass pass : IrSignal.Pass.values()) {
            if (pass == IrSignal.Pass.finish) continue;
            TreeSet<Double> durations = this.select(pass).allDurationsInMicros(generalSpec, nameEngine);
            result.addAll(durations);
        }
        return result;
    }

    @Override
    public boolean constant(NameEngine nameEngine) {
        return this.intro.constant(nameEngine) && this.repeat.constant(nameEngine) && this.ending.constant(nameEngine);
    }

    @Override
    public void createParameterSpecs(ParameterSpecs parameterSpecs) throws InvalidNameException {
        this.intro.createParameterSpecs(parameterSpecs);
        this.repeat.createParameterSpecs(parameterSpecs);
        this.ending.createParameterSpecs(parameterSpecs);
    }
}

