/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.lirc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.lirc.LircCommand;
import org.harctoolbox.lirc.LircRemote;

public final class LircConfigFile {
    private static final Logger logger = Logger.getLogger(LircConfigFile.class.getName());
    public static final String DEFAULT_CHARSET_NAME = "WINDOWS-1252";
    private List<LircRemote> remotes = new ArrayList<LircRemote>(4);
    private LineNumberReader reader;
    private String line;
    private String[] words;
    private boolean raw;

    static void readConfig(Map<String, LircRemote> dictionary, File filename, String charsetName) throws IOException {
        logger.log(Level.FINER, "Parsing {0}", filename.getCanonicalPath());
        if (filename.isFile()) {
            LircConfigFile config = new LircConfigFile(filename, filename.getCanonicalPath(), charsetName);
            LircConfigFile.accumulate(dictionary, config.remotes);
        } else if (filename.isDirectory()) {
            File[] files;
            for (File file : files = filename.listFiles()) {
                if (file.getName().endsWith(".jpg") || file.getName().endsWith(".png") || file.getName().endsWith(".gif") || file.getName().endsWith(".html")) {
                    logger.log(Level.INFO, "Rejecting file {0}", file.getCanonicalPath());
                    continue;
                }
                LircConfigFile.readConfig(dictionary, file, charsetName);
            }
        } else {
            throw new FileNotFoundException("File or directory " + filename.getCanonicalPath() + " not existing, or not a normal file");
        }
    }

    static void readConfig(Map<String, LircRemote> dictionary, File filename) throws IOException {
        LircConfigFile.readConfig(dictionary, filename, DEFAULT_CHARSET_NAME);
    }

    static void readConfig(Map<String, LircRemote> dictionary, Reader reader, String source) throws IOException {
        LircConfigFile config = new LircConfigFile(reader, source);
        LircConfigFile.accumulate(dictionary, config.remotes);
    }

    static void readConfig(Map<String, LircRemote> dictionary, Reader reader) throws IOException {
        LircConfigFile.readConfig(dictionary, reader, null);
    }

    public static List<LircRemote> readRemotesFileOrDirectory(File fileOrDirectory, String charSetName) throws IOException {
        LinkedHashMap<String, LircRemote> map = new LinkedHashMap<String, LircRemote>(4);
        LircConfigFile.readConfig(map, fileOrDirectory, charSetName);
        return new ArrayList<LircRemote>(map.values());
    }

    public static List<LircRemote> readRemotes(Reader reader, String source) throws IOException {
        return Collections.unmodifiableList(new LircConfigFile((Reader)reader, (String)source).remotes);
    }

    public static List<LircRemote> readRemotes(Reader reader) throws IOException {
        return LircConfigFile.readRemotes(reader, null);
    }

    public static List<LircRemote> readRemotes(String urlOrFilename, String charSetName) throws IOException {
        List<LircRemote> rems;
        try {
            rems = LircConfigFile.readRemotesURL(urlOrFilename, charSetName);
        }
        catch (MalformedURLException ex) {
            rems = LircConfigFile.readRemotesFileOrDirectory(new File(urlOrFilename), charSetName);
        }
        return Collections.unmodifiableList(rems);
    }

    public static List<LircRemote> readRemotesURL(String urlOrFilename, String charsetName) throws MalformedURLException, IOException {
        URL url = new URL(urlOrFilename);
        URLConnection urlConnection = url.openConnection();
        try (InputStream inputStream = urlConnection.getInputStream();){
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charsetName);
            List<LircRemote> list = LircConfigFile.readRemotes(inputStreamReader, urlOrFilename);
            return list;
        }
    }

    static long parseLircNumber(String s) {
        return s.toLowerCase(Locale.US).startsWith("0x") ? LircConfigFile.parseUnsignedLongHex(s.substring(2)) : (s.startsWith("0") ? Long.parseLong(s, 8) : Long.parseLong(s));
    }

    static long parseUnsignedLongHex(String s) {
        if (s.length() == 16) {
            return new BigInteger(s, 16).longValue();
        }
        return Long.parseLong(s, 16);
    }

    private static void accumulate(Map<String, LircRemote> dictionary, Collection<LircRemote> values) {
        values.forEach(irRemote -> {
            String remoteName = irRemote.getName();
            int n = 1;
            while (dictionary.containsKey(remoteName)) {
                remoteName = irRemote.getName() + "$" + n;
                ++n;
            }
            if (n > 1) {
                logger.log(Level.INFO, "Remote name {0} (source: {1}) already present, renaming to {2}", new Object[]{irRemote.getName(), irRemote.getSource(), remoteName});
            }
            dictionary.put(remoteName, (LircRemote)irRemote);
        });
    }

    private LircConfigFile(File configFileName, String source, String charsetName) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        this(new InputStreamReader((InputStream)new FileInputStream(configFileName), charsetName != null ? charsetName : DEFAULT_CHARSET_NAME), source);
    }

    private LircConfigFile(Reader reader, String source) throws IOException {
        this.reader = new LineNumberReader(reader);
        this.line = null;
        this.words = new String[0];
        this.remotes = this.remotes(source);
    }

    /*
     * Loose catch block
     */
    private List<LircRemote> remotes(String source) throws IOException {
        ArrayList<LircRemote> rems = new ArrayList<LircRemote>(4);
        while (true) {
            try {
                while (true) {
                    LircRemote remote = this.remote(source);
                    rems.add(remote);
                }
            }
            catch (ParseException ex) {
                try {
                    this.lookFor("end", "remote");
                }
                catch (EofException ex1) {
                    return rems;
                }
            }
        }
        catch (EofException ex) {
            return rems;
        }
    }

    private LircRemote remote(String source) throws IOException, ParseException, EofException {
        this.lookFor("begin", "remote");
        ProtocolParameters parameters = this.parameters();
        List<LircCommand> codes = this.codes();
        this.gobble("end", "remote");
        return new LircRemote(parameters.name, parameters.flags, parameters.unaryParameters, parameters.binaryParameters, codes, this.raw, parameters.driver, source);
    }

    private void readLine() throws IOException, EofException {
        if (this.line != null) {
            return;
        }
        this.words = new String[0];
        while (this.words.length == 0) {
            this.line = this.reader.readLine();
            if (this.line == null) {
                throw new EofException();
            }
            this.line = this.line.trim();
            int idx = this.line.indexOf(35);
            if (idx != -1) {
                this.line = this.line.substring(0, idx).trim();
            }
            if (this.line.isEmpty()) continue;
            this.words = this.line.split("\\s+");
        }
    }

    private void consumeLine() {
        this.line = null;
    }

    private void gobble(String ... tokens) throws IOException, EofException, ParseException {
        this.readLine();
        for (int i = 0; i < tokens.length; ++i) {
            if (this.words.length >= tokens.length && this.words[i].equalsIgnoreCase(tokens[i])) continue;
            throw new ParseException("Did not find " + String.join((CharSequence)" ", tokens), this.reader.getLineNumber());
        }
        this.consumeLine();
    }

    private void lookFor(String ... tokens) throws IOException, EofException {
        boolean hit;
        do {
            this.readLine();
            hit = true;
            for (int i = 0; i < tokens.length; ++i) {
                if (this.words.length >= tokens.length && this.words[i].equalsIgnoreCase(tokens[i])) continue;
                hit = false;
                break;
            }
            this.consumeLine();
        } while (!hit);
    }

    /*
     * Unable to fully structure code
     */
    private ProtocolParameters parameters() throws IOException, ParseException, EofException {
        parameters = new ProtocolParameters();
        while (true) {
            this.readLine();
            var2_2 = this.words[0];
            var3_3 = -1;
            switch (var2_2.hashCode()) {
                case 3373707: {
                    if (!var2_2.equals("name")) break;
                    var3_3 = 0;
                    break;
                }
                case -1323526104: {
                    if (!var2_2.equals("driver")) break;
                    var3_3 = 1;
                    break;
                }
                case 97513095: {
                    if (!var2_2.equals("flags")) break;
                    var3_3 = 2;
                    break;
                }
                case 93616297: {
                    if (!var2_2.equals("begin")) break;
                    var3_3 = 3;
                }
            }
            switch (var3_3) {
                case 0: {
                    ProtocolParameters.access$002(parameters, this.words[1]);
                    break;
                }
                case 1: {
                    ProtocolParameters.access$402(parameters, this.words[1]);
                    break;
                }
                case 2: {
                    ProtocolParameters.access$102(parameters, this.flags(this.words));
                    break;
                }
                case 3: {
                    return parameters;
                }
                default: {
                    try {
                        switch (this.words.length) {
                            case 2: {
                                parameters.add(this.words[0], LircConfigFile.parseLircNumber(this.words[1]));
                                ** break;
                            }
                            case 3: {
                                parameters.add(this.words[0], LircConfigFile.parseLircNumber(this.words[1]), LircConfigFile.parseLircNumber(this.words[2]));
                                ** break;
                            }
                        }
                        throw new ParseException("silly parameter decl: " + this.line, this.reader.getLineNumber());
lbl47:
                        // 2 sources

                        break;
                    }
                    catch (NumberFormatException ex) {
                        LircConfigFile.logger.log(Level.INFO, "Could not parse line \"{0}\": {1}", new Object[]{this.line, ex});
                    }
                }
            }
            this.consumeLine();
        }
    }

    private List<String> flags(String[] words) {
        StringJoiner str = new StringJoiner(" ");
        for (int i = 1; i < words.length; ++i) {
            str.add(words[i]);
        }
        String[] array = str.toString().split("\\s*\\|\\s*");
        return Arrays.asList(array);
    }

    private List<LircCommand> codes() throws IOException, EofException, ParseException {
        try {
            return this.cookedCodes();
        }
        catch (ParseException ex) {
            this.raw = true;
            return this.rawCodes();
        }
    }

    private List<LircCommand> cookedCodes() throws IOException, EofException, ParseException {
        this.gobble("begin", "codes");
        ArrayList<LircCommand> codes = new ArrayList<LircCommand>(32);
        try {
            while (true) {
                LircCommand code = this.cookedCode();
                codes.add(code);
            }
        }
        catch (ParseException ex) {
            this.gobble("end", "codes");
            return codes;
        }
    }

    private LircCommand cookedCode() throws IOException, EofException, ParseException {
        this.readLine();
        if (this.words.length < 2) {
            throw new ParseException("", this.reader.getLineNumber());
        }
        if (this.words[0].equalsIgnoreCase("end") && this.words[1].equalsIgnoreCase("codes")) {
            throw new ParseException("", this.reader.getLineNumber());
        }
        ArrayList<Long> codes = new ArrayList<Long>(this.words.length - 1);
        for (int i = 1; i < this.words.length; ++i) {
            codes.add(LircConfigFile.parseLircNumber(this.words[i]));
        }
        LircCommand irNCode = new LircCommand(this.words[0], codes);
        this.consumeLine();
        return irNCode;
    }

    private List<LircCommand> rawCodes() throws IOException, EofException, ParseException {
        this.gobble("begin", "raw_codes");
        ArrayList<LircCommand> codes = new ArrayList<LircCommand>(32);
        try {
            while (true) {
                LircCommand code = this.rawCode();
                codes.add(code);
            }
        }
        catch (ParseException ex) {
            this.gobble("end", "raw_codes");
            return codes;
        }
    }

    private LircCommand rawCode() throws IOException, EofException, ParseException {
        this.readLine();
        if (this.words.length < 2) {
            throw new ParseException("", this.reader.getLineNumber());
        }
        if (this.words[0].equalsIgnoreCase("end") && this.words[1].equalsIgnoreCase("raw_codes")) {
            throw new ParseException("", this.reader.getLineNumber());
        }
        if (!this.words[0].equalsIgnoreCase("name")) {
            throw new ParseException("", this.reader.getLineNumber());
        }
        String cmdName = this.words[1];
        this.consumeLine();
        List<Long> codes = this.integerList();
        return new LircCommand(cmdName, codes);
    }

    private List<Long> integerList() throws IOException, EofException {
        ArrayList<Long> numbers = new ArrayList<Long>(64);
        while (true) {
            this.readLine();
            try {
                for (String w : this.words) {
                    numbers.add(Long.valueOf(w));
                }
            }
            catch (NumberFormatException ex) {
                return numbers;
            }
            this.consumeLine();
        }
    }

    private static class EofException
    extends Exception {
        EofException(String str) {
            super(str);
        }

        private EofException() {
        }
    }

    private static class ProtocolParameters {
        private String name = null;
        private String driver = null;
        private List<String> flags = new ArrayList<String>(8);
        private Map<String, Long> unaryParameters = new HashMap<String, Long>(16);
        private Map<String, LircRemote.Pair> binaryParameters = new HashMap<String, LircRemote.Pair>(8);

        private ProtocolParameters() {
        }

        public void add(String name, long x) {
            this.unaryParameters.put(name, x);
        }

        public void add(String name, long x, long y) {
            this.binaryParameters.put(name, new LircRemote.Pair(x, y));
        }

        static /* synthetic */ String access$002(ProtocolParameters x0, String x1) {
            x0.name = x1;
            return x0.name;
        }

        static /* synthetic */ String access$402(ProtocolParameters x0, String x1) {
            x0.driver = x1;
            return x0.driver;
        }

        static /* synthetic */ List access$102(ProtocolParameters x0, List x1) {
            x0.flags = x1;
            return x0.flags;
        }
    }
}

