/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.lirc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.BareIrStream;
import org.harctoolbox.irp.BitDirection;
import org.harctoolbox.irp.BitSpec;
import org.harctoolbox.irp.BitspecIrstream;
import org.harctoolbox.irp.Duration;
import org.harctoolbox.irp.Extent;
import org.harctoolbox.irp.FiniteBitField;
import org.harctoolbox.irp.Flash;
import org.harctoolbox.irp.Gap;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrStream;
import org.harctoolbox.irp.IrStreamItem;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NonUniqueBitCodeException;
import org.harctoolbox.irp.ParameterSpec;
import org.harctoolbox.irp.ParameterSpecs;
import org.harctoolbox.irp.Protocol;
import org.harctoolbox.irp.RepeatMarker;
import org.harctoolbox.lirc.LircConfigFile;
import org.harctoolbox.lirc.LircRemote;

public final class LircIrp {
    private final LircRemote remote;
    private Protocol protocol;
    private NameEngine nameEngine;
    private GeneralSpec generalSpec;
    private BitSpec bitSpec;
    private IrStream body;

    public static void main(String[] args) {
        int radix = 16;
        try {
            LinkedHashMap<String, LircRemote> remotes = new LinkedHashMap<String, LircRemote>(args.length);
            for (String file : args) {
                LircConfigFile.readConfig(remotes, new File(file));
            }
            for (LircRemote remote : remotes.values()) {
                LircIrp irp = new LircIrp(remote);
                System.out.println(irp.protocol.toIrpString(radix, false));
                remote.getCommands().stream().map(command -> {
                    System.out.print(command.getName() + "\t");
                    return command;
                }).map(command -> {
                    command.getCodes().forEach(code -> System.out.print("0x" + Long.toHexString(code) + " "));
                    return command;
                }).forEachOrdered(_item -> System.out.println());
                System.out.println();
            }
        }
        catch (IOException | NonUniqueBitCodeException | LircCodeRemoteException | RawRemoteException ex) {
            Logger.getLogger(LircIrp.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static Protocol toProtocol(LircRemote lircRemote) throws RawRemoteException, LircCodeRemoteException, NonUniqueBitCodeException {
        return new LircIrp((LircRemote)lircRemote).protocol;
    }

    private LircIrp(LircRemote remote) throws RawRemoteException, LircCodeRemoteException, NonUniqueBitCodeException {
        this.remote = remote;
        if (remote.isRaw()) {
            throw new RawRemoteException(remote.getName());
        }
        if (!remote.isMode2()) {
            throw new LircCodeRemoteException(remote.getName());
        }
        this.setupBitSpec();
        this.setupBody();
        BitspecIrstream bitspecIrstream = new BitspecIrstream(this.bitSpec, this.body);
        this.setupGeneralSpec();
        this.setupNameEngine();
        ParameterSpecs parameterSpecs = this.mkParameterSpecs();
        this.protocol = new Protocol(this.generalSpec, bitspecIrstream, this.nameEngine, parameterSpecs);
    }

    private void setupGeneralSpec() {
        BitDirection bitDirection = BitDirection.newBitDirection(this.remote.hasFlag("REVERSE"));
        Double frequency = this.remote.getUnaryParameters("frequency") != null ? this.remote.getUnaryParameters("frequency").doubleValue() : 38000.0;
        Double dutyCycle = this.remote.getUnaryParameters("duty_cycle") != null ? Double.valueOf(IrCoreUtils.percent2real(this.remote.getUnaryParameters("duty_cycle").longValue())) : null;
        this.generalSpec = new GeneralSpec(bitDirection, null, frequency, dutyCycle);
    }

    private List<IrStreamItem> lengthTwoBareIrStream(String key) {
        return this.lengthTwoBareIrStream(false, key);
    }

    private List<IrStreamItem> lengthTwoBareIrStream(boolean invert, String key) {
        return this.lengthTwoBareIrStream(invert, this.remote.getBinaryParameters(key));
    }

    private List<IrStreamItem> lengthTwoBareIrStream(LircRemote.Pair pair) {
        return this.lengthTwoBareIrStream(false, pair);
    }

    private List<IrStreamItem> lengthTwoBareIrStream(boolean invert, LircRemote.Pair pair) {
        if (pair == null || pair.isTrivial()) {
            return new ArrayList<IrStreamItem>(0);
        }
        return this.lengthXBareIrStream(invert, pair.getFirst(), pair.getSecond());
    }

    private List<IrStreamItem> lengthXBareIrStream(boolean invert, Long ... vars) {
        ArrayList<IrStreamItem> list = new ArrayList<IrStreamItem>(vars.length);
        for (int i = 0; i < vars.length; ++i) {
            boolean odd = i % 2 != 0;
            Duration duration = odd == invert ? new Flash(vars[i].longValue()) : new Gap(vars[i].longValue());
            list.add(duration);
        }
        return list;
    }

    private List<IrStreamItem> bareIrStreamFlash(String key) {
        return this.lengthOneBareIrStream(this.remote.getUnaryParameters(key));
    }

    private List<IrStreamItem> lengthOneBareIrStream(Long value) {
        if (value == null || value == 0L) {
            return new ArrayList<IrStreamItem>(0);
        }
        return this.lengthXBareIrStream(false, value);
    }

    private void setupBitSpec() throws NonUniqueBitCodeException {
        ArrayList<BareIrStream> list = new ArrayList<BareIrStream>(this.remote.hasFlag("RCMM") ? 4 : 2);
        boolean biphaseNonInvert = this.remote.hasFlag("RC6");
        boolean biphaseInvert = this.remote.hasFlag("RC5") || this.remote.hasFlag("SHIFT_ENC");
        BareIrStream zero = new BareIrStream(this.lengthTwoBareIrStream(biphaseNonInvert, "zero"));
        list.add(zero);
        BareIrStream one = new BareIrStream(this.lengthTwoBareIrStream(biphaseInvert, "one"));
        list.add(one);
        if (this.remote.hasFlag("RCMM")) {
            BareIrStream two = new BareIrStream(this.lengthTwoBareIrStream(false, "two"));
            list.add(two);
            BareIrStream three = new BareIrStream(this.lengthTwoBareIrStream(false, "three"));
            list.add(three);
        }
        this.bitSpec = new BitSpec(list);
    }

    private List<IrStreamItem> mkBitField(String name, String lengthName) throws InvalidNameException {
        ArrayList<IrStreamItem> result = new ArrayList<IrStreamItem>(1);
        Long value = this.remote.getUnaryParameters(name);
        Long length = this.remote.getUnaryParameters(lengthName);
        if (value != null && length > 0L) {
            result.add(new FiniteBitField(name, length));
        }
        return result;
    }

    private List<IrStreamItem> ending() {
        ArrayList<IrStreamItem> list = new ArrayList<IrStreamItem>(1);
        Long value = this.remote.getUnaryParameters("gap");
        Duration duration = this.remote.hasFlag("CONST_LENGTH") ? new Extent(value.longValue()) : new Gap(value.longValue());
        list.add(duration);
        return list;
    }

    private void setupBody() {
        try {
            RepeatMarker repeatMarker;
            ArrayList<IrStreamItem> list = new ArrayList<IrStreamItem>(8);
            list.addAll(this.lengthTwoBareIrStream("header"));
            list.addAll(this.bareIrStreamFlash("plead"));
            list.addAll(this.mkBitField("pre_data", "pre_data_bits"));
            list.addAll(this.lengthTwoBareIrStream("pre"));
            list.add(new FiniteBitField("F", this.remote.getUnaryParameters("bits")));
            list.addAll(this.lengthTwoBareIrStream("post"));
            list.addAll(this.mkBitField("post_data", "post_data_bits"));
            list.addAll(this.bareIrStreamFlash("ptrail"));
            list.addAll(this.lengthTwoBareIrStream("foot"));
            list.addAll(this.ending());
            Long repeatMin = this.remote.getUnaryParameters("min_repeat");
            LircRemote.Pair repeatPair = this.remote.getBinaryParameters("repeat");
            if (repeatPair != null && !repeatPair.isTrivial() || this.remote.hasFlag("NO_HEAD_REP") || this.remote.hasFlag("NO_FOOT_REP")) {
                ArrayList<IrStreamItem> repeatList = new ArrayList<IrStreamItem>(4);
                if (this.remote.hasFlag("REPEAT_HEADER")) {
                    repeatList.addAll(this.lengthTwoBareIrStream("header"));
                }
                if (repeatPair != null) {
                    repeatList.addAll(this.lengthTwoBareIrStream(repeatPair));
                }
                repeatList.addAll(this.bareIrStreamFlash("ptrail"));
                repeatList.addAll(this.ending());
                IrStream repeat = new IrStream(new BareIrStream(repeatList), new RepeatMarker(0, Integer.MAX_VALUE));
                list.add(repeat);
                repeatMarker = new RepeatMarker();
            } else {
                repeatMarker = new RepeatMarker(repeatMin != null ? repeatMin.intValue() + 1 : 0, Integer.MAX_VALUE);
            }
            BareIrStream stream = new BareIrStream(list);
            this.body = new IrStream(stream, repeatMarker);
        }
        catch (InvalidNameException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    private void setupNameEngine() {
        this.nameEngine = new NameEngine(2);
        try {
            this.appendName("pre_data");
            this.appendName("post_data");
        }
        catch (InvalidNameException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    private void appendName(String name) throws InvalidNameException {
        Long value = this.remote.getUnaryParameters(name);
        if (value != null) {
            this.nameEngine.define(name, value);
        }
    }

    private ParameterSpecs mkParameterSpecs() {
        ArrayList<ParameterSpec> list = new ArrayList<ParameterSpec>(1);
        try {
            ParameterSpec spec = new ParameterSpec("F", false, this.remote.getUnaryParameters("bits").intValue());
            list.add(spec);
            return new ParameterSpecs(list);
        }
        catch (InvalidNameException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    public static class RawRemoteException
    extends Exception {
        public RawRemoteException(String name) {
            super("LircRemote \"" + name + "\" is a raw remote.");
        }
    }

    public static class LircCodeRemoteException
    extends Exception {
        LircCodeRemoteException(String name) {
            super("LircRemote \"" + name + "\" is a LircCode remote (i.e. it does not contain timing information).");
        }
    }
}

