/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.lirc;

import java.util.List;
import java.util.Map;
import org.harctoolbox.lirc.LircCommand;

public final class LircRemote {
    private final String name;
    private final List<String> flags;
    private final Map<String, Long> unaryParameters;
    private final Map<String, Pair> binaryParameters;
    private final List<LircCommand> commands;
    private final String driver;
    private final String source;
    private final boolean raw;

    LircRemote(String name, List<String> flags, Map<String, Long> unaryParameters, Map<String, Pair> binaryParameters, List<LircCommand> commands, boolean raw, String driver, String source) {
        this.name = name;
        this.flags = flags;
        this.unaryParameters = unaryParameters;
        this.binaryParameters = binaryParameters;
        this.commands = commands;
        this.raw = raw;
        this.driver = driver;
        this.source = source;
    }

    public String getName() {
        return this.name;
    }

    String getSource() {
        return this.source;
    }

    public boolean isMode2() {
        return (this.driver == null || this.driver.equalsIgnoreCase("default")) && this.hasSaneTimingInfo();
    }

    public boolean hasFlag(String flag) {
        return this.flags.contains(flag);
    }

    public Long getUnaryParameters(String key) {
        return this.unaryParameters.get(key);
    }

    public Pair getBinaryParameters(String key) {
        return this.binaryParameters.get(key);
    }

    public List<LircCommand> getCommands() {
        return this.commands;
    }

    public boolean isRaw() {
        return this.raw;
    }

    private boolean hasSaneTimingInfo() {
        return this.hasSane("zero") && this.hasSane("one");
    }

    private boolean hasSane(String name) {
        Pair parameter = this.binaryParameters.get(name);
        return parameter != null && !parameter.isTrivial();
    }

    public static class Pair {
        private final long first;
        private final long second;

        Pair(long x, long y) {
            this.first = x;
            this.second = y;
        }

        public String toString() {
            return "(" + Long.toString(this.first) + ", " + Long.toString(this.second) + ")";
        }

        public boolean isTrivial() {
            return this.first == 0L && this.second == 0L;
        }

        public long getFirst() {
            return this.first;
        }

        public long getSecond() {
            return this.second;
        }
    }
}

