/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.xml;

import java.util.Locale;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DumbHtmlRenderer {
    private static final int CELLSIZE = 12;

    public static String render(DocumentFragment fragment) {
        if (fragment == null) {
            return "";
        }
        String str = DumbHtmlRenderer.render(fragment, true);
        return str.trim();
    }

    private static String render(Node node, boolean preserveSpace) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 3: 
            case 4: {
                return node.getTextContent().replaceAll("\\s+", preserveSpace ? " " : "");
            }
            case 1: {
                return DumbHtmlRenderer.render((Element)node);
            }
            case 9: 
            case 11: {
                return DumbHtmlRenderer.render(node.getChildNodes(), true);
            }
        }
        throw new ThisCannotHappenException();
    }

    private static String render(Element element) {
        String tagName;
        switch (tagName = element.getTagName().toLowerCase(Locale.US)) {
            case "a": {
                return DumbHtmlRenderer.renderA(element);
            }
            case "p": 
            case "div": 
            case "ul": {
                return DumbHtmlRenderer.renderP(element);
            }
            case "li": {
                return DumbHtmlRenderer.renderLi(element);
            }
            case "table": {
                return DumbHtmlRenderer.renderTable(element);
            }
            case "tr": {
                return DumbHtmlRenderer.renderTr(element);
            }
            case "td": 
            case "th": {
                return DumbHtmlRenderer.renderTd(element);
            }
            case "br": {
                return DumbHtmlRenderer.renderBr(element);
            }
        }
        return DumbHtmlRenderer.render(element.getChildNodes(), false);
    }

    private static String render(NodeList nodeList, boolean preserveSpace) {
        StringBuilder sb = new StringBuilder(1024);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String str = DumbHtmlRenderer.render(nodeList.item(i), preserveSpace);
            sb.append(str);
        }
        return sb.toString();
    }

    private static String renderA(Element element) {
        String href = element.getAttribute("href");
        String inner = DumbHtmlRenderer.render(element.getChildNodes(), true);
        boolean isLocal = href.startsWith("#");
        return isLocal ? inner : "[" + inner + "](" + href + ")";
    }

    private static String renderP(Element element) {
        return "\n\n" + DumbHtmlRenderer.render(element.getChildNodes(), true).trim();
    }

    private static String renderLi(Element element) {
        return "\n* " + DumbHtmlRenderer.render(element.getChildNodes(), true).trim();
    }

    private static String renderTable(Element element) {
        return "\n" + IrCoreUtils.chars(37, '-') + "\n" + DumbHtmlRenderer.render(element.getChildNodes(), false) + "\n";
    }

    private static String renderTr(Element element) {
        return DumbHtmlRenderer.render(element.getChildNodes(), false) + "|\n" + IrCoreUtils.chars(37, '-') + "\n";
    }

    private static String renderTd(Element element) {
        String inner = DumbHtmlRenderer.render(element.getChildNodes(), false);
        return "| " + IrCoreUtils.spaces(9 - inner.length()) + inner + " ";
    }

    private static String renderBr(Element element) {
        return "\n";
    }

    private DumbHtmlRenderer() {
    }
}

