/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.xml;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.xml.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XmlTransmogrifier {
    private static JCommander argumentParser;

    private static void usage(int exitcode) {
        argumentParser.usage();
        System.exit(exitcode);
    }

    private static NodeList evaluateXpath(Node node, String xpath, MyResolver resolver) throws XPathExpressionException {
        XPath xpather = XPathFactory.newInstance().newXPath();
        if (resolver != null) {
            xpather.setNamespaceContext(resolver);
        }
        XPathExpression xpathExpression = xpather.compile(xpath);
        return (NodeList)xpathExpression.evaluate(node, XPathConstants.NODESET);
    }

    public static void main(String[] args) {
        CommandLineArguments commandLineArgs = new CommandLineArguments();
        argumentParser = new JCommander(commandLineArgs);
        argumentParser.setProgramName("IrpTransmogrifier");
        argumentParser.setAllowAbbreviatedOptions(true);
        try {
            argumentParser.parse(args);
        }
        catch (ParameterException ex) {
            System.err.println(ex.getMessage());
            XmlTransmogrifier.usage(1);
        }
        if (commandLineArgs.helpRequested) {
            XmlTransmogrifier.usage(0);
        }
        PrintStream out = null;
        try {
            out = IrCoreUtils.getPrintStream(commandLineArgs.output, commandLineArgs.encoding);
        }
        catch (FileNotFoundException | UnsupportedEncodingException ex) {
            System.err.println(ex.getMessage());
            XmlTransmogrifier.usage(1);
        }
        try {
            Document doc = XmlUtils.openXmlFile(commandLineArgs.argument, commandLineArgs.schema, commandLineArgs.nameSpaceAware, true);
            if (commandLineArgs.xpath != null) {
                MyResolver resolver = commandLineArgs.nameSpaceAware ? new MyResolver(doc) : null;
                NodeList nodeList = XmlTransmogrifier.evaluateXpath(doc, commandLineArgs.xpath, resolver);
                Element root = doc.createElement("xpath-result");
                doc.replaceChild(root, doc.getDocumentElement());
                int size = nodeList.getLength();
                root.setAttribute("xpath", commandLineArgs.xpath);
                root.setAttribute("size", Integer.toString(size));
                for (int i = 0; i < size; ++i) {
                    Node node = nodeList.item(i);
                    root.appendChild(node);
                }
            }
            if (!commandLineArgs.print) {
                System.out.println("Use the --print option if you want output.");
                System.exit(0);
            }
            if (commandLineArgs.stylesheet == null) {
                XmlUtils.printDOM(out, doc, commandLineArgs.encoding, null);
            } else {
                Document stylesheet = XmlUtils.openXmlFile(commandLineArgs.stylesheet, null, true, true);
                XmlUtils.printDOM(out, doc, commandLineArgs.encoding, stylesheet, new HashMap<String, String>(0), false);
            }
        }
        catch (IOException | TransformerException | XPathExpressionException | SAXException ex) {
            System.err.println(ex.getMessage());
            System.exit(3);
        }
        System.exit(0);
    }

    private XmlTransmogrifier() {
    }

    public static class CommandLineArguments {
        @Parameter(names={"-e", "--encoding"}, description="Output encoding")
        private String encoding = "UTF-8";
        @Parameter(names={"-h", "-?", "--help"}, description="Print help text")
        private boolean helpRequested = false;
        @Parameter(names={"-n", "--namespaceaware"}, description="Use name space aware parser")
        private boolean nameSpaceAware = false;
        @Parameter(names={"-o", "--output"}, description="Output file; \"-\" for stdout")
        private String output = "-";
        @Parameter(names={"-p", "--print"}, description="Print result on the --output argument")
        private boolean print = false;
        @Parameter(names={"-s", "--schema"}, description="URL/Filename of schema for validation")
        private String schema = null;
        @Parameter(names={"--xpath"}, description="XPath to apply to the document, before stylesheet processing (untested).")
        private String xpath = null;
        @Parameter(names={"--xslt"}, description="URL/filename of stylesheet")
        private String stylesheet = null;
        @Parameter(required=true, description="Input URL/Filename or - for stdin. Will be validated if a --schema argument is given.")
        private String argument = "-";
    }

    private static class MyResolver
    implements NamespaceContext {
        Map<String, String> prefixNamespace;
        Map<String, String> namespacePrefix;

        MyResolver() {
            this.prefixNamespace = new HashMap<String, String>(0);
            this.namespacePrefix = new HashMap<String, String>(0);
        }

        MyResolver(Document document) {
            NamedNodeMap attrs = document.getDocumentElement().getAttributes();
            this.prefixNamespace = new HashMap<String, String>(attrs.getLength());
            this.namespacePrefix = new HashMap<String, String>(attrs.getLength());
            String defaultNsAttribute = document.getDocumentElement().getAttribute("xmlns");
            if (!defaultNsAttribute.isEmpty()) {
                this.prefixNamespace.put("default", defaultNsAttribute);
                this.namespacePrefix.put(defaultNsAttribute, "default");
            }
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node att = attrs.item(i);
                String namespaceURI = att.getNamespaceURI();
                if (namespaceURI == null || !namespaceURI.equals("http://www.w3.org/2000/xmlns/")) continue;
                this.prefixNamespace.put(att.getLocalName(), att.getNodeValue());
                this.namespacePrefix.put(att.getNodeValue(), att.getLocalName());
            }
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.prefixNamespace.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.namespacePrefix.get(namespaceURI);
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            return this.prefixNamespace.keySet().iterator();
        }
    }
}

