/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.xml.MyEntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XmlUtils {
    public static final String DEFAULT_CHARSETNAME = "UTF-8";
    public static final String W3C_SCHEMA_NAMESPACE_ATTRIBUTE_NAME = "xmlns:xsi";
    public static final String HTML_NAMESPACE_ATTRIBUTE_NAME = "xmlns:html";
    public static final String XML_NAMESPACE_ATTRIBUTE_NAME = "xmlns:xml";
    public static final String XINCLUDE_NAMESPACE_ATTRIBUTE_NAME = "xmlns:xi";
    public static final String IRP_NAMESPACE_ATTRIBUTE_NAME = "xmlns:irp";
    public static final String HTML_NAMESPACE_URI = "http://www.w3.org/1999/xhtml";
    public static final String XSLT_NAMESPACE_URI = "http://www.w3.org/1999/XSL/Transform";
    public static final String SCHEMA_LOCATION_ATTRIBUTE_NAME = "xsi:schemaLocation";
    public static final String XML_LANG_ATTRIBUTE_NAME = "xml:lang";
    public static final String XML_SPACE_ATTRIBUTE_NAME = "xml:space";
    public static final String XML_BASE_ATTRIBUTE_NAME = "xml:base";
    public static final String ENCODING_ATTRIBUTE_NAME = "encoding";
    public static final String PRESERVE = "preserve";
    public static final String ENGLISH = "en";
    public static final String YES = "yes";
    public static final String NO = "no";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String XML = "xml";
    public static final String TEXT = "text";
    public static final String HTML = "html";
    public static final String GIRR_NAMESPACE_URI = "http://www.harctoolbox.org/Girr";
    public static final String IRP_NAMESPACE_URI = "http://www.harctoolbox.org/irp-protocols";
    public static final String XINCLUDE_NAMESPACE_URI = "http://www.w3.org/2001/XInclude";
    public static final String IRP_SCHEMA_LOCATION = "http://www.harctoolbox.org/irp-protocols http://www.harctoolbox.org/schemas/irp-protocols.xsd";
    public static final String IRP_PREFIX = "irp";
    public static final String GIRR_PREFIX = "girr";
    public static final String GIRR_COMMENT = "This file is in the Girr (General IR Remote) format, see http://www.harctoolbox.org/Girr.html";
    public static final String GIRR_VERSION_NAME = "girrVersion";
    public static final String GIRR_VERSION = "1.2";
    public static final String GIRR_SCHEMA_LOCATION = "http://www.harctoolbox.org/Girr http://www.harctoolbox.org/schemas/girr_ns-1.2.xsd";
    private static final Logger logger;
    private static boolean debug;
    private static final SchemaFactory schemaFactory;

    public static boolean canValidate() {
        return schemaFactory != null;
    }

    public static void setDebug(boolean dbg2) {
        debug = dbg2;
    }

    public static Document parseStringToXmlDocument(String string, boolean isNamespaceAware, boolean isXIncludeAware) throws SAXException {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(string.getBytes(IrCoreUtils.UTF8));
            return XmlUtils.openXmlStream(stream, null, isNamespaceAware, isXIncludeAware);
        }
        catch (IOException ex) {
            throw new ThisCannotHappenException();
        }
    }

    public static Document openXmlFile(File file, Schema schema, boolean isNamespaceAware, boolean isXIncludeAware) throws SAXException, IOException {
        return XmlUtils.openXmlSource(new InputSource(file.toURI().toString()), schema, isNamespaceAware, isXIncludeAware);
    }

    public static Document openXmlFile(File file, File schemaFile, boolean isNamespaceAware, boolean isXIncludeAware) throws SAXException, IOException {
        return XmlUtils.openXmlFile(file, XmlUtils.readSchema(schemaFile), isNamespaceAware, isXIncludeAware);
    }

    public static Document openXmlFile(File file, String schemaString, boolean isNamespaceAware, boolean isXIncludeAware) throws SAXException, IOException {
        return XmlUtils.openXmlFile(file, XmlUtils.readSchema(schemaString), isNamespaceAware, isXIncludeAware);
    }

    public static Document openXmlFile(String string, String schemaString, boolean isNamespaceAware, boolean isXIncludeAware) throws SAXException, IOException {
        return XmlUtils.openXmlThing(string, XmlUtils.readSchema(schemaString), isNamespaceAware, isXIncludeAware);
    }

    public static Document openXmlFile(File file) throws IOException, SAXException {
        return XmlUtils.openXmlFile(file, (Schema)null, true, true);
    }

    public static Document openXmlReader(Reader reader, Schema schema, boolean isNamespaceAware, boolean isXIncludeAware) throws IOException, SAXException {
        return XmlUtils.openXmlSource(new InputSource(reader), schema, isNamespaceAware, isXIncludeAware);
    }

    public static Document openXmlStream(InputStream stream, Schema schema, boolean isNamespaceAware, boolean isXIncludeAware) throws IOException, SAXException {
        return XmlUtils.openXmlSource(new InputSource(stream), schema, isNamespaceAware, isXIncludeAware);
    }

    public static Document openXmlSource(InputSource inputSource, Schema schema, boolean isNamespaceAware, boolean isXIncludeAware) throws IOException, SAXException {
        DocumentBuilder builder = XmlUtils.newDocumentBuilder(schema, isNamespaceAware, isXIncludeAware);
        return builder.parse(inputSource);
    }

    public static Document openXmlThing(String thing, Schema schema, boolean isNamespaceAware, boolean isXIncludeAware) throws IOException, SAXException {
        return XmlUtils.openXmlSource(XmlUtils.getInputSource(thing), schema, isNamespaceAware, isXIncludeAware);
    }

    public static Document openXmlThing(String thing) throws IOException, SAXException {
        return XmlUtils.openXmlThing(thing, null, true, true);
    }

    public static Document openXmlUrlOrFile(String thing, Schema schema, boolean isNamespaceAware, boolean isXIncludeAware) throws IOException, SAXException {
        try {
            URL url = new URL(thing);
            return XmlUtils.openXmlUrl(url, schema, isNamespaceAware, isXIncludeAware);
        }
        catch (MalformedURLException ex) {
            return XmlUtils.openXmlFile(new File(thing), schema, isNamespaceAware, isXIncludeAware);
        }
    }

    public static Document openXmlUrl(URL url, Schema schema, boolean isNamespaceAware, boolean isXIncludeAware) throws IOException, SAXException {
        URLConnection urlConnection = url.openConnection();
        try (InputStreamReader reader = new InputStreamReader(urlConnection.getInputStream(), IrCoreUtils.UTF8);){
            Document document = XmlUtils.openXmlReader(reader, schema, isNamespaceAware, isXIncludeAware);
            return document;
        }
    }

    public static InputSource getInputSource(String filename) {
        return filename == null || filename.isEmpty() || filename.equals("-") ? new InputSource(System.in) : new InputSource(filename);
    }

    private static DocumentBuilder newDocumentBuilder(Schema schema, boolean isNamespaceAware, boolean isXIncludeAware) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(isNamespaceAware);
        factory.setXIncludeAware(isXIncludeAware);
        try {
            factory.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
            XmlUtils.xeePrevention(factory);
        }
        catch (ParserConfigurationException ex) {
            throw new ThisCannotHappenException(ex);
        }
        if (schema != null) {
            factory.setSchema(schema);
        }
        factory.setValidating(false);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new MyErrorHandler());
            builder.setEntityResolver(new MyEntityResolver());
        }
        catch (ParserConfigurationException ex) {
            throw new ThisCannotHappenException(ex);
        }
        return builder;
    }

    private static void xeePrevention(DocumentBuilderFactory factory) throws ParserConfigurationException {
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setExpandEntityReferences(false);
    }

    public static Document newDocument(boolean isNamespaceAware) {
        DocumentBuilder builder = XmlUtils.newDocumentBuilder(null, isNamespaceAware, false);
        return builder.newDocument();
    }

    public static Document newDocument() {
        return XmlUtils.newDocument(false);
    }

    public static boolean hasSpacePreserve(Node node) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs == null) {
            return false;
        }
        Node att = attrs.getNamedItem(XML_SPACE_ATTRIBUTE_NAME);
        return att != null && att.getTextContent().equals(PRESERVE);
    }

    public static Map<String, Element> createIndex(Element root, String tagName, String idName) {
        HashMap<String, Element> index = new HashMap<String, Element>(20);
        NodeList nodes = root.getElementsByTagName(tagName);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element el = (Element)nodes.item(i);
            String key = el.getAttribute(idName);
            if (key.isEmpty()) continue;
            index.put(key, el);
        }
        return index;
    }

    public static ByteArrayInputStream renderDOM(Document document, Document xslt, String encoding) throws UnsupportedEncodingException, TransformerException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(65536);
        XmlUtils.printDOM(out, document, encoding, xslt, new HashMap<String, String>(0), false);
        byte[] data = out.toByteArray();
        return new ByteArrayInputStream(data);
    }

    public static InputStreamReader mkReaderXml(String docu, String xslt, String encoding) throws SAXException, UnsupportedEncodingException, TransformerException, IOException {
        Document stylesheet = XmlUtils.openXmlThing(xslt, null, true, true);
        return XmlUtils.mkReaderXml(docu, stylesheet, encoding);
    }

    public static InputStreamReader mkReaderXml(String docu, Document stylesheet, String encoding) throws SAXException, UnsupportedEncodingException, TransformerException, IOException {
        Document document = XmlUtils.openXmlThing(docu, null, true, true);
        ByteArrayInputStream inputStream = XmlUtils.renderDOM(document, stylesheet, encoding);
        return new InputStreamReader((InputStream)inputStream, encoding);
    }

    public static void printHtmlDOM(OutputStream ostr, Document doc, String encoding) throws UnsupportedEncodingException {
        IrCoreUtils.checkEncoding(encoding);
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            if (encoding != null) {
                tr.setOutputProperty(ENCODING_ATTRIBUTE_NAME, encoding);
            }
            tr.setOutputProperty("indent", NO);
            tr.setOutputProperty("method", HTML);
            tr.transform(new DOMSource(doc), new StreamResult(ostr));
        }
        catch (TransformerException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    public static void printDOM(OutputStream ostr, Document doc, String encoding, String cdataElements) throws UnsupportedEncodingException {
        IrCoreUtils.checkEncoding(encoding);
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            if (encoding != null) {
                tr.setOutputProperty(ENCODING_ATTRIBUTE_NAME, encoding);
            }
            tr.setOutputProperty("indent", YES);
            tr.setOutputProperty("method", XML);
            if (cdataElements != null) {
                tr.setOutputProperty("cdata-section-elements", cdataElements);
            }
            tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            tr.transform(new DOMSource(doc), new StreamResult(ostr));
        }
        catch (TransformerException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    public static void printDOM(OutputStream ostr, Document doc, String encoding) throws UnsupportedEncodingException {
        XmlUtils.printDOM(ostr, doc, encoding, null);
    }

    public static void printDOM(OutputStream ostr, Document doc) {
        try {
            XmlUtils.printDOM(ostr, doc, DEFAULT_CHARSETNAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static void printDOM(File file, Document doc, String encoding, String cdataElements) throws FileNotFoundException, UnsupportedEncodingException {
        XmlUtils.printDOM(new FileOutputStream(file), doc, encoding, cdataElements);
    }

    public static void printDOM(String xmlFileName, Document doc, String encoding, String cdataElements) throws FileNotFoundException, UnsupportedEncodingException {
        PrintStream xmlStream = IrCoreUtils.getPrintStream(xmlFileName, encoding);
        XmlUtils.printDOM(xmlStream, doc, encoding, cdataElements);
    }

    public static void printDOM(File file, Document doc) throws FileNotFoundException {
        try {
            XmlUtils.printDOM(file, doc, DEFAULT_CHARSETNAME, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static void printDOM(Document doc) {
        try {
            XmlUtils.printDOM(System.out, doc, DEFAULT_CHARSETNAME, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static Schema readSchema(Source source) throws SAXException {
        return XmlUtils.canValidate() ? schemaFactory.newSchema(source) : null;
    }

    public static Schema readSchema(File schemaFile) throws SAXException {
        return XmlUtils.readSchema(new StreamSource(schemaFile));
    }

    public static Schema readSchema(InputStream inputStream) throws SAXException {
        return XmlUtils.readSchema(new StreamSource(inputStream));
    }

    public static Schema readSchema(URL schemaUrl) throws SAXException {
        return XmlUtils.canValidate() ? schemaFactory.newSchema(schemaUrl) : null;
    }

    public static Schema readSchema(String schemaString) throws SAXException, FileNotFoundException, IOException {
        if (schemaString == null || schemaString.isEmpty()) {
            return null;
        }
        InputStream inputStreanm = IrCoreUtils.getInputStream(schemaString);
        return XmlUtils.readSchema(inputStreanm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printDOM(OutputStream ostr, Document document, String encoding, Document xslt, Map<String, String> parameters, boolean binary) throws UnsupportedEncodingException, FileNotFoundException, IOException, TransformerException {
        Element e2;
        IrCoreUtils.checkEncoding(encoding);
        Objects.requireNonNull(xslt);
        if (debug) {
            XmlUtils.printDOM(new File("document.xml"), document);
        }
        try {
            NodeList nodeList;
            TransformerFactory factory = TransformerFactory.newInstance();
            if (parameters != null) {
                parameters.entrySet().stream().map(kvp -> {
                    Element e = xslt.createElementNS(XSLT_NAMESPACE_URI, "xsl:param");
                    e.setAttribute("name", (String)kvp.getKey());
                    e.setAttribute("select", (String)kvp.getValue());
                    return e;
                }).forEachOrdered(e -> xslt.getDocumentElement().insertBefore((Node)e, xslt.getDocumentElement().getFirstChild()));
            }
            if ((nodeList = xslt.getDocumentElement().getElementsByTagNameNS(XSLT_NAMESPACE_URI, "output")).getLength() > 0) {
                e2 = (Element)nodeList.item(0);
                e2.setAttribute(ENCODING_ATTRIBUTE_NAME, encoding);
            }
            if (debug) {
                XmlUtils.printDOM(new File("stylesheet-params.xsl"), xslt);
            }
            Transformer tr = factory.newTransformer(new DOMSource(xslt, xslt.getDocumentURI()));
            tr.setOutputProperty("indent", YES);
            tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            if (binary) {
                DOMResult domResult = new DOMResult();
                tr.transform(new DOMSource(document), domResult);
                Document newDoc = (Document)domResult.getNode();
                if (debug) {
                    XmlUtils.printDOM(new File("girr-binary.xml"), newDoc);
                }
                NodeList byteElements = newDoc.getDocumentElement().getElementsByTagName("byte");
                for (int i = 0; i < byteElements.getLength(); ++i) {
                    int val = Integer.parseInt(byteElements.item(i).getTextContent());
                    ostr.write(val);
                }
            } else {
                tr.transform(new DOMSource(document), new StreamResult(ostr));
            }
        }
        finally {
            if (parameters != null) {
                NodeList nl = xslt.getDocumentElement().getChildNodes();
                for (int i = nl.getLength() - 1; i >= 0; --i) {
                    Node n = nl.item(i);
                    if (n.getNodeType() != 1 || !(e2 = (Element)n).getLocalName().equals("param") || !parameters.containsKey(e2.getAttribute("name"))) continue;
                    xslt.getDocumentElement().removeChild(n);
                }
            }
        }
    }

    public static Map<String, Element> buildIndex(Element element, String tagName, String idName) {
        HashMap<String, Element> index = new HashMap<String, Element>(20);
        NodeList nl = element.getElementsByTagName(tagName);
        for (int i = 0; i < nl.getLength(); ++i) {
            Element el = (Element)nl.item(i);
            String id = el.getAttribute(idName);
            if (id.isEmpty()) continue;
            index.put(id, el);
        }
        return index;
    }

    public static void addBooleanAttributeIfTrue(Element element, String attName, boolean value) {
        if (value) {
            element.setAttribute(attName, TRUE);
        }
    }

    public static void addBooleanAttributeIfFalse(Element element, String attName, boolean value) {
        if (!value) {
            element.setAttribute(attName, FALSE);
        }
    }

    public static void addDoubleAttributeAsInteger(Element element, String attName, double value) {
        element.setAttribute(attName, Long.toString(Math.round(value)));
    }

    public static void addAttributeIfNonNull(Element element, String attName, Object value) {
        if (value != null) {
            element.setAttribute(attName, value.toString());
        }
    }

    public static Document wrapDocumentFragment(DocumentFragment fragment, String namespaceURI, String tagName, String attName, String attValue) {
        Document doc = XmlUtils.newDocument(true);
        Element root = doc.createElementNS(namespaceURI, tagName);
        root.setAttribute(attName, attValue);
        doc.appendChild(root);
        root.appendChild(doc.importNode(fragment, true));
        Object userDatum = fragment.getUserData(XML_SPACE_ATTRIBUTE_NAME);
        if (userDatum != null && ((Boolean)userDatum).booleanValue()) {
            root.setAttribute(XML_SPACE_ATTRIBUTE_NAME, PRESERVE);
        }
        return doc;
    }

    public static DocumentFragment stringToDocumentFragment(String str) {
        Document document = XmlUtils.newDocument();
        Text textNode = document.createTextNode(str);
        DocumentFragment fragment = document.createDocumentFragment();
        fragment.appendChild(textNode);
        return fragment;
    }

    private XmlUtils() {
    }

    static {
        SchemaFactory sf;
        logger = Logger.getLogger(XmlUtils.class.getName());
        debug = false;
        try {
            sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.WARNING, "SchemaFactory.newInstance failed, validation will not be available!");
            sf = null;
        }
        schemaFactory = sf;
        if (schemaFactory != null) {
            MyLSResourceResolver resourceResolver = new MyLSResourceResolver();
            schemaFactory.setResourceResolver(resourceResolver);
        }
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private MyErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXParseException {
            throw new SAXParseException("Parse Error in instream, line " + exception.getLineNumber() + ": " + exception.getMessage(), "", "instream", exception.getLineNumber(), 0);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXParseException {
            throw new SAXParseException("Parse Error in instream, line " + exception.getLineNumber() + ": " + exception.getMessage(), "", "instream", exception.getLineNumber(), 0);
        }

        @Override
        public void warning(SAXParseException exception) {
            logger.log(Level.WARNING, "Parse Warning: {0}{1}", new Object[]{exception.getMessage(), exception.getLineNumber()});
        }
    }

    private static class MyLSResourceResolver
    implements LSResourceResolver {
        MyLSResourceResolver() {
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            try {
                return new MyInput(type, namespaceURI, publicId, systemId, baseURI);
            }
            catch (IOException | URISyntaxException ex) {
                throw new ThisCannotHappenException(ex);
            }
        }
    }

    private static class MyInput
    implements LSInput {
        private String publicId;
        private String systemId;
        private final String stringData;
        private String baseURI;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MyInput(String type, String namespaceURI, String publicId, String systemId, String baseURI) throws URISyntaxException, IOException {
            this.publicId = publicId;
            this.systemId = systemId;
            this.baseURI = baseURI;
            InputStream resourceAsStream = MyEntityResolver.getStream(systemId);
            if (resourceAsStream == null) {
                URL url;
                try {
                    url = new URL(systemId);
                }
                catch (MalformedURLException ex) {
                    URL base = new URI(baseURI).toURL();
                    url = new URL(base, systemId);
                }
                resourceAsStream = url.openStream();
            }
            try (BufferedInputStream inputStream = new BufferedInputStream(resourceAsStream);){
                BufferedInputStream bufferedInputStream = inputStream;
                synchronized (bufferedInputStream) {
                    int result;
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    while ((result = inputStream.read()) != -1) {
                        buf.write((byte)result);
                    }
                    this.stringData = buf.toString(XmlUtils.DEFAULT_CHARSETNAME);
                }
            }
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String publicId) {
        }

        @Override
        public String getBaseURI() {
            return this.baseURI;
        }

        @Override
        public InputStream getByteStream() {
            return null;
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public String getStringData() {
            return this.stringData;
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }
    }
}

