/*
 * Decompiled with CFR 0.152.
 */
package org.thingml.bglib;

public class BDAddr {
    protected byte[] byte_addr;

    public static BDAddr fromString(String addr) {
        String[] bytes = addr.split(":");
        if (bytes.length != 6) {
            throw new Error("Invalid Bluetooth address format.");
        }
        byte[] byte_addr = new byte[6];
        int i = 0;
        while (i < 6) {
            byte_addr[5 - i] = (byte)Integer.parseInt(bytes[i], 16);
            ++i;
        }
        return new BDAddr(byte_addr);
    }

    public byte[] getByteAddr() {
        return this.byte_addr;
    }

    public BDAddr(byte[] addr) {
        this.byte_addr = addr;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.byte_addr.length) {
            result.append(Integer.toHexString(this.byte_addr[5 - i] & 0xFF));
            if (i < this.byte_addr.length - 1) {
                result.append(":");
            }
            ++i;
        }
        return result.toString();
    }
}

