/*
 * Decompiled with CFR 0.152.
 */
package org.thingml.bglib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.thingml.bglib.BDAddr;
import org.thingml.bglib.BGAPIPacketReader;

public class BGAPIPacket {
    protected int msgType;
    protected int classID;
    protected int commandID;
    protected int payloadLength = -1;
    protected ByteArrayOutputStream data = new ByteArrayOutputStream();

    public int getClassID() {
        return this.classID;
    }

    public int getCommandID() {
        return this.commandID;
    }

    public int getMsgType() {
        return this.msgType;
    }

    public int getPayloadLength() {
        return this.payloadLength;
    }

    public ByteArrayOutputStream getPayloadData() {
        return this.data;
    }

    public BGAPIPacket(byte[] header) {
        this.msgType = (header[0] & 0xFF) >> 7;
        this.payloadLength = ((header[0] & 7) << 8) + header[1];
        this.classID = header[2];
        this.commandID = header[3];
    }

    public BGAPIPacket(int msg_type, int classID, int commandID) {
        this.msgType = msg_type;
        this.classID = classID;
        this.commandID = commandID;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("< typ=" + this.msgType + " cla=" + this.classID + " cmd=" + this.commandID + " len=" + this.payloadLength + " ");
        if (this.data.size() > 0) {
            byte[] bytes = this.data.toByteArray();
            result.append("[ ");
            byte[] byArray = bytes;
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                result.append(String.valueOf(Integer.toHexString(b & 0xFF)) + " ");
                ++n2;
            }
            result.append("] ");
        }
        result.append(">");
        return result.toString();
    }

    public BGAPIPacketReader getPayloadReader() {
        return new BGAPIPacketReader(this.data.toByteArray());
    }

    public byte[] getPacketBytes() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        this.payloadLength = this.data.size();
        result.write((this.msgType << 7) + (this.payloadLength >> 8));
        result.write(this.payloadLength & 0xFF);
        result.write(this.classID & 0xFF);
        result.write(this.commandID & 0xFF);
        try {
            result.write(this.data.toByteArray());
        }
        catch (IOException ex) {
            Logger.getLogger(BGAPIPacket.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result.toByteArray();
    }

    public void w_uint8(int v) {
        this.data.write(v & 0xFF);
    }

    public void w_int8(int v) {
        this.data.write(v);
    }

    public void w_uint16(int v) {
        this.data.write(v & 0xFF);
        this.data.write(v >> 8 & 0xFF);
    }

    public void w_int16(int v) {
        this.data.write(v & 0xFF);
        this.data.write(v >> 8 & 0xFF);
    }

    public void w_uint32(int v) {
        this.data.write(v & 0xFF);
        this.data.write(v >> 8 & 0xFF);
        this.data.write(v >> 16 & 0xFF);
        this.data.write(v >> 24 & 0xFF);
    }

    public void w_uint8array(byte[] bytes) {
        this.data.write(bytes.length);
        int i = 0;
        while (i < bytes.length) {
            this.data.write(bytes[i]);
            ++i;
        }
    }

    public void w_bd_addr(BDAddr addr) {
        byte[] bytes = addr.getByteAddr();
        int i = 0;
        while (i < bytes.length) {
            this.data.write(bytes[i]);
            ++i;
        }
    }
}

