/*
 * Decompiled with CFR 0.152.
 */
package org.thingml.bglib;

import org.thingml.bglib.BDAddr;

public class BGAPIPacketReader {
    private byte[] data;
    private int index;

    public BGAPIPacketReader(byte[] data) {
        this.data = data;
    }

    public void reset() {
        this.index = 0;
    }

    public int length() {
        return this.data.length;
    }

    public int bytesLeft() {
        return this.data.length - this.index;
    }

    private Integer next_uint() {
        return this.data[this.index++] & 0xFF;
    }

    public int r_int8() {
        return this.data[this.index++];
    }

    public int r_uint8() {
        return this.next_uint();
    }

    public int r_uint16() {
        int result = this.next_uint();
        return result += this.next_uint() << 8;
    }

    public int r_int16() {
        int result = this.next_uint();
        return result += this.next_uint() << 8;
    }

    public int r_uint32() {
        int result = this.next_uint();
        result += this.next_uint() << 8;
        result += this.next_uint() << 16;
        return result += this.next_uint() << 24;
    }

    public byte[] r_uint8array() {
        byte[] result = new byte[this.next_uint().intValue()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.data[this.index++];
            ++i;
        }
        return result;
    }

    public BDAddr r_bd_addr() {
        byte[] addr = new byte[6];
        int i = 0;
        while (i < 6) {
            addr[i] = this.data[this.index++];
            ++i;
        }
        return new BDAddr(addr);
    }
}

