/*
 * Decompiled with CFR 0.152.
 */
package org.thingml.bglib;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.thingml.bglib.BGAPIPacket;
import org.thingml.bglib.BGAPITransportListener;

public class BGAPITransport
implements Runnable {
    protected List<BGAPITransportListener> listeners = new CopyOnWriteArrayList<BGAPITransportListener>();
    protected InputStream in;
    protected OutputStream out;
    private Thread rxthread = null;
    private long receivedBytes = 0L;
    private boolean terminate = false;
    private static final int WAITING = 0;
    private static final int HEADER = 1;
    private static final int PAYLOAD = 2;
    private static final int HEADER_SIZE = 4;

    public void addListener(BGAPITransportListener l) {
        this.listeners.add(l);
    }

    public void removeListener(BGAPITransportListener l) {
        this.listeners.remove(l);
    }

    public long getReceivedBytes() {
        return this.receivedBytes;
    }

    public BGAPITransport(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        this.rxthread = new Thread(this);
        this.rxthread.start();
    }

    public void sendPacket(BGAPIPacket p) {
        try {
            this.out.write(p.getPacketBytes());
        }
        catch (IOException ex) {
            Logger.getLogger(BGAPITransport.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
        Iterator<BGAPITransportListener> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            iter.next().packetSent(p);
        }
    }

    public void stop() {
        this.terminate = true;
    }

    @Override
    public void run() {
        byte[] buffer = new byte[1024];
        byte[] hdr = new byte[4];
        int len = -1;
        int idx = 0;
        int state = 0;
        BGAPIPacket p = null;
        try {
            while (!this.terminate && (len = this.in.read(buffer)) > -1) {
                this.receivedBytes += (long)len;
                int i = 0;
                while (i < len) {
                    Iterator<BGAPITransportListener> iter;
                    byte c = buffer[i];
                    if (state == 0) {
                        idx = 0;
                        state = 1;
                        hdr[idx++] = c;
                    } else if (state == 1) {
                        hdr[idx++] = c;
                        if (idx == 4) {
                            p = new BGAPIPacket(hdr);
                            if (p.getPayloadLength() > 0) {
                                state = 2;
                                idx = 0;
                            } else {
                                state = 0;
                                iter = this.listeners.iterator();
                                while (iter.hasNext()) {
                                    iter.next().packetReceived(p);
                                }
                                p = null;
                            }
                        }
                    } else if (state == 2) {
                        p.getPayloadData().write(c);
                        if (++idx == p.getPayloadLength()) {
                            state = 0;
                            iter = this.listeners.iterator();
                            while (iter.hasNext()) {
                                iter.next().packetReceived(p);
                            }
                            p = null;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        System.err.println("BLED112: Receiver thread stopped.");
    }
}

